/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import java.util.Iterator;

public class TriangleWavePositionIterator
implements Iterator {
    protected static final int STATE_FIRST = 0;
    protected static final int STATE_LINE = 1;
    protected static final int STATE_WAVE_START = 2;
    protected static final int STATE_TOOTH_PEAK = 3;
    protected int state = 0;
    protected Iterator<? extends Position> positions;
    protected Globe globe;
    protected double amplitude;
    protected Angle halfWaveLength;
    protected Position thisPosition;
    protected Position nextControlPosition;
    protected Position firstPosition;
    protected Position waveEndPosition;
    protected double thisStep;

    public TriangleWavePositionIterator(Iterable<? extends Position> iterable, double d, double d2, Globe globe) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0 || d2 <= 0.0) {
            String string = Logging.getMessage("generic.LengthIsInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.globe = globe;
        this.amplitude = d2;
        this.halfWaveLength = Angle.fromRadians(d / (2.0 * this.globe.getRadius()));
        this.thisStep = this.halfWaveLength.degrees;
        this.positions = iterable.iterator();
        this.firstPosition = this.thisPosition = this.positions.next();
        this.nextControlPosition = this.thisPosition;
    }

    @Override
    public boolean hasNext() {
        return this.nextControlPosition != null;
    }

    public Position next() {
        Position position;
        switch (this.state) {
            case 0: {
                position = this.thisPosition;
                this.state = 1;
                break;
            }
            case 1: {
                position = this.computeNext();
                break;
            }
            case 2: {
                Position position2 = this.thisPosition;
                this.waveEndPosition = this.computeNext();
                Vec4 vec4 = this.globe.computePointFromLocation(position2);
                Vec4 vec42 = this.globe.computePointFromLocation(this.waveEndPosition);
                LatLon latLon = LatLon.interpolateGreatCircle(0.5, position2, this.waveEndPosition);
                Vec4 vec43 = this.globe.computePointFromLocation(latLon);
                Vec4 vec44 = vec42.subtract3(vec4);
                Vec4 vec45 = this.globe.computeSurfaceNormalAtLocation(latLon.latitude, latLon.longitude);
                Vec4 vec46 = vec44.cross3(vec45);
                vec46 = vec46.normalize3().multiply3(this.amplitude);
                Vec4 vec47 = vec43.add3(vec46);
                position = this.globe.computePositionFromPoint(vec47);
                break;
            }
            case 3: {
                position = this.waveEndPosition;
                this.state = 1;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return position;
    }

    protected Position computeNext() {
        Angle angle = LatLon.greatCircleDistance(this.thisPosition, this.nextControlPosition);
        double d = angle.degrees - this.thisStep;
        while (d < 0.0) {
            if (this.positions.hasNext()) {
                this.thisPosition = this.nextControlPosition;
                this.nextControlPosition = this.positions.next();
                if (this.state == 1) {
                    this.thisStep -= angle.degrees;
                    return this.thisPosition;
                }
            } else if (this.firstPosition != null && !this.firstPosition.equals(this.nextControlPosition)) {
                this.thisPosition = this.nextControlPosition;
                this.nextControlPosition = this.firstPosition;
                this.firstPosition = null;
                if (this.state == 1) {
                    this.thisStep -= angle.degrees;
                    return this.thisPosition;
                }
            } else {
                Position position = this.nextControlPosition;
                this.nextControlPosition = null;
                return position;
            }
            this.thisStep -= angle.degrees;
            angle = LatLon.greatCircleDistance(this.thisPosition, this.nextControlPosition);
            d = angle.degrees - this.thisStep;
        }
        Angle angle2 = LatLon.greatCircleAzimuth(this.thisPosition, this.nextControlPosition);
        LatLon latLon = LatLon.greatCircleEndPosition((LatLon)this.thisPosition, angle2, Angle.fromDegrees(this.thisStep));
        switch (this.state) {
            case 1: {
                this.state = 2;
                break;
            }
            case 2: {
                this.state = 3;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.thisStep = this.halfWaveLength.degrees;
        this.thisPosition = new Position(latLon, 0.0);
        return this.thisPosition;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

