/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.SurfaceQuad;
import gov.nasa.worldwind.symbology.TacticalQuad;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AbstractRectangularGraphic
extends AbstractMilStd2525TacticalGraphic
implements TacticalQuad,
PreRenderable {
    protected Iterable<? extends Position> positions;
    protected SurfaceQuad quad = this.createShape();
    protected boolean shapeInvalid;

    public AbstractRectangularGraphic(String string) {
        super(string);
    }

    @Override
    public double getWidth() {
        return this.quad.getHeight();
    }

    @Override
    public void setWidth(double d) {
        this.quad.setHeight(d);
        this.onModifierChanged();
    }

    @Override
    public double getLength() {
        return this.quad.getWidth();
    }

    @Override
    public void setLength(double d) {
        this.quad.setWidth(d);
        this.onModifierChanged();
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        try {
            Position position = iterator.next();
            Position position2 = iterator.next();
            LatLon latLon = LatLon.interpolateGreatCircle(0.5, position, position2);
            this.quad.setCenter(latLon);
            Angle angle = LatLon.greatCircleAzimuth(position2, position);
            this.quad.setHeading(angle.subtract(Angle.POS90));
            this.positions = iterable;
            this.shapeInvalid = true;
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.positions;
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("AM".equalsIgnoreCase(string)) {
            if (object instanceof Double) {
                this.setWidth((Double)object);
            } else if (object instanceof Iterable) {
                Iterator iterator = ((Iterable)object).iterator();
                this.setWidth((Double)iterator.next());
            }
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public Object getModifier(String string) {
        if ("AM".equalsIgnoreCase(string)) {
            return this.getWidth();
        }
        return super.getModifier(string);
    }

    @Override
    public Position getReferencePosition() {
        return this.quad.getReferencePosition();
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        if (this.shapeInvalid) {
            this.computeQuadSize(drawContext);
            this.shapeInvalid = false;
        }
        this.determineActiveAttributes();
        this.quad.preRender(drawContext);
    }

    protected void computeQuadSize(DrawContext drawContext) {
        if (this.positions == null) {
            return;
        }
        Iterator<? extends Position> iterator = this.positions.iterator();
        Position position = iterator.next();
        Position position2 = iterator.next();
        Angle angle = LatLon.greatCircleDistance(position, position2);
        double d = angle.radians * drawContext.getGlobe().getRadius();
        this.quad.setWidth(d);
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        this.quad.render(drawContext);
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        this.quad.setDelegateOwner(object);
    }

    protected SurfaceQuad createShape() {
        SurfaceQuad surfaceQuad = new SurfaceQuad();
        surfaceQuad.setDelegateOwner(this.getActiveDelegateOwner());
        surfaceQuad.setAttributes(this.getActiveShapeAttributes());
        return surfaceQuad;
    }
}

