/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.symbology.milstd2525.graphics.TriangleWavePositionIterator;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BasicArea;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Encirclement
extends BasicArea {
    public static final int DEFAULT_NUM_WAVES = 10;
    protected Iterable<? extends Position> positions;
    protected List<Position> computedPositions;
    protected double waveLength;
    protected SurfacePolygon wavePolygon = this.createPolygon();

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-SAE--------");
    }

    public Encirclement(String string) {
        super(string);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        this.positions = iterable;
        this.computedPositions = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.positions;
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.positions = Position.computeShiftedPositions(position2, position, this.getPositions());
        this.polygon.moveTo(position);
        this.wavePolygon.moveTo(position);
    }

    public double getWaveLength() {
        return this.waveLength;
    }

    public void setWaveLength(double d) {
        this.waveLength = d;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (!this.isVisible()) {
            return;
        }
        super.preRender(drawContext);
        this.wavePolygon.preRender(drawContext);
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        super.doRenderGraphic(drawContext);
        this.wavePolygon.render(drawContext);
    }

    @Override
    protected void computeGeometry(DrawContext drawContext) {
        if (this.computedPositions == null && this.positions != null) {
            this.generateIntermediatePositions(drawContext, this.positions);
            this.polygon.setLocations(this.positions);
            this.wavePolygon.setLocations(this.computedPositions);
        }
        super.computeGeometry(drawContext);
    }

    protected void generateIntermediatePositions(DrawContext drawContext, Iterable<? extends Position> iterable) {
        Globe globe = drawContext.getGlobe();
        ArrayList<Position> arrayList = new ArrayList<Position>();
        double d = this.getWaveLength();
        if (d == 0.0) {
            d = this.computeDefaultWavelength(drawContext.getGlobe());
        }
        double d2 = d / 2.0;
        TriangleWavePositionIterator triangleWavePositionIterator = new TriangleWavePositionIterator(iterable, d, d2, globe);
        while (triangleWavePositionIterator.hasNext()) {
            arrayList.add(triangleWavePositionIterator.next());
        }
        this.computedPositions = arrayList;
    }

    protected double computeDefaultWavelength(Globe globe) {
        double d = 0.0;
        int n = 0;
        Position position = null;
        Position position2 = null;
        for (Position position3 : this.positions) {
            if (position2 != null) {
                Angle angle = LatLon.greatCircleDistance(position3, position2);
                d += angle.radians;
            } else {
                position = position3;
            }
            position2 = position3;
            ++n;
        }
        if (position2 != null && !position2.equals(position)) {
            Angle angle = LatLon.greatCircleDistance(position, position2);
            d += angle.radians;
        }
        double d2 = Math.sqrt((double)n / 3.0);
        return (d *= globe.getRadius()) / (d2 * 10.0);
    }
}

