/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BasicArea;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FortifiedArea
extends BasicArea {
    public static final int DEFAULT_NUM_WAVES = 20;
    protected Iterable<? extends Position> positions;
    protected List<Position> computedPositions;
    protected double waveLength;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-GAF--------");
    }

    public FortifiedArea(String string) {
        super(string);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        this.positions = iterable;
        this.computedPositions = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.positions;
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.positions = Position.computeShiftedPositions(position2, position, this.getPositions());
        this.polygon.moveTo(position);
    }

    public double getWaveLength() {
        return this.waveLength;
    }

    public void setWaveLength(double d) {
        this.waveLength = d;
    }

    @Override
    public void computeGeometry(DrawContext drawContext) {
        if (this.computedPositions == null && this.positions != null) {
            this.generateIntermediatePositions(drawContext, this.positions);
            this.polygon.setLocations(this.computedPositions);
        }
        super.computeGeometry(drawContext);
    }

    protected void generateIntermediatePositions(DrawContext drawContext, Iterable<? extends Position> iterable) {
        Iterator<? extends Position> iterator = iterable.iterator();
        Globe globe = drawContext.getGlobe();
        ArrayList<Position> arrayList = new ArrayList<Position>();
        double d = this.getWaveLength();
        if (d == 0.0) {
            d = this.computeDefaultWavelength(drawContext.getGlobe());
        }
        double d2 = d / 2.0;
        boolean bl = true;
        Position position = iterator.next();
        Vec4 vec4 = globe.computePointFromPosition(position);
        Position position2 = iterator.next();
        Vec4 vec42 = globe.computePointFromPosition(position2);
        while (true) {
            double d3 = vec42.distanceTo3(vec4);
            Position position3 = globe.computePositionFromPoint(vec4);
            arrayList.add(position3);
            while (d3 < d2 && iterator.hasNext()) {
                if (!bl) {
                    arrayList.add(position2);
                }
                position2 = iterator.next();
                vec42 = globe.computePointFromPosition(position2);
                d3 = vec42.distanceTo3(vec4);
            }
            if (d3 < d2) {
                if (position.equals(position2)) break;
                position2 = position;
                vec42 = globe.computePointFromPosition(position2);
            }
            Vec4 vec43 = vec42.subtract3(vec4).normalize3();
            Vec4 vec44 = vec4.add3(vec43.multiply3(d2));
            if (bl) {
                Vec4 vec45 = globe.computeSurfaceNormalAtPoint(vec4);
                Vec4 vec46 = vec43.cross3(vec45);
                vec46 = vec46.normalize3().multiply3(d2);
                Vec4 vec47 = vec4.subtract3(vec46);
                Vec4 vec48 = vec44.subtract3(vec46);
                arrayList.add(globe.computePositionFromPoint(vec47));
                arrayList.add(globe.computePositionFromPoint(vec48));
            }
            position3 = globe.computePositionFromPoint(vec44);
            arrayList.add(position3);
            vec4 = vec44;
            bl = !bl;
        }
        this.computedPositions = arrayList;
    }

    protected double computeDefaultWavelength(Globe globe) {
        double d = 0.0;
        int n = 0;
        Vec4 vec4 = null;
        Vec4 vec42 = null;
        for (Position position : this.positions) {
            Vec4 vec43 = globe.computePointFromPosition(position);
            if (vec42 != null) {
                d += vec43.distanceTo3(vec42);
            } else {
                vec4 = vec43;
            }
            vec42 = vec43;
            ++n;
        }
        if (vec42 != null && !vec42.equals(vec4)) {
            d += vec42.distanceTo3(vec4);
        }
        double d2 = Math.sqrt((double)n / 3.0);
        return d / (d2 * 20.0);
    }
}

