/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.LimitedAccessSymbol;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LimitedAccessArea
extends AbstractMilStd2525TacticalGraphic {
    protected TacticalSymbol symbol;
    protected Path path;
    protected Position symbolPosition;
    protected Position attachmentPosition;
    protected int altitudeMode = 1;
    protected TacticalSymbolAttributes symbolAttributes;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-GAY--------");
    }

    public LimitedAccessArea(String string) {
        super(string);
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("A".equals(string) && object instanceof String) {
            this.setSymbol((String)object);
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public Object getModifier(String string) {
        if ("A".equals(string)) {
            return this.getSymbol();
        }
        return super.getModifier(string);
    }

    public String getSymbol() {
        return this.symbol != null ? this.symbol.getIdentifier() : null;
    }

    public void setSymbol(String string) {
        if (string != null) {
            if (this.symbolAttributes == null) {
                this.symbolAttributes = new BasicTacticalSymbolAttributes();
            }
            this.symbol = this.createSymbol(string);
        } else {
            this.symbol = null;
            this.symbolAttributes = null;
        }
        this.onModifierChanged();
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
        if (this.symbol != null) {
            this.symbol.setAltitudeMode(n);
        }
        if (this.path != null) {
            this.path.setAltitudeMode(n);
        }
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        if (this.symbol != null) {
            this.symbol.render(drawContext);
        }
        if (this.path != null) {
            this.path.render(drawContext);
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.symbol != null) {
            this.symbol.setDelegateOwner(object);
        }
        if (this.path != null) {
            this.path.setDelegateOwner(object);
        }
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        if (this.symbolPosition != null) {
            arrayList.add(this.symbolPosition);
        }
        if (this.attachmentPosition != null) {
            arrayList.add(this.attachmentPosition);
        }
        return arrayList;
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends Position> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.symbolPosition = iterator.next();
        if (iterator.hasNext()) {
            this.attachmentPosition = iterator.next();
        }
        if (this.symbol != null) {
            this.symbol.setPosition(this.symbolPosition);
        }
        if (this.attachmentPosition != null) {
            if (this.path == null) {
                this.path = this.createPath();
            }
            this.path.setPositions(Arrays.asList(this.symbolPosition, this.attachmentPosition));
        }
    }

    @Override
    public Position getReferencePosition() {
        return this.symbolPosition;
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        if (this.symbolAttributes != null) {
            ShapeAttributes shapeAttributes = this.getActiveShapeAttributes();
            this.symbolAttributes.setOpacity(shapeAttributes.getInteriorOpacity());
            this.symbolAttributes.setScale(this.activeOverrides.getScale());
        }
    }

    protected TacticalSymbol createSymbol(String string) {
        Position position = this.getReferencePosition();
        LimitedAccessSymbol limitedAccessSymbol = new LimitedAccessSymbol(string, position != null ? position : Position.ZERO);
        limitedAccessSymbol.setDelegateOwner(this);
        limitedAccessSymbol.setAttributes(this.symbolAttributes);
        limitedAccessSymbol.setAltitudeMode(this.getAltitudeMode());
        return limitedAccessSymbol;
    }

    protected Path createPath() {
        Path path = new Path();
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.Linear");
        path.setAltitudeMode(this.getAltitudeMode());
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

