/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AbstractRectangularGraphic;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RectangularPositionArea
extends AbstractRectangularGraphic {
    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-ACPR-------");
    }

    public RectangularPositionArea(String string) {
        super(string);
    }

    @Override
    protected void createLabels() {
        this.addLabel("PAA");
        this.addLabel("PAA");
        this.addLabel("PAA");
        this.addLabel("PAA");
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        Iterable<? extends LatLon> iterable = this.quad.getLocations(drawContext.getGlobe());
        if (iterable == null) {
            return;
        }
        Iterator<? extends LatLon> iterator = iterable.iterator();
        LatLon latLon = iterator.next();
        for (int i = 0; iterator.hasNext() && i < this.labels.size(); ++i) {
            LatLon latLon2 = iterator.next();
            LatLon latLon3 = LatLon.interpolateGreatCircle(0.5, latLon, latLon2);
            ((TacticalGraphicLabel)this.labels.get(i)).setPosition(new Position(latLon3, 0.0));
            latLon = latLon2;
        }
    }
}

