/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractAxisArrow
extends AbstractMilStd2525TacticalGraphic {
    protected Path[] paths;
    protected Iterable<? extends Position> positions;
    protected List<? extends Position> arrowPositions;
    protected boolean finalPointWidthOfRoute;

    public AbstractAxisArrow(String string) {
        this(string, 1);
    }

    public AbstractAxisArrow(String string, int n) {
        super(string);
        if (n < 1) {
            String string2 = Logging.getMessage("generic.ArrayInvalidLength", n);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.paths = new Path[n];
        for (int i = 0; i < n; ++i) {
            this.paths[i] = this.createPath();
        }
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            iterator.next();
            iterator.next();
            iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.positions = iterable;
        this.arrowPositions = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.positions;
    }

    @Override
    public Position getReferencePosition() {
        if (this.positions != null) {
            return this.positions.iterator().next();
        }
        return null;
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        if (this.arrowPositions == null) {
            this.createShapePositions(drawContext);
        }
        for (Path path : this.paths) {
            path.render(drawContext);
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.paths == null) {
            return;
        }
        for (Path path : this.paths) {
            path.setDelegateOwner(object);
        }
    }

    public boolean isFinalPointWidthOfRoute() {
        return this.finalPointWidthOfRoute;
    }

    public void setFinalPointWidthOfRoute(boolean bl) {
        this.finalPointWidthOfRoute = bl;
    }

    protected void createShapePositions(DrawContext drawContext) {
        Globe globe = drawContext.getGlobe();
        ArrayList<Position> arrayList = new ArrayList<Position>();
        ArrayList<Position> arrayList2 = new ArrayList<Position>();
        ArrayList<Position> arrayList3 = new ArrayList<Position>();
        double d = this.createArrowHeadPositions(arrayList, arrayList2, arrayList3, globe);
        this.createLinePositions(arrayList, arrayList2, d, globe);
        Collections.reverse(arrayList);
        ArrayList<Position> arrayList4 = new ArrayList<Position>(arrayList);
        arrayList4.addAll(arrayList3);
        arrayList4.addAll(arrayList2);
        this.arrowPositions = arrayList4;
        this.paths[0].setPositions(arrayList4);
    }

    protected double createArrowHeadPositions(List<Position> list, List<Position> list2, List<Position> list3, Globe globe) {
        Iterator<? extends Position> iterator = this.positions.iterator();
        Position position = iterator.next();
        Position position2 = iterator.next();
        Position position3 = null;
        while (iterator.hasNext()) {
            position3 = iterator.next();
        }
        if (position3 == null) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = globe.computePointFromLocation(position);
        Vec4 vec42 = globe.computePointFromLocation(position2);
        Vec4 vec43 = globe.computePointFromLocation(position3);
        Vec4 vec44 = vec4.subtract3(vec42).normalize3();
        Vec4 vec45 = vec4.add3(vec44.multiply3(vec43.subtract3(vec4).dot3(vec44)));
        if (this.isFinalPointWidthOfRoute()) {
            vec43 = vec43.add3(vec43.subtract3(vec45));
            position3 = globe.computePositionFromPoint(vec43);
        }
        Vec4 vec46 = vec45.subtract3(vec43.subtract3(vec45));
        Vec4 vec47 = globe.computeSurfaceNormalAtPoint(vec45);
        double d = vec43.subtract3(vec45).getLength3() / 2.0;
        Vec4 vec48 = vec47.cross3(vec44).normalize3().multiply3(d);
        Vec4 vec49 = vec45.add3(vec48);
        Vec4 vec410 = vec45.subtract3(vec48);
        Position position4 = globe.computePositionFromPoint(vec49);
        Position position5 = globe.computePositionFromPoint(vec410);
        list.add(position4);
        list2.add(position5);
        Position position6 = globe.computePositionFromPoint(vec46);
        double d2 = vec48.dot3(vec43.subtract3(vec45));
        if (d2 < 0.0) {
            Position position7 = position3;
            position3 = position6;
            position6 = position7;
        }
        list3.add(position3);
        list3.add(position);
        list3.add(position6);
        return d;
    }

    protected void createLinePositions(List<Position> list, List<Position> list2, double d, Globe globe) {
        Iterator<? extends Position> iterator = this.positions.iterator();
        Position position = iterator.next();
        Position position2 = iterator.next();
        Vec4 vec4 = globe.computePointFromLocation(position2);
        Vec4 vec42 = globe.computePointFromLocation(position);
        while (iterator.hasNext()) {
            double d2;
            Vec4 vec43;
            Object object;
            position2 = iterator.next();
            Vec4 vec44 = vec42;
            vec42 = vec4;
            vec4 = globe.computePointFromLocation(position2);
            Vec4 vec45 = globe.computeSurfaceNormalAtPoint(vec42);
            Vec4 vec46 = vec44.subtract3(vec42);
            Vec4 vec47 = vec46.cross3(vec45);
            if (iterator.hasNext() && !Vec4.areColinear(vec4, vec42, vec44)) {
                object = vec4.subtract3(vec42);
                vec43 = ((Vec4)object).normalize3().add3(vec46.normalize3());
                d2 = vec47.dot3(vec43 = vec43.normalize3());
                if (d2 < 0.0) {
                    vec43 = vec43.multiply3(-1.0);
                }
            } else {
                vec43 = vec47.normalize3();
            }
            object = vec46.angleBetween3(vec43);
            d2 = d / ((Angle)object).sin();
            vec43 = vec43.multiply3(d2);
            Vec4 vec48 = vec42.add3(vec43);
            Vec4 vec49 = vec42.subtract3(vec43);
            Position position3 = globe.computePositionFromPoint(vec49);
            Position position4 = globe.computePositionFromPoint(vec48);
            list.add(position3);
            list2.add(position4);
        }
    }

    protected Path createPath() {
        Path path = new Path();
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

