/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.DirectionOfAttack;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectionOfAttackAviation
extends DirectionOfAttack {
    public static final int DEFAULT_NUM_INTERVALS = 32;
    public static final double DEFAULT_BOW_TIE_LENGTH = 0.05;
    public static final double DEFAULT_BOW_TIE_WIDTH = 0.25;
    public static final Angle DEFAULT_CURVATURE = Angle.fromDegrees(25.0);
    protected int intervals = 32;
    protected double bowTieLength = 0.05;
    protected double bowTieWidth = 0.25;
    protected Angle curvature = DEFAULT_CURVATURE;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-OLKA-------");
    }

    public DirectionOfAttackAviation(String string) {
        super(string);
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
        this.onShapeChanged();
    }

    public double getBowTieLength() {
        return this.bowTieLength;
    }

    public void setBowTieLength(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.bowTieLength = d;
    }

    public double getBowTieWidth() {
        return this.bowTieWidth;
    }

    public void setBowTieWidth(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.bowTieWidth = d;
    }

    public Angle getCurvature() {
        return this.curvature;
    }

    public void setCurvature(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.curvature = angle;
    }

    protected void onShapeChanged() {
        this.paths = null;
    }

    @Override
    protected void createShapes(DrawContext drawContext) {
        double d;
        int n;
        this.paths = new Path[4];
        ArrayList<Position> arrayList = new ArrayList<Position>();
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromLocation(this.startPosition);
        Vec4 vec42 = globe.computePointFromLocation(this.endPosition);
        Vec4 vec43 = vec42.subtract3(vec4);
        Vec4 vec44 = globe.computeSurfaceNormalAtPoint(vec4);
        Matrix matrix = Matrix.fromAxisAngle(this.getCurvature(), vec44);
        vec43 = vec43.transformBy3(matrix);
        int n2 = this.getIntervals();
        double d2 = 1.0 / (double)n2;
        for (n = 0; n < n2; ++n) {
            d = (double)n * d2;
            Vec4 vec45 = this.hermiteCurve(vec4, vec42, vec43, vec43, d);
            Position position = globe.computePositionFromPoint(vec45);
            arrayList.add(position);
        }
        arrayList.add(this.endPosition);
        n = arrayList.size();
        d = this.getBowTieLength();
        int n3 = (int)((double)n * (0.5 - d));
        int n4 = (int)((double)n * (0.5 + d));
        n3 = WWMath.clamp(n3, 0, n);
        n4 = WWMath.clamp(n4, 0, n);
        Position position = (Position)arrayList.get(n3);
        Position position2 = (Position)arrayList.get(n4);
        this.paths[0] = this.createPath(arrayList.subList(0, n3 + 1));
        this.paths[1] = this.createPath(arrayList.subList(n4, n));
        double d3 = vec42.subtract3(vec4).getLength3() * this.getArrowLength();
        List<Position> list = this.computeArrowheadPositions(drawContext, vec42, vec43.multiply3(-1.0), d3);
        this.paths[2] = this.createPath(list);
        list = this.createBowTie(drawContext, position, position2);
        this.paths[3] = this.createPath(list);
    }

    protected List<Position> createBowTie(DrawContext drawContext, Position position, Position position2) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromLocation(position);
        Vec4 vec42 = globe.computePointFromLocation(position2);
        Vec4 vec43 = vec42.subtract3(vec4);
        double d = vec4.subtract3(vec42).getLength3() * this.getBowTieWidth();
        Vec4 vec44 = globe.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec45 = vec43.cross3(vec44);
        vec45 = vec45.normalize3().multiply3(d);
        Vec4 vec46 = vec4.add3(vec45);
        Vec4 vec47 = vec4.subtract3(vec45);
        vec44 = globe.computeSurfaceNormalAtPoint(vec42);
        vec45 = vec43.cross3(vec44);
        vec45 = vec45.normalize3().multiply3(d);
        Vec4 vec48 = vec42.add3(vec45);
        Vec4 vec49 = vec42.subtract3(vec45);
        return TacticalGraphicUtil.asPositionList(globe, vec46, vec47, vec48, vec49, vec46);
    }

    protected Vec4 hermiteCurve(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, double d) {
        double d2 = 1.0 - 3.0 * d * d + 2.0 * Math.pow(d, 3.0);
        double d3 = (3.0 - 2.0 * d) * d * d;
        double d4 = d * Math.pow(d - 1.0, 2.0);
        double d5 = (d - 1.0) * d * d;
        return vec4.multiply3(d2).add3(vec42.multiply3(d3)).add3(vec43.multiply3(d4)).add3(vec44.multiply3(d5));
    }

    @Override
    protected void createLabels() {
        if (this.mustShowHostileIndicator()) {
            this.addLabel("ENY");
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (WWUtil.isEmpty(this.labels) || this.paths == null) {
            return;
        }
        Angle angle = LatLon.greatCircleDistance(this.startPosition, this.endPosition);
        double d = angle.radians * drawContext.getGlobe().getRadius();
        Iterable<? extends Position> iterable = this.paths[0].getPositions();
        TacticalGraphicUtil.placeLabelsOnPath(drawContext, iterable, (TacticalGraphicLabel)this.labels.get(0), null, 0.1 * d);
    }
}

