/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.FireSupportLine;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.List;

public class MunitionFlightPath
extends FireSupportLine {
    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-LCM--------");
    }

    public MunitionFlightPath(String string) {
        super(string);
    }

    @Override
    protected void createLabels() {
        this.addLabel("MFP");
        Offset offset = this.getBottomLabelOffset();
        String string = this.getBottomLabelText();
        if (!WWUtil.isEmpty(string)) {
            TacticalGraphicLabel tacticalGraphicLabel = this.addLabel(string);
            tacticalGraphicLabel.setOffset(offset);
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (this.labels == null || this.labels.size() == 0) {
            return;
        }
        Object[] objectArray = this.computePathLength(drawContext);
        double d = (Double)objectArray[2];
        Iterable<? extends Position> iterable = this.getPositions();
        TacticalGraphicLabel tacticalGraphicLabel = (TacticalGraphicLabel)this.labels.get(0);
        TacticalGraphicUtil.placeLabelsOnPath(drawContext, iterable, tacticalGraphicLabel, null, d * 0.5);
        if (this.labels.size() > 1) {
            tacticalGraphicLabel = (TacticalGraphicLabel)this.labels.get(1);
            TacticalGraphicUtil.placeLabelsOnPath(drawContext, iterable, tacticalGraphicLabel, null, d * 0.25);
        }
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        return TacticalGraphicLabel.DEFAULT_OFFSET;
    }
}

