/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PhaseLine
extends AbstractMilStd2525TacticalGraphic {
    protected static final int PLD_OUTLINE_STIPPLE_FACTOR = 12;
    protected Path path = this.createPath();

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-GLP--------", "G-G-GLL--------", "G-G-OLF--------", "G-G-OLL--------", "G-G-OLT--------", "G-G-OLC--------", "G-G-OLP--------", "G-G-SLR--------", "G-F-LCN--------");
    }

    public PhaseLine(String string) {
        super(string);
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            iterator.next();
            iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.path.setPositions(iterable);
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.path.getPositions();
    }

    @Override
    public Position getReferencePosition() {
        return this.path.getReferencePosition();
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        this.path.render(drawContext);
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        this.path.setDelegateOwner(object);
    }

    protected Path createPath() {
        Path path = new Path();
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }

    protected String getGraphicLabel() {
        String string = this.maskedSymbolCode;
        String string2 = null;
        if ("G-G-GLP--------".equalsIgnoreCase(string)) {
            string2 = "PL %s";
        } else if ("G-G-GLL--------".equalsIgnoreCase(string)) {
            string2 = "LL\n(PL %s)";
        } else if ("G-G-OLF--------".equalsIgnoreCase(string)) {
            string2 = "FINAL CL\n(PL %s)";
        } else if ("G-G-OLL--------".equalsIgnoreCase(string)) {
            string2 = "LOA\n(PL %s)";
        } else if ("G-G-OLT--------".equalsIgnoreCase(string)) {
            string2 = "LD\n(PL %s)";
        } else if ("G-G-OLC--------".equalsIgnoreCase(string)) {
            string2 = "LD/LC\n(PL %s)";
        } else if ("G-G-OLP--------".equalsIgnoreCase(string)) {
            string2 = "PLD\n(PL %s)";
        } else if ("G-G-SLR--------".equalsIgnoreCase(string)) {
            string2 = "RL\n(PL %s)";
        } else if ("G-F-LCN--------".equalsIgnoreCase(string)) {
            string2 = "NFL\n(PL %s)";
        }
        if (string2 != null) {
            String string3 = this.getText();
            return String.format(string2, string3 != null ? string3 : "");
        }
        return "";
    }

    @Override
    protected void createLabels() {
        String string = this.getGraphicLabel();
        this.addLabel(string);
        this.addLabel(string);
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        Position position;
        Iterator<? extends Position> iterator = this.path.getPositions().iterator();
        Position position2 = position = iterator.next();
        while (iterator.hasNext()) {
            position2 = iterator.next();
        }
        TacticalGraphicLabel tacticalGraphicLabel = (TacticalGraphicLabel)this.labels.get(0);
        TacticalGraphicLabel tacticalGraphicLabel2 = (TacticalGraphicLabel)this.labels.get(1);
        tacticalGraphicLabel.setPosition(position);
        tacticalGraphicLabel2.setPosition(position2);
        if (position.longitude.degrees < position2.longitude.degrees) {
            tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Right");
            tacticalGraphicLabel2.setTextAlign("gov.nasa.worldwind.avkey.Left");
        } else {
            tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Left");
            tacticalGraphicLabel2.setTextAlign("gov.nasa.worldwind.avkey.Right");
        }
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        super.applyDefaultAttributes(shapeAttributes);
        if ("G-G-OLP--------".equalsIgnoreCase(this.maskedSymbolCode)) {
            shapeAttributes.setOutlineStippleFactor(12);
            shapeAttributes.setOutlineStipplePattern(this.getOutlineStipplePattern());
        }
    }
}

