/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalPoint;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AbstractCircularGraphic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PullUpPoint
extends AbstractCircularGraphic
implements TacticalPoint,
PreRenderable {
    public static final double DEFAULT_RADIUS = 1000.0;
    protected Path bowtie;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-APU--------");
    }

    public PullUpPoint(String string) {
        super(string);
        this.setRadius(1000.0);
    }

    @Override
    protected void reset() {
        this.bowtie = null;
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        super.doRenderGraphic(drawContext);
        if (this.bowtie == null) {
            this.bowtie = this.createBowtie(drawContext);
        }
        this.bowtie.render(drawContext);
    }

    protected Path createBowtie(DrawContext drawContext) {
        LatLon latLon = this.circle.getCenter();
        double d = this.circle.getRadius() * 0.75;
        Angle angle = Angle.fromRadians(d / drawContext.getGlobe().getRadius());
        LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, Angle.fromDegrees(-65.0), angle);
        LatLon latLon3 = LatLon.greatCircleEndPosition(latLon, Angle.fromDegrees(-115.0), angle);
        LatLon latLon4 = LatLon.greatCircleEndPosition(latLon, Angle.fromDegrees(65.0), angle);
        LatLon latLon5 = LatLon.greatCircleEndPosition(latLon, Angle.fromDegrees(115.0), angle);
        Path path = this.createPath();
        path.setPositions(this.asPositionList(latLon2, latLon3, latLon4, latLon5, latLon2));
        return path;
    }

    protected List<Position> asPositionList(LatLon ... latLonArray) {
        ArrayList<Position> arrayList = new ArrayList<Position>(latLonArray.length);
        for (LatLon latLon : latLonArray) {
            arrayList.add(new Position(latLon, 0.0));
        }
        return arrayList;
    }

    @Override
    protected void createLabels() {
        TacticalGraphicLabel tacticalGraphicLabel = this.addLabel("PUP");
        tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Left");
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        LatLon latLon = this.circle.getCenter();
        double d = this.circle.getRadius() * 1.1;
        Angle angle = Angle.fromRadians(d / drawContext.getGlobe().getRadius());
        LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, Angle.POS90, angle);
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(new Position(latLon2, 0.0));
    }

    protected Path createPath() {
        Path path = new Path();
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this);
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

