/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Triangle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.terrain.Tessellator;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;

public class RectangularTessellator
extends WWObjectImpl
implements Tessellator {
    protected static final int DEFAULT_MAX_LEVEL = 30;
    protected static final double DEFAULT_LOG10_RESOLUTION_TARGET = 1.3;
    protected static final int DEFAULT_NUM_LAT_SUBDIVISIONS = 3;
    protected static final int DEFAULT_NUM_LON_SUBDIVISIONS = 6;
    protected static final int DEFAULT_DENSITY = 20;
    protected static final String CACHE_NAME = "Terrain";
    protected static final String CACHE_ID = RectangularTessellator.class.getName();
    protected static final HashMap<Integer, FloatBuffer> textureCoords = new HashMap();
    protected static final HashMap<Integer, IntBuffer> indexLists = new HashMap();
    protected static final HashMap<Integer, ByteBuffer> oddRowColorList = new HashMap();
    protected static final HashMap<Integer, ByteBuffer> evenRowColorList = new HashMap();
    protected static final HashMap<Integer, Object> textureCoordVboCacheKeys = new HashMap();
    protected static final HashMap<Integer, Object> indexListsVboCacheKeys = new HashMap();
    protected int numLevel0LatSubdivisions = 3;
    protected int numLevel0LonSubdivisions = 6;
    protected ArrayList<RectTile> topLevels;
    protected PickSupport pickSupport = new PickSupport();
    protected SectorGeometryList currentTiles = new SectorGeometryList();
    protected Frustum currentFrustum;
    protected Sector currentCoverage;
    protected boolean makeTileSkirts = true;
    protected int currentLevel;
    protected int maxLevel = 30;
    protected Globe globe;
    protected int density = 20;
    protected long updateFrequency = 2000L;

    @Override
    public SectorGeometryList tessellate(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getView() == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!WorldWind.getMemoryCacheSet().containsCache(CACHE_ID)) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.SectorGeometryCacheSize", 10000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName(CACHE_NAME);
            WorldWind.getMemoryCacheSet().addCache(CACHE_ID, basicMemoryCache);
        }
        this.maxLevel = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.RectangularTessellatorMaxLevel", 30);
        if (this.topLevels == null) {
            this.topLevels = this.createTopLevelTiles(drawContext);
        }
        this.currentTiles.clear();
        this.currentLevel = 0;
        this.currentCoverage = null;
        this.currentFrustum = drawContext.getView().getFrustumInModelCoordinates();
        for (SectorGeometry sectorGeometry : this.topLevels) {
            this.selectVisibleTiles(drawContext, (RectTile)sectorGeometry);
        }
        this.currentTiles.setSector(this.currentCoverage);
        for (SectorGeometry sectorGeometry : this.currentTiles) {
            this.makeVerts(drawContext, (RectTile)sectorGeometry);
        }
        return this.currentTiles;
    }

    protected ArrayList<RectTile> createTopLevelTiles(DrawContext drawContext) {
        ArrayList<RectTile> arrayList = new ArrayList<RectTile>(this.numLevel0LatSubdivisions * this.numLevel0LonSubdivisions);
        this.globe = drawContext.getGlobe();
        double d = 180.0 / (double)this.numLevel0LatSubdivisions;
        double d2 = 360.0 / (double)this.numLevel0LonSubdivisions;
        Angle angle = Angle.NEG90;
        for (int i = 0; i < this.numLevel0LatSubdivisions; ++i) {
            Angle angle2 = angle.addDegrees(d);
            if (angle2.getDegrees() + 1.0 > 90.0) {
                angle2 = Angle.POS90;
            }
            Angle angle3 = Angle.NEG180;
            for (int j = 0; j < this.numLevel0LonSubdivisions; ++j) {
                Angle angle4 = angle3.addDegrees(d2);
                if (angle4.getDegrees() + 1.0 > 180.0) {
                    angle4 = Angle.POS180;
                }
                Sector sector = new Sector(angle, angle2, angle3, angle4);
                arrayList.add(this.createTile(drawContext, sector, 0));
                angle3 = angle4;
            }
            angle = angle2;
        }
        return arrayList;
    }

    protected RectTile createTile(DrawContext drawContext, Sector sector, int n) {
        Box box = Sector.computeBoundingBox(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), sector);
        return new RectTile(this, box, n, this.density, sector);
    }

    @Override
    public boolean isMakeTileSkirts() {
        return this.makeTileSkirts;
    }

    @Override
    public void setMakeTileSkirts(boolean bl) {
        this.makeTileSkirts = bl;
    }

    @Override
    public long getUpdateFrequency() {
        return this.updateFrequency;
    }

    @Override
    public void setUpdateFrequency(long l) {
        this.updateFrequency = l;
    }

    protected void selectVisibleTiles(DrawContext drawContext, RectTile rectTile) {
        Extent extent = rectTile.getExtent();
        if (extent != null && !extent.intersects(this.currentFrustum)) {
            return;
        }
        if (this.currentLevel < this.maxLevel - 1 && !this.atBestResolution(drawContext, rectTile) && this.needToSplit(drawContext, rectTile)) {
            RectTile[] rectTileArray;
            ++this.currentLevel;
            for (RectTile rectTile2 : rectTileArray = this.split(drawContext, rectTile)) {
                this.selectVisibleTiles(drawContext, rectTile2);
            }
            --this.currentLevel;
            return;
        }
        this.currentCoverage = rectTile.getSector().union(this.currentCoverage);
        this.currentTiles.add(rectTile);
    }

    protected boolean atBestResolution(DrawContext drawContext, RectTile rectTile) {
        double d = drawContext.getGlobe().getElevationModel().getBestResolution(rectTile.getSector());
        return rectTile.getCellSize() <= d;
    }

    protected boolean needToSplit(DrawContext drawContext, RectTile rectTile) {
        double d = rectTile.getCellSize();
        double d2 = drawContext.getGlobe().getRadius() * d;
        double d3 = Math.pow(10.0, -this.computeTileResolutionTarget(drawContext, rectTile));
        double d4 = drawContext.getView().getFieldOfView().tanHalfAngle() / Angle.fromDegrees(45.0).tanHalfAngle();
        d4 = WWMath.clamp(d4, 0.0, 1.0);
        double d5 = rectTile.getSector().distanceTo(drawContext, drawContext.getView().getEyePoint());
        double d6 = d5 * d3 * d4;
        return d2 > d6;
    }

    protected double computeTileResolutionTarget(DrawContext drawContext, RectTile rectTile) {
        return 1.3 + drawContext.getGlobe().getElevationModel().getDetailHint(rectTile.sector);
    }

    protected RectTile[] split(DrawContext drawContext, RectTile rectTile) {
        Sector[] sectorArray = rectTile.sector.subdivide();
        RectTile[] rectTileArray = new RectTile[]{this.createTile(drawContext, sectorArray[0], rectTile.level + 1), this.createTile(drawContext, sectorArray[1], rectTile.level + 1), this.createTile(drawContext, sectorArray[2], rectTile.level + 1), this.createTile(drawContext, sectorArray[3], rectTile.level + 1)};
        return rectTileArray;
    }

    protected CacheKey createCacheKey(DrawContext drawContext, RectTile rectTile) {
        return new CacheKey(drawContext, rectTile.sector, rectTile.density);
    }

    protected void makeVerts(DrawContext drawContext, RectTile rectTile) {
        MemoryCache memoryCache = WorldWind.getMemoryCache(CACHE_ID);
        CacheKey cacheKey = this.createCacheKey(drawContext, rectTile);
        rectTile.ri = (RenderInfo)memoryCache.getObject(cacheKey);
        if (rectTile.ri != null && rectTile.ri.time >= System.currentTimeMillis() - this.getUpdateFrequency()) {
            return;
        }
        if (this.buildVerts(drawContext, rectTile, this.makeTileSkirts)) {
            memoryCache.add(cacheKey, rectTile.ri, rectTile.ri.getSizeInBytes());
        }
    }

    public boolean buildVerts(DrawContext drawContext, RectTile rectTile, boolean bl) {
        Double d;
        FloatBuffer floatBuffer;
        int n = rectTile.density;
        int n2 = (n + 3) * (n + 3);
        if (rectTile.ri == null || rectTile.ri.vertices == null || n != rectTile.ri.density) {
            floatBuffer = Buffers.newDirectFloatBuffer((int)(n2 * 3));
        } else {
            floatBuffer = rectTile.ri.vertices;
            floatBuffer.rewind();
        }
        ArrayList<LatLon> arrayList = this.computeLocations(rectTile);
        double[] dArray = new double[arrayList.size()];
        drawContext.getGlobe().getElevations(rectTile.sector, arrayList, rectTile.getResolution(), dArray);
        double d2 = drawContext.getVerticalExaggeration();
        Double d3 = d = bl ? Double.valueOf(this.globe.getMinElevation()) : null;
        if (d != null && (d < 0.0 || d2 <= 0.0)) {
            d = d * d2;
        }
        LatLon latLon = rectTile.sector.getCentroid();
        Vec4 vec4 = this.globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
        int n3 = 0;
        int n4 = 0;
        Iterator<LatLon> iterator = arrayList.iterator();
        for (int i = 0; i <= n + 2; ++i) {
            for (int j = 0; j <= n + 2; ++j) {
                LatLon latLon2 = iterator.next();
                double d4 = d2 * dArray[n3++];
                if (d != null && (i == 0 || i >= rectTile.density + 2 || j == 0 || j >= rectTile.density + 2)) {
                    d4 = d;
                }
                Vec4 vec42 = this.globe.computePointFromPosition(latLon2.getLatitude(), latLon2.getLongitude(), d4);
                floatBuffer.put(n4++, (float)(vec42.x - vec4.x));
                floatBuffer.put(n4++, (float)(vec42.y - vec4.y));
                floatBuffer.put(n4++, (float)(vec42.z - vec4.z));
            }
        }
        floatBuffer.rewind();
        if (rectTile.ri != null) {
            rectTile.ri.update(drawContext);
            return false;
        }
        rectTile.ri = new RenderInfo(drawContext, n, floatBuffer, vec4);
        return true;
    }

    protected ArrayList<LatLon> computeLocations(RectTile rectTile) {
        int n = rectTile.density;
        int n2 = (n + 3) * (n + 3);
        Angle angle = rectTile.sector.getMaxLatitude();
        Angle angle2 = rectTile.sector.getDeltaLat().divide(n);
        Angle angle3 = rectTile.sector.getMinLatitude();
        Angle angle4 = rectTile.sector.getMinLongitude();
        Angle angle5 = rectTile.sector.getMaxLongitude();
        Angle angle6 = rectTile.sector.getDeltaLon().divide(n);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(n2);
        for (int i = 0; i <= n + 2; ++i) {
            Angle angle7 = angle4;
            for (int j = 0; j <= n + 2; ++j) {
                arrayList.add(new LatLon(angle3, angle7));
                if (j > n) {
                    angle7 = angle5;
                } else if (j != 0) {
                    angle7 = angle7.add(angle6);
                }
                if (angle7.degrees < -180.0) {
                    angle7 = Angle.NEG180;
                    continue;
                }
                if (!(angle7.degrees > 180.0)) continue;
                angle7 = Angle.POS180;
            }
            if (i > n) {
                angle3 = angle;
                continue;
            }
            if (i == 0) continue;
            angle3 = angle3.add(angle2);
        }
        return arrayList;
    }

    protected void renderMultiTexture(DrawContext drawContext, RectTile rectTile, int n) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            String string = Logging.getMessage("generic.NumTextureUnitsLessThanOne");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.render(drawContext, rectTile, n);
    }

    protected void render(DrawContext drawContext, RectTile rectTile) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.render(drawContext, rectTile, 1);
    }

    public void beginRendering(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPushClientAttrib(2);
        gL2.glEnableClientState(32884);
        drawContext.getView().pushReferenceCenter(drawContext, Vec4.ZERO);
    }

    public void endRendering(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        drawContext.getView().popReferenceCenter(drawContext);
        gL2.glPopClientAttrib();
    }

    protected long render(DrawContext drawContext, RectTile rectTile, int n) {
        if (rectTile.ri == null) {
            String string = Logging.getMessage("nullValue.RenderInfoIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject()) {
            if (!this.renderVBO(drawContext, rectTile, n)) {
                drawContext.getGL().glBindBuffer(34962, 0);
                drawContext.getGL().glBindBuffer(34963, 0);
                this.renderVA(drawContext, rectTile, n);
            }
        } else {
            this.renderVA(drawContext, rectTile, n);
        }
        return rectTile.ri.indices.limit() - 2;
    }

    protected void renderVA(DrawContext drawContext, RectTile rectTile, int n) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glVertexPointer(3, 5126, 0, rectTile.ri.vertices.rewind());
        for (int i = 0; i < n; ++i) {
            gL2.glClientActiveTexture(33984 + i);
            gL2.glEnableClientState(32888);
            Object object = drawContext.getValue("gov.nasa.worldwind.avkey.TextureCoordinates");
            if (object != null && object instanceof DoubleBuffer) {
                gL2.glTexCoordPointer(2, 5126, 0, ((DoubleBuffer)object).rewind());
                continue;
            }
            gL2.glTexCoordPointer(2, 5126, 0, rectTile.ri.texCoords.rewind());
        }
        gL2.glDrawElements(5, rectTile.ri.indices.limit(), 5125, rectTile.ri.indices.rewind());
    }

    protected boolean renderVBO(DrawContext drawContext, RectTile rectTile, int n) {
        if (rectTile.ri.isVboBound || this.bindVbos(drawContext, rectTile, n)) {
            drawContext.getGL().glDrawElements(5, rectTile.ri.indices.limit(), 5125, 0L);
            return true;
        }
        return false;
    }

    protected boolean bindVbos(DrawContext drawContext, RectTile rectTile, int n) {
        int[] nArray;
        Object object;
        int[] nArray2 = (int[])drawContext.getGpuResourceCache().get(rectTile.ri.vboCacheKey);
        if (nArray2 == null) {
            rectTile.ri.fillVerticesVBO(drawContext);
            nArray2 = (int[])drawContext.getGpuResourceCache().get(rectTile.ri.vboCacheKey);
            if (nArray2 == null) {
                return false;
            }
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBindBuffer(34962, nArray2[0]);
        gL2.glVertexPointer(3, 5126, 0, 0L);
        if (n > 0) {
            object = textureCoordVboCacheKeys.get(rectTile.density);
            nArray = (int[])(object != null ? drawContext.getGpuResourceCache().get(object) : null);
            if (nArray == null) {
                nArray = this.fillTextureCoordsVbo(drawContext, rectTile.density, rectTile.ri.texCoords);
            }
            for (int i = 0; i < n; ++i) {
                gL2.glClientActiveTexture(33984 + i);
                gL2.glEnableClientState(32888);
                gL2.glBindBuffer(34962, nArray[0]);
                gL2.glTexCoordPointer(2, 5126, 0, 0L);
            }
        }
        if ((nArray = (int[])((object = indexListsVboCacheKeys.get(rectTile.density)) != null ? drawContext.getGpuResourceCache().get(object) : null)) == null) {
            nArray = this.fillIndexListVbo(drawContext, rectTile.density, rectTile.ri.indices);
        }
        if (nArray != null) {
            gL2.glBindBuffer(34963, nArray[0]);
        }
        return nArray != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] fillIndexListVbo(DrawContext drawContext, int n, IntBuffer intBuffer) {
        GL gL = drawContext.getGL();
        Object object = indexListsVboCacheKeys.get(n);
        int[] nArray = (int[])(object != null ? drawContext.getGpuResourceCache().get(object) : null);
        if (nArray == null) {
            nArray = new int[1];
            gL.glGenBuffers(nArray.length, nArray, 0);
            if (object == null) {
                object = new Object();
                indexListsVboCacheKeys.put(n, object);
            }
            int n2 = intBuffer.limit() * 4;
            drawContext.getGpuResourceCache().put(object, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", n2);
        }
        try {
            gL.glBindBuffer(34963, nArray[0]);
            gL.glBufferData(34963, (long)(intBuffer.limit() * 4), intBuffer.rewind(), 35044);
        }
        finally {
            gL.glBindBuffer(34963, 0);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] fillTextureCoordsVbo(DrawContext drawContext, int n, FloatBuffer floatBuffer) {
        GL gL = drawContext.getGL();
        Object object = textureCoordVboCacheKeys.get(n);
        int[] nArray = (int[])(object != null ? drawContext.getGpuResourceCache().get(object) : null);
        if (nArray == null) {
            nArray = new int[1];
            gL.glGenBuffers(nArray.length, nArray, 0);
            if (object == null) {
                object = new Object();
                textureCoordVboCacheKeys.put(n, object);
            }
            int n2 = floatBuffer.limit() * 4;
            drawContext.getGpuResourceCache().put(object, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", n2);
        }
        try {
            gL.glBindBuffer(34962, nArray[0]);
            gL.glBufferData(34962, (long)(floatBuffer.limit() * 4), floatBuffer.rewind(), 35044);
        }
        finally {
            gL.glBindBuffer(34962, 0);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderWireframe(DrawContext drawContext, RectTile rectTile, boolean bl, boolean bl2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectTile.ri == null) {
            String string = Logging.getMessage("nullValue.RenderInfoIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        drawContext.getView().pushReferenceCenter(drawContext, rectTile.ri.referenceCenter);
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPushAttrib(8457);
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 1);
        gL2.glDisable(2929);
        gL2.glEnable(2884);
        gL2.glCullFace(1029);
        gL2.glColor4d(1.0, 1.0, 1.0, 0.2);
        gL2.glPolygonMode(1028, 6913);
        if (bl) {
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            try {
                oGLStackHandler.pushClientAttrib(gL2, 2);
                gL2.glEnableClientState(32884);
                gL2.glVertexPointer(3, 5126, 0, rectTile.ri.vertices.rewind());
                gL2.glDrawElements(5, rectTile.ri.indices.limit(), 5125, rectTile.ri.indices.rewind());
            }
            finally {
                oGLStackHandler.pop(gL2);
            }
        }
        drawContext.getView().popReferenceCenter(drawContext);
        gL2.glPopAttrib();
        if (bl2) {
            this.renderPatchBoundary(drawContext, rectTile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderPatchBoundary(DrawContext drawContext, RectTile rectTile) {
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL2, 8201);
        try {
            gL2.glDisable(3042);
            gL2.glDisable(2929);
            gL2.glEnable(2884);
            gL2.glCullFace(1029);
            gL2.glPolygonMode(1028, 6913);
            Vec4[] vec4Array = rectTile.sector.computeCornerPoints(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
            gL2.glColor4d(1.0, 0.0, 0.0, 1.0);
            gL2.glBegin(7);
            gL2.glVertex3d(vec4Array[0].x, vec4Array[0].y, vec4Array[0].z);
            gL2.glVertex3d(vec4Array[1].x, vec4Array[1].y, vec4Array[1].z);
            gL2.glVertex3d(vec4Array[2].x, vec4Array[2].y, vec4Array[2].z);
            gL2.glVertex3d(vec4Array[3].x, vec4Array[3].y, vec4Array[3].z);
            gL2.glEnd();
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    protected void renderBoundingVolume(DrawContext drawContext, RectTile rectTile) {
        Extent extent = rectTile.getExtent();
        if (extent == null) {
            return;
        }
        if (extent instanceof Renderable) {
            ((Renderable)((Object)extent)).render(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTileID(DrawContext drawContext, RectTile rectTile) {
        Rectangle rectangle = drawContext.getView().getViewport();
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), Font.decode("Arial-Plain-15"));
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            oGLStackHandler.pushAttrib(gL2, 8192);
            drawContext.getGL().glDisable(2929);
            drawContext.getGL().glDisable(3042);
            textRenderer.beginRendering(rectangle.width, rectangle.height);
            textRenderer.setColor(Color.RED);
            String string = Integer.toString(rectTile.level);
            double[] dArray = this.globe.getMinAndMaxElevations(rectTile.getSector());
            if (dArray != null) {
                string = string + ", " + (int)dArray[0] + "/" + (int)dArray[1];
            }
            LatLon latLon = rectTile.getSector().getCentroid();
            Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), drawContext.getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude()));
            vec4 = drawContext.getView().project(vec4);
            textRenderer.draw(string, (int)vec4.x, (int)vec4.y);
            textRenderer.setColor(Color.WHITE);
            textRenderer.endRendering();
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    protected PickedObject[] pick(DrawContext drawContext, RectTile rectTile, List<? extends Point> list) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.PickPointList");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list.size() == 0) {
            return null;
        }
        if (rectTile.ri == null || rectTile.ri.vertices == null) {
            return null;
        }
        PickedObject[] pickedObjectArray = new PickedObject[list.size()];
        this.renderTrianglesWithUniqueColors(drawContext, rectTile);
        for (int i = 0; i < list.size(); ++i) {
            pickedObjectArray[i] = this.resolvePick(drawContext, rectTile, list.get(i));
        }
        return pickedObjectArray;
    }

    protected void pick(DrawContext drawContext, RectTile rectTile, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectTile.ri == null || rectTile.ri.vertices == null) {
            return;
        }
        this.renderTrianglesWithUniqueColors(drawContext, rectTile);
        PickedObject pickedObject = this.resolvePick(drawContext, rectTile, point);
        if (pickedObject != null) {
            drawContext.addPickedObject(pickedObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTrianglesWithUniqueColors(DrawContext drawContext, RectTile rectTile) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2;
        int n = this.density + 2;
        int n2 = n * 2 + 4;
        int n3 = 2 * n * n + 4 * n - 2;
        int n4 = n3 - 2;
        int n5 = (this.density + 3) * (this.density + 3);
        int n6 = n5 * 3;
        if (oddRowColorList.containsKey(this.density) && evenRowColorList.containsKey(this.density)) {
            byteBuffer2 = oddRowColorList.get(this.density);
            byteBuffer = evenRowColorList.get(this.density);
        } else {
            byteBuffer2 = Buffers.newDirectByteBuffer((int)n6);
            byteBuffer = Buffers.newDirectByteBuffer((int)n6);
            oddRowColorList.put(this.density, byteBuffer2);
            evenRowColorList.put(this.density, byteBuffer);
        }
        rectTile.minColorCode = drawContext.getUniquePickColor().getRGB();
        int n7 = -1;
        for (int i = 0; i < n4; ++i) {
            Color color = drawContext.getUniquePickColor();
            int n8 = 3 * rectTile.ri.indices.get(i + 2);
            if (n8 > n7) {
                byteBuffer2.position(n8);
                byteBuffer2.put((byte)color.getRed()).put((byte)color.getGreen()).put((byte)color.getBlue());
            } else if (n8 < n7) {
                byteBuffer.position(n8);
                byteBuffer.put((byte)color.getRed()).put((byte)color.getGreen()).put((byte)color.getBlue());
            }
            n7 = n8;
        }
        rectTile.maxColorCode = drawContext.getUniquePickColor().getRGB();
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            if (null != rectTile.ri.referenceCenter) {
                drawContext.getView().pushReferenceCenter(drawContext, rectTile.ri.referenceCenter);
            }
            gL2.glEnableClientState(32884);
            gL2.glEnableClientState(32886);
            if (drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject() && this.bindVbos(drawContext, rectTile, 0)) {
                int n9;
                gL2.glBindBuffer(34962, 0);
                gL2.glColorPointer(3, 5121, 0, byteBuffer2.rewind());
                for (n9 = 0; n9 < n; n9 += 2) {
                    gL2.glDrawElements(5, n2, 5125, (long)(n2 * n9 * 4));
                }
                gL2.glColorPointer(3, 5121, 0, byteBuffer.rewind());
                for (n9 = 1; n9 < n - 1; n9 += 2) {
                    gL2.glDrawElements(5, n2, 5125, (long)(n2 * n9 * 4));
                }
            } else {
                int n10;
                gL2.glVertexPointer(3, 5126, 0, rectTile.ri.vertices.rewind());
                gL2.glColorPointer(3, 5121, 0, byteBuffer2.rewind());
                for (n10 = 0; n10 < n; n10 += 2) {
                    gL2.glDrawElements(5, n2, 5125, rectTile.ri.indices.position(n2 * n10));
                }
                gL2.glColorPointer(3, 5121, 0, byteBuffer.rewind());
                for (n10 = 1; n10 < n - 1; n10 += 2) {
                    gL2.glDrawElements(5, n2, 5125, rectTile.ri.indices.position(n2 * n10));
                }
            }
        }
        finally {
            if (null != rectTile.ri.referenceCenter) {
                drawContext.getView().popReferenceCenter(drawContext);
            }
        }
    }

    protected PickedObject resolvePick(DrawContext drawContext, RectTile rectTile, Point point) {
        int n = this.pickSupport.getTopColor(drawContext, point);
        if (n < rectTile.minColorCode || n > rectTile.maxColorCode) {
            return null;
        }
        double d = 1.0E-5f;
        int n2 = n - rectTile.minColorCode - 1;
        if (rectTile.ri.indices == null || n2 >= rectTile.ri.indices.capacity() - 2) {
            return null;
        }
        double d2 = rectTile.ri.referenceCenter.x;
        double d3 = rectTile.ri.referenceCenter.y;
        double d4 = rectTile.ri.referenceCenter.z;
        int[] nArray = new int[3];
        rectTile.ri.indices.position(n2);
        rectTile.ri.indices.get(nArray);
        float[] fArray = new float[3];
        rectTile.ri.vertices.position(3 * nArray[0]);
        rectTile.ri.vertices.get(fArray);
        Vec4 vec4 = new Vec4((double)fArray[0] + d2, (double)fArray[1] + d3, (double)fArray[2] + d4);
        rectTile.ri.vertices.position(3 * nArray[1]);
        rectTile.ri.vertices.get(fArray);
        Vec4 vec42 = new Vec4((double)fArray[0] + d2, (double)fArray[1] + d3, (double)fArray[2] + d4);
        rectTile.ri.vertices.position(3 * nArray[2]);
        rectTile.ri.vertices.get(fArray);
        Vec4 vec43 = new Vec4((double)fArray[0] + d2, (double)fArray[1] + d3, (double)fArray[2] + d4);
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec43.subtract3(vec4);
        Vec4 vec46 = vec44.cross3(vec45);
        Line line = drawContext.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec47 = line.getOrigin().subtract3(vec4);
        double d5 = -vec46.dot3(vec47);
        double d6 = vec46.dot3(line.getDirection());
        if (Math.abs(d6) < d) {
            return null;
        }
        double d7 = d5 / d6;
        Vec4 vec48 = line.getOrigin().add3(line.getDirection().multiply3(d7));
        Position position = drawContext.getGlobe().computePositionFromPoint(vec48);
        double d8 = drawContext.getGlobe().getElevation(position.getLatitude(), position.getLongitude());
        Position position2 = new Position(position.getLatitude(), position.getLongitude(), d8 *= drawContext.getVerticalExaggeration());
        return new PickedObject(point, n, position2, position.getLatitude(), position.getLongitude(), d8, true);
    }

    protected Intersection[] intersect(RectTile rectTile, Line line) {
        int n;
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectTile.ri.vertices == null) {
            return null;
        }
        Vec4 vec4 = line.getDirection().cross3(this.globe.computeSurfaceNormalAtPoint(line.getOrigin()));
        Plane plane = new Plane(vec4.x(), vec4.y(), vec4.z(), -line.getOrigin().dot3(vec4));
        if (!rectTile.getExtent().intersects(plane)) {
            return null;
        }
        Vec4 vec42 = line.getDirection().cross3(vec4);
        Plane plane2 = new Plane(vec42.x(), vec42.y(), vec42.z(), -line.getOrigin().dot3(vec42));
        if (!rectTile.getExtent().intersects(plane2)) {
            return null;
        }
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        int[] nArray = new int[rectTile.ri.indices.limit()];
        float[] fArray = new float[rectTile.ri.vertices.limit()];
        rectTile.ri.indices.rewind();
        rectTile.ri.vertices.rewind();
        rectTile.ri.indices.get(nArray, 0, nArray.length);
        rectTile.ri.vertices.get(fArray, 0, fArray.length);
        rectTile.ri.indices.rewind();
        rectTile.ri.vertices.rewind();
        int n2 = rectTile.ri.indices.capacity() - 2;
        double d = rectTile.ri.referenceCenter.x;
        double d2 = rectTile.ri.referenceCenter.y;
        double d3 = rectTile.ri.referenceCenter.z;
        double d4 = rectTile.extent.getEffectiveRadius(plane);
        double d5 = rectTile.extent.getEffectiveRadius(plane2);
        int n3 = (this.density + 2) * 2 + 6;
        int n4 = n2 - n3;
        int n5 = -1;
        for (n = n3; n < n4; n += 2) {
            Vec4 vec43;
            Vec4 vec44;
            int n6 = n5 = n5 == this.density - 1 ? -4 : n5 + 1;
            if (n5 < 0) continue;
            int n7 = 3 * nArray[n + 1];
            Vec4 vec45 = new Vec4((double)fArray[n7++] + d, (double)fArray[n7++] + d2, (double)fArray[n7] + d3);
            n7 = 3 * nArray[n + 2];
            if (Math.abs(plane.distanceTo(vec44 = Vec4.mix3(0.5, vec45, vec43 = new Vec4((double)fArray[n7++] + d, (double)fArray[n7++] + d2, (double)fArray[n7] + d3)))) > d4 || Math.abs(plane2.distanceTo(vec44)) > d5) continue;
            n7 = 3 * nArray[n];
            Vec4 vec46 = new Vec4((double)fArray[n7++] + d, (double)fArray[n7++] + d2, (double)fArray[n7] + d3);
            n7 = 3 * nArray[n + 3];
            Vec4 vec47 = new Vec4((double)fArray[n7++] + d, (double)fArray[n7++] + d2, (double)fArray[n7] + d3);
            Triangle triangle = new Triangle(vec46, vec45, vec43);
            Vec4 vec48 = triangle.intersect(line);
            if (vec48 != null) {
                arrayList.add(new Intersection(vec48, false));
            }
            if ((vec48 = (triangle = new Triangle(vec45, vec43, vec47)).intersect(line)) == null) continue;
            arrayList.add(new Intersection(vec48, false));
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        Intersection[] intersectionArray = new Intersection[n];
        arrayList.toArray(intersectionArray);
        final Vec4 vec49 = line.getOrigin();
        Arrays.sort(intersectionArray, new Comparator<Intersection>(){

            @Override
            public int compare(Intersection intersection, Intersection intersection2) {
                if (intersection == null && intersection2 == null) {
                    return 0;
                }
                if (intersection2 == null) {
                    return -1;
                }
                if (intersection == null) {
                    return 1;
                }
                Vec4 vec4 = intersection.getIntersectionPoint();
                Vec4 vec42 = intersection2.getIntersectionPoint();
                double d = vec49.distanceTo3(vec4);
                double d2 = vec49.distanceTo3(vec42);
                return Double.compare(d, d2);
            }
        });
        return intersectionArray;
    }

    protected Intersection[] intersect(RectTile rectTile, double d) {
        int n;
        Intersection[] intersectionArray;
        if (rectTile.ri.vertices == null) {
            return null;
        }
        if (rectTile.getExtent() instanceof Cylinder && !(this.globe.isPointAboveElevation((intersectionArray = (Intersection[])rectTile.getExtent()).getBottomCenter(), d) ^ this.globe.isPointAboveElevation(intersectionArray.getTopCenter(), d))) {
            return null;
        }
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        int[] nArray = new int[rectTile.ri.indices.limit()];
        float[] fArray = new float[rectTile.ri.vertices.limit()];
        rectTile.ri.indices.rewind();
        rectTile.ri.vertices.rewind();
        rectTile.ri.indices.get(nArray, 0, nArray.length);
        rectTile.ri.vertices.get(fArray, 0, fArray.length);
        rectTile.ri.indices.rewind();
        rectTile.ri.vertices.rewind();
        int n2 = rectTile.ri.indices.capacity() - 2;
        double d2 = rectTile.ri.referenceCenter.x;
        double d3 = rectTile.ri.referenceCenter.y;
        double d4 = rectTile.ri.referenceCenter.z;
        int n3 = (this.density + 2) * 2 + 6;
        int n4 = n2 - n3;
        int n5 = -1;
        for (n = n3; n < n4; n += 2) {
            int n6 = n5 = n5 == this.density - 1 ? -4 : n5 + 1;
            if (n5 < 0) continue;
            int n7 = 3 * nArray[n];
            Vec4 vec4 = new Vec4((double)fArray[n7++] + d2, (double)fArray[n7++] + d3, (double)fArray[n7] + d4);
            n7 = 3 * nArray[n + 1];
            Vec4 vec42 = new Vec4((double)fArray[n7++] + d2, (double)fArray[n7++] + d3, (double)fArray[n7] + d4);
            n7 = 3 * nArray[n + 2];
            Vec4 vec43 = new Vec4((double)fArray[n7++] + d2, (double)fArray[n7++] + d3, (double)fArray[n7] + d4);
            n7 = 3 * nArray[n + 3];
            Vec4 vec44 = new Vec4((double)fArray[n7++] + d2, (double)fArray[n7++] + d3, (double)fArray[n7] + d4);
            Intersection[] intersectionArray2 = this.globe.intersect(new Triangle(vec4, vec42, vec43), d);
            if (intersectionArray2 != null) {
                arrayList.add(intersectionArray2[0]);
                arrayList.add(intersectionArray2[1]);
            }
            if ((intersectionArray2 = this.globe.intersect(new Triangle(vec42, vec43, vec44), d)) == null) continue;
            arrayList.add(intersectionArray2[0]);
            arrayList.add(intersectionArray2[1]);
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        intersectionArray = new Intersection[n];
        arrayList.toArray(intersectionArray);
        return intersectionArray;
    }

    protected Vec4 getSurfacePoint(RectTile rectTile, Angle angle, Angle angle2, double d) {
        Vec4 vec4 = this.getSurfacePoint(rectTile, angle, angle2);
        if (d != 0.0 && vec4 != null) {
            vec4 = RectangularTessellator.applyOffset(this.globe, vec4, d);
        }
        return vec4;
    }

    protected static Vec4 applyOffset(Globe globe, Vec4 vec4, double d) {
        Vec4 vec42 = globe.computeSurfaceNormalAtPoint(vec4);
        vec4 = Vec4.fromLine3(vec4, d, vec42);
        return vec4;
    }

    protected Vec4 getSurfacePoint(RectTile rectTile, Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!rectTile.sector.contains(angle, angle2)) {
            return null;
        }
        if (rectTile.ri == null) {
            return null;
        }
        double d = angle.getDegrees();
        double d2 = angle2.getDegrees();
        double d3 = rectTile.sector.getMinLatitude().getDegrees();
        double d4 = rectTile.sector.getMaxLatitude().getDegrees();
        double d5 = rectTile.sector.getMinLongitude().getDegrees();
        double d6 = rectTile.sector.getMaxLongitude().getDegrees();
        double d7 = (d2 - d5) / (d6 - d5);
        double d8 = (d - d3) / (d4 - d3);
        int n = (int)(d8 * (double)rectTile.density);
        int n2 = (int)(d7 * (double)rectTile.density);
        double d9 = RectangularTessellator.createPosition(n2, d7, rectTile.ri.density);
        double d10 = RectangularTessellator.createPosition(n, d8, rectTile.ri.density);
        Vec4 vec4 = RectangularTessellator.interpolate(n, n2, d9, d10, rectTile.ri);
        vec4 = vec4.add3(rectTile.ri.referenceCenter);
        return vec4;
    }

    protected static double createPosition(int n, double d, int n2) {
        double d2 = (double)n / (double)n2;
        double d3 = (double)(n + 1) / (double)n2;
        return (d - d2) / (d3 - d2);
    }

    protected static Vec4 interpolate(int n, int n2, double d, double d2, RenderInfo renderInfo) {
        int n3 = renderInfo.density + 3;
        int n4 = ++n * n3 + ++n2;
        int n5 = n3 * 3;
        renderInfo.vertices.position(n4 *= 3);
        Vec4 vec4 = new Vec4(renderInfo.vertices.get(), renderInfo.vertices.get(), renderInfo.vertices.get());
        Vec4 vec42 = new Vec4(renderInfo.vertices.get(), renderInfo.vertices.get(), renderInfo.vertices.get());
        renderInfo.vertices.position(n4 += n5);
        Vec4 vec43 = new Vec4(renderInfo.vertices.get(), renderInfo.vertices.get(), renderInfo.vertices.get());
        Vec4 vec44 = new Vec4(renderInfo.vertices.get(), renderInfo.vertices.get(), renderInfo.vertices.get());
        return RectangularTessellator.interpolate(vec4, vec42, vec44, vec43, d, d2);
    }

    protected static Vec4 interpolate(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, double d, double d2) {
        double d3 = d + d2;
        if (d3 == 1.0) {
            return new Vec4(vec44.x * d2 + vec42.x * d, vec44.y * d2 + vec42.y * d, vec44.z * d2 + vec42.z * d);
        }
        if (d3 > 1.0) {
            Vec4 vec45 = vec44.subtract3(vec43).multiply3(1.0 - d);
            Vec4 vec46 = vec42.subtract3(vec43).multiply3(1.0 - d2);
            return vec43.add3(vec45).add3(vec46);
        }
        Vec4 vec47 = vec42.subtract3(vec4).multiply3(d);
        Vec4 vec48 = vec44.subtract3(vec4).multiply3(d2);
        return vec4.add3(vec47).add3(vec48);
    }

    protected static double[] baryCentricCoordsRequireInside(Vec4 vec4, Vec4[] vec4Array) {
        double[] dArray = new double[3];
        double d = RectangularTessellator.distanceFromLine(vec4Array[0], vec4Array[1], vec4Array[2].subtract3(vec4Array[1]));
        double d2 = RectangularTessellator.distanceFromLine(vec4, vec4Array[1], vec4Array[2].subtract3(vec4Array[1]));
        dArray[0] = d2 / d;
        if (Math.abs(dArray[0]) < 1.0E-4) {
            dArray[0] = 0.0;
        } else if (Math.abs(1.0 - dArray[0]) < 1.0E-4) {
            dArray[0] = 1.0;
        }
        if (dArray[0] < 0.0 || dArray[0] > 1.0) {
            return null;
        }
        d = RectangularTessellator.distanceFromLine(vec4Array[1], vec4Array[0], vec4Array[2].subtract3(vec4Array[0]));
        d2 = RectangularTessellator.distanceFromLine(vec4, vec4Array[0], vec4Array[2].subtract3(vec4Array[0]));
        dArray[1] = d2 / d;
        if (Math.abs(dArray[1]) < 1.0E-4) {
            dArray[1] = 0.0;
        } else if (Math.abs(1.0 - dArray[1]) < 1.0E-4) {
            dArray[1] = 1.0;
        }
        if (dArray[1] < 0.0 || dArray[1] > 1.0) {
            return null;
        }
        dArray[2] = 1.0 - dArray[0] - dArray[1];
        if (Math.abs(dArray[2]) < 1.0E-4) {
            dArray[2] = 0.0;
        } else if (Math.abs(1.0 - dArray[2]) < 1.0E-4) {
            dArray[2] = 1.0;
        }
        if (dArray[2] < 0.0) {
            return null;
        }
        return dArray;
    }

    protected static double distanceFromLine(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        double d;
        Vec4 vec44 = vec4.subtract3(vec42);
        double d2 = vec44.dot3(vec44);
        double d3 = vec43.normalize3().dot3(vec44);
        if ((d = d2 - (d3 *= d3)) < 0.0) {
            return 0.0;
        }
        return Math.sqrt(d);
    }

    protected DoubleBuffer makeGeographicTexCoords(SectorGeometry sectorGeometry, SectorGeometry.GeographicTextureCoordinateComputer geographicTextureCoordinateComputer) {
        int n;
        double[] dArray;
        Angle angle;
        int n2;
        if (sectorGeometry == null) {
            String string = Logging.getMessage("nullValue.SectorGeometryIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geographicTextureCoordinateComputer == null) {
            String string = Logging.getMessage("nullValue.TextureCoordinateComputerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        RectTile rectTile = (RectTile)sectorGeometry;
        int n3 = rectTile.density;
        if (n3 < 1) {
            n3 = 1;
        }
        int n4 = (n3 + 3) * (n3 + 3);
        DoubleBuffer doubleBuffer = Buffers.newDirectDoubleBuffer((int)(2 * n4));
        double d = rectTile.sector.getDeltaLatRadians() / (double)n3;
        double d2 = rectTile.sector.getDeltaLonRadians() / (double)n3;
        Angle angle2 = rectTile.sector.getMinLatitude();
        Angle angle3 = rectTile.sector.getMaxLatitude();
        Angle angle4 = rectTile.sector.getMinLongitude();
        Angle angle5 = rectTile.sector.getMaxLongitude();
        int n5 = 2 * (n3 + 3);
        for (n2 = 0; n2 < n3; ++n2) {
            angle = Angle.fromRadians(angle2.radians + (double)n2 * d);
            dArray = geographicTextureCoordinateComputer.compute(angle, angle4);
            doubleBuffer.put(n5++, dArray[0]).put(n5++, dArray[1]);
            for (int i = 0; i < n3; ++i) {
                Angle angle6 = Angle.fromRadians(angle4.radians + (double)i * d2);
                dArray = geographicTextureCoordinateComputer.compute(angle, angle6);
                doubleBuffer.put(n5++, dArray[0]).put(n5++, dArray[1]);
            }
            dArray = geographicTextureCoordinateComputer.compute(angle, angle5);
            doubleBuffer.put(n5++, dArray[0]).put(n5++, dArray[1]);
            doubleBuffer.put(n5++, dArray[0]).put(n5++, dArray[1]);
        }
        dArray = geographicTextureCoordinateComputer.compute(angle3, angle4);
        doubleBuffer.put(n5++, dArray[0]).put(n5++, dArray[1]);
        for (n2 = 0; n2 < n3; ++n2) {
            angle = Angle.fromRadians(angle4.radians + (double)n2 * d2);
            dArray = geographicTextureCoordinateComputer.compute(angle3, angle);
            doubleBuffer.put(n5++, dArray[0]).put(n5++, dArray[1]);
        }
        dArray = geographicTextureCoordinateComputer.compute(angle3, angle5);
        doubleBuffer.put(n5++, dArray[0]).put(n5++, dArray[1]);
        doubleBuffer.put(n5++, dArray[0]).put(n5++, dArray[1]);
        n2 = n5 - 2 * (n3 + 3);
        for (n = 0; n < n3 + 3; ++n) {
            doubleBuffer.put(n5++, doubleBuffer.get(n2++));
            doubleBuffer.put(n5++, doubleBuffer.get(n2++));
        }
        n5 = 0;
        n2 = 2 * (n3 + 3);
        for (n = 0; n < n3 + 3; ++n) {
            doubleBuffer.put(n5++, doubleBuffer.get(n2++));
            doubleBuffer.put(n5++, doubleBuffer.get(n2++));
        }
        return doubleBuffer;
    }

    protected static void createTextureCoordinates(int n) {
        int n2;
        int n3;
        if (n < 1) {
            n = 1;
        }
        if (textureCoords.containsKey(n)) {
            return;
        }
        int n4 = (n + 3) * (n + 3);
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer((int)(2 * n4));
        double d = 1.0 / (double)n;
        int n5 = 2 * (n + 3);
        for (int i = 0; i < n; ++i) {
            double d2 = (double)i * d;
            floatBuffer.put(n5++, 0.0f);
            floatBuffer.put(n5++, (float)d2);
            for (int j = 0; j < n; ++j) {
                floatBuffer.put(n5++, (float)((double)j * d));
                floatBuffer.put(n5++, (float)d2);
            }
            floatBuffer.put(n5++, 0.999999f);
            floatBuffer.put(n5++, (float)d2);
            floatBuffer.put(n5++, 0.999999f);
            floatBuffer.put(n5++, (float)d2);
        }
        float f = 0.999999f;
        floatBuffer.put(n5++, 0.0f);
        floatBuffer.put(n5++, f);
        for (n3 = 0; n3 < n; ++n3) {
            floatBuffer.put(n5++, (float)((double)n3 * d));
            floatBuffer.put(n5++, f);
        }
        floatBuffer.put(n5++, 0.999999f);
        floatBuffer.put(n5++, f);
        floatBuffer.put(n5++, 0.999999f);
        floatBuffer.put(n5++, f);
        n3 = n5 - 2 * (n + 3);
        for (n2 = 0; n2 < n + 3; ++n2) {
            floatBuffer.put(n5++, floatBuffer.get(n3++));
            floatBuffer.put(n5++, floatBuffer.get(n3++));
        }
        n5 = 0;
        n3 = 2 * (n + 3);
        for (n2 = 0; n2 < n + 3; ++n2) {
            floatBuffer.put(n5++, floatBuffer.get(n3++));
            floatBuffer.put(n5++, floatBuffer.get(n3++));
        }
        textureCoords.put(n, floatBuffer);
    }

    protected static void createIndices(int n) {
        if (n < 1) {
            n = 1;
        }
        if (indexLists.containsKey(n)) {
            return;
        }
        int n2 = n + 2;
        int n3 = 2 * n2 * n2 + 4 * n2 - 2;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)n3);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            intBuffer.put(n4);
            if (i > 0) {
                intBuffer.put(++n4);
                intBuffer.put(n4);
            }
            if (i % 2 == 0) {
                intBuffer.put(++n4);
                for (n5 = 0; n5 < n2; ++n5) {
                    intBuffer.put(n4 += n2);
                    intBuffer.put(++n4);
                }
                continue;
            }
            intBuffer.put(--n4);
            for (n5 = 0; n5 < n2; ++n5) {
                intBuffer.put(n4 -= n2);
                intBuffer.put(--n4);
            }
        }
        indexLists.put(n, intBuffer);
    }

    protected static class CacheKey {
        protected final Sector sector;
        protected final int density;
        protected final Object globeStateKey;

        public CacheKey(DrawContext drawContext, Sector sector, int n) {
            this.sector = sector;
            this.density = n;
            this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.density != cacheKey.density) {
                return false;
            }
            if (this.globeStateKey != null ? !this.globeStateKey.equals(cacheKey.globeStateKey) : cacheKey.globeStateKey != null) {
                return false;
            }
            return !(this.sector != null ? !this.sector.equals(cacheKey.sector) : cacheKey.sector != null);
        }

        public int hashCode() {
            int n = this.sector != null ? this.sector.hashCode() : 0;
            n = 31 * n + this.density;
            n = 31 * n + (this.globeStateKey != null ? this.globeStateKey.hashCode() : 0);
            return n;
        }
    }

    protected static class RectTile
    implements SectorGeometry {
        protected final RectangularTessellator tessellator;
        protected final int level;
        protected final Sector sector;
        protected final int density;
        protected final double cellSize;
        protected Extent extent;
        protected RenderInfo ri;
        protected int minColorCode = 0;
        protected int maxColorCode = 0;

        public RectTile(RectangularTessellator rectangularTessellator, Extent extent, int n, int n2, Sector sector) {
            this.tessellator = rectangularTessellator;
            this.level = n;
            this.density = n2;
            this.sector = sector;
            this.extent = extent;
            this.cellSize = sector.getDeltaLatRadians() / (double)n2;
        }

        @Override
        public Sector getSector() {
            return this.sector;
        }

        @Override
        public Extent getExtent() {
            return this.extent;
        }

        public RectangularTessellator getTessellator() {
            return this.tessellator;
        }

        public int getLevel() {
            return this.level;
        }

        public int getDensity() {
            return this.density;
        }

        public double getCellSize() {
            return this.cellSize;
        }

        public RenderInfo getRi() {
            return this.ri;
        }

        public int getMinColorCode() {
            return this.minColorCode;
        }

        public int getMaxColorCode() {
            return this.maxColorCode;
        }

        @Override
        public void beginRendering(DrawContext drawContext, int n) {
            drawContext.getView().setReferenceCenter(drawContext, this.ri.referenceCenter);
            if (drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject() && this.tessellator.bindVbos(drawContext, this, n)) {
                this.ri.isVboBound = true;
            }
        }

        @Override
        public void endRendering(DrawContext drawContext) {
            if (this.ri.isVboBound) {
                drawContext.getGL().glBindBuffer(34962, 0);
                drawContext.getGL().glBindBuffer(34963, 0);
                this.ri.isVboBound = false;
            }
        }

        @Override
        public void renderMultiTexture(DrawContext drawContext, int n) {
            this.tessellator.renderMultiTexture(drawContext, this, n);
        }

        @Override
        public void renderMultiTexture(DrawContext drawContext, int n, boolean bl) {
            if (bl) {
                this.tessellator.renderMultiTexture(drawContext, this, n);
            } else {
                this.beginRendering(drawContext, n);
                this.tessellator.renderMultiTexture(drawContext, this, n);
                this.endRendering(drawContext);
            }
        }

        @Override
        public void render(DrawContext drawContext) {
            this.beginRendering(drawContext, 1);
            this.tessellator.render(drawContext, this);
            this.endRendering(drawContext);
        }

        @Override
        public void render(DrawContext drawContext, boolean bl) {
            if (bl) {
                this.tessellator.render(drawContext, this);
            } else {
                this.beginRendering(drawContext, 1);
                this.tessellator.render(drawContext, this);
                this.endRendering(drawContext);
            }
        }

        @Override
        public void renderWireframe(DrawContext drawContext, boolean bl, boolean bl2) {
            this.tessellator.renderWireframe(drawContext, this, bl, bl2);
        }

        @Override
        public void renderBoundingVolume(DrawContext drawContext) {
            this.tessellator.renderBoundingVolume(drawContext, this);
        }

        @Override
        public void renderTileID(DrawContext drawContext) {
            this.tessellator.renderTileID(drawContext, this);
        }

        @Override
        public PickedObject[] pick(DrawContext drawContext, List<? extends Point> list) {
            return this.tessellator.pick(drawContext, this, list);
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
            this.tessellator.pick(drawContext, this, point);
        }

        @Override
        public Vec4 getSurfacePoint(Angle angle, Angle angle2, double d) {
            return this.tessellator.getSurfacePoint(this, angle, angle2, d);
        }

        public double getResolution() {
            return this.sector.getDeltaLatRadians() / (double)this.density;
        }

        @Override
        public Intersection[] intersect(Line line) {
            return this.tessellator.intersect(this, line);
        }

        @Override
        public Intersection[] intersect(double d) {
            return this.tessellator.intersect(this, d);
        }

        @Override
        public DoubleBuffer makeTextureCoordinates(SectorGeometry.GeographicTextureCoordinateComputer geographicTextureCoordinateComputer) {
            return this.tessellator.makeGeographicTexCoords(this, geographicTextureCoordinateComputer);
        }
    }

    protected static class RenderInfo {
        protected final int density;
        protected final Vec4 referenceCenter;
        protected final FloatBuffer vertices;
        protected final FloatBuffer texCoords;
        protected final IntBuffer indices;
        protected long time;
        protected Object vboCacheKey = new Object();
        protected boolean isVboBound = false;

        protected RenderInfo(DrawContext drawContext, int n, FloatBuffer floatBuffer, Vec4 vec4) {
            RectangularTessellator.createIndices(n);
            RectangularTessellator.createTextureCoordinates(n);
            this.density = n;
            this.referenceCenter = vec4;
            this.vertices = floatBuffer;
            this.indices = indexLists.get(this.density);
            this.texCoords = textureCoords.get(this.density);
            this.time = System.currentTimeMillis();
            if (drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject()) {
                this.fillVerticesVBO(drawContext);
            }
        }

        public int getDensity() {
            return this.density;
        }

        public Vec4 getReferenceCenter() {
            return this.referenceCenter;
        }

        public FloatBuffer getVertices() {
            return this.vertices;
        }

        public FloatBuffer getTexCoords() {
            return this.texCoords;
        }

        public IntBuffer getIndices() {
            return this.indices;
        }

        public long getTime() {
            return this.time;
        }

        public Object getVboCacheKey() {
            return this.vboCacheKey;
        }

        public boolean isVboBound() {
            return this.isVboBound;
        }

        protected void update(DrawContext drawContext) {
            this.time = System.currentTimeMillis();
            if (drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject()) {
                this.fillVerticesVBO(drawContext);
            }
        }

        protected long getSizeInBytes() {
            return 32 + this.vertices.limit() * 32 / 8;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fillVerticesVBO(DrawContext drawContext) {
            GL gL = drawContext.getGL();
            int[] nArray = (int[])drawContext.getGpuResourceCache().get(this.vboCacheKey);
            if (nArray == null) {
                nArray = new int[1];
                gL.glGenBuffers(nArray.length, nArray, 0);
                int n = this.vertices.limit() * 4;
                drawContext.getGpuResourceCache().put(this.vboCacheKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", n);
            }
            try {
                FloatBuffer floatBuffer = this.vertices;
                gL.glBindBuffer(34962, nArray[0]);
                gL.glBufferData(34962, (long)(floatBuffer.limit() * 4), floatBuffer.rewind(), 35044);
            }
            finally {
                gL.glBindBuffer(34962, 0);
            }
        }
    }
}

