/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.WWBufferUtil;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class CompoundVecBuffer {
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final boolean ALLOCATE_DIRECT_BUFFERS = true;
    protected int count;
    protected int capacity;
    protected IntBuffer offsets;
    protected IntBuffer lengths;

    public CompoundVecBuffer(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.CapacityIsInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.capacity = n;
        this.offsets = WWBufferUtil.newIntBuffer(n, true);
        this.lengths = WWBufferUtil.newIntBuffer(n, true);
    }

    public CompoundVecBuffer() {
        this(16);
    }

    protected CompoundVecBuffer(CompoundVecBuffer compoundVecBuffer, int n, int n2) {
        int n3;
        this.count = n3 = n2 - n + 1;
        this.capacity = n3;
        this.offsets = WWBufferUtil.newIntBuffer(n3, true);
        compoundVecBuffer.offsets.limit(n2 + 1);
        compoundVecBuffer.offsets.position(n);
        this.offsets.put(compoundVecBuffer.offsets);
        this.offsets.rewind();
        compoundVecBuffer.offsets.clear();
        this.lengths = WWBufferUtil.newIntBuffer(n3, true);
        compoundVecBuffer.lengths.limit(n2 + 1);
        compoundVecBuffer.lengths.position(n);
        this.lengths.put(compoundVecBuffer.lengths);
        this.lengths.rewind();
        compoundVecBuffer.lengths.clear();
    }

    protected CompoundVecBuffer(CompoundVecBuffer compoundVecBuffer, int[] nArray, int n, int n2) {
        this.count = n2;
        this.capacity = n2;
        this.offsets = WWBufferUtil.newIntBuffer(n2, true);
        this.lengths = WWBufferUtil.newIntBuffer(n2, true);
        for (int i = n; i < n + n2; ++i) {
            this.offsets.put(compoundVecBuffer.offsets.get(nArray[i]));
            this.lengths.put(compoundVecBuffer.lengths.get(nArray[i]));
        }
        this.offsets.rewind();
        this.lengths.rewind();
    }

    public static CompoundVecBuffer emptyCompoundVecBuffer(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new EmptyCompoundVecBuffer(n);
    }

    public int size() {
        return this.count;
    }

    public abstract int subBufferSize(int var1);

    public VecBuffer subBuffer(int n) {
        if (n < 0 || n >= this.count) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = this.offsets.get(n);
        int n3 = this.lengths.get(n);
        if (n3 > 0) {
            return this.createSubBuffer(n2, n3);
        }
        return VecBuffer.emptyVecBuffer(this.getCoordsPerVec());
    }

    public CompoundVecBuffer slice(int n, int n2) {
        if (n < 0 || n >= this.count) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 >= this.count) {
            String string = Logging.getMessage("generic.indexOutOfRange", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n > n2) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.createSlice(n, n2);
    }

    public CompoundVecBuffer slice(int[] nArray, int n, int n2) {
        if (nArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 > nArray.length) {
            String string = Logging.getMessage("generic.LengthIsInvalid", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n + n2 > nArray.length) {
            String string = Logging.getMessage("generic.OffsetIsInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = n; i < n + n2; ++i) {
            if (nArray[i] >= 0 && nArray[i] < this.count) continue;
            String string = Logging.getMessage("generic.indexOutOfRange", nArray[i]);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.createSlice(nArray, n, n2);
    }

    public CompoundVecBuffer slice(int[] nArray) {
        if (nArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.slice(nArray, 0, nArray.length);
    }

    public void clear() {
        this.count = 0;
    }

    public abstract int getCoordsPerVec();

    protected abstract VecBuffer createSubBuffer(int var1, int var2);

    protected abstract CompoundVecBuffer createSlice(int[] var1, int var2, int var3);

    protected abstract CompoundVecBuffer createSlice(int var1, int var2);

    protected int addSubBuffer(int n, int n2) {
        int n3 = 1 + this.count;
        if (n3 > this.capacity) {
            this.expandCapacity(n3);
        }
        int n4 = this.count++;
        this.offsets.put(n4, n);
        this.lengths.put(n4, n2);
        return n4;
    }

    protected void expandCapacity(int n) {
        int n2 = 2 * this.capacity;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n2 < n) {
            n2 = n;
        }
        this.offsets = WWBufferUtil.copyOf(this.offsets, n2);
        this.lengths = WWBufferUtil.copyOf(this.lengths, n2);
        this.capacity = n2;
    }

    public Iterable<double[]> getCoords() {
        return this.getCoords(this.getCoordsPerVec());
    }

    public Iterable<double[]> getCoords(final int n) {
        return new Iterable<double[]>(){

            @Override
            public Iterator<double[]> iterator() {
                return new CompoundIterator<double[]>(new CoordIterable(n));
            }
        };
    }

    public Iterable<double[]> getReverseCoords(final int n) {
        return new Iterable<double[]>(){

            @Override
            public Iterator<double[]> iterator() {
                return new ReverseCompoundIterator<double[]>(new CoordIterable(n));
            }
        };
    }

    public Iterable<? extends Vec4> getVectors() {
        return new Iterable<Vec4>(){

            @Override
            public Iterator<Vec4> iterator() {
                return new CompoundIterator<Vec4>(new VectorIterable());
            }
        };
    }

    public Iterable<? extends Vec4> getReverseVectors() {
        return new Iterable<Vec4>(){

            @Override
            public Iterator<Vec4> iterator() {
                return new ReverseCompoundIterator<Vec4>(new VectorIterable());
            }
        };
    }

    public Iterable<? extends LatLon> getLocations() {
        return new Iterable<LatLon>(){

            @Override
            public Iterator<LatLon> iterator() {
                return new CompoundIterator<LatLon>(new LocationIterable());
            }
        };
    }

    public Iterable<? extends LatLon> getReverseLocations() {
        return new Iterable<LatLon>(){

            @Override
            public Iterator<LatLon> iterator() {
                return new ReverseCompoundIterator<LatLon>(new LocationIterable());
            }
        };
    }

    public Iterable<? extends Position> getPositions() {
        return new Iterable<Position>(){

            @Override
            public Iterator<Position> iterator() {
                return new CompoundIterator<Position>(new PositionIterable());
            }
        };
    }

    public Iterable<? extends Position> getReversePositions() {
        return new Iterable<Position>(){

            @Override
            public Iterator<Position> iterator() {
                return new ReverseCompoundIterator<Position>(new PositionIterable());
            }
        };
    }

    protected static class EmptyCompoundVecBuffer
    extends CompoundVecBuffer {
        protected int coordsPerVec;

        public EmptyCompoundVecBuffer(int n) {
            super(1);
            if (n < 1) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.coordsPerVec = n;
        }

        protected EmptyCompoundVecBuffer(EmptyCompoundVecBuffer emptyCompoundVecBuffer, int n, int n2) {
            super(emptyCompoundVecBuffer, n, n2);
        }

        protected EmptyCompoundVecBuffer(EmptyCompoundVecBuffer emptyCompoundVecBuffer, int[] nArray, int n, int n2) {
            super(emptyCompoundVecBuffer, nArray, n, n2);
        }

        @Override
        public int subBufferSize(int n) {
            if (n < 0 || n >= this.count) {
                String string = Logging.getMessage("generic.indexOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return 0;
        }

        @Override
        public int getCoordsPerVec() {
            return this.coordsPerVec;
        }

        @Override
        protected VecBuffer createSubBuffer(int n, int n2) {
            return VecBuffer.emptyVecBuffer(this.coordsPerVec);
        }

        @Override
        protected CompoundVecBuffer createSlice(int[] nArray, int n, int n2) {
            return new EmptyCompoundVecBuffer(this, nArray, n, n2);
        }

        @Override
        protected CompoundVecBuffer createSlice(int n, int n2) {
            return new EmptyCompoundVecBuffer(this, n, n2);
        }
    }

    protected class PositionIterable
    implements SubBufferIterable<Position> {
        protected PositionIterable() {
        }

        @Override
        public Iterator<Position> iterator(int n) {
            return CompoundVecBuffer.this.subBuffer(n).getPositions().iterator();
        }

        @Override
        public Iterator<Position> reverseIterator(int n) {
            return CompoundVecBuffer.this.subBuffer(n).getReversePositions().iterator();
        }
    }

    protected class LocationIterable
    implements SubBufferIterable<LatLon> {
        protected LocationIterable() {
        }

        @Override
        public Iterator<LatLon> iterator(int n) {
            return CompoundVecBuffer.this.subBuffer(n).getLocations().iterator();
        }

        @Override
        public Iterator<LatLon> reverseIterator(int n) {
            return CompoundVecBuffer.this.subBuffer(n).getReverseLocations().iterator();
        }
    }

    protected class VectorIterable
    implements SubBufferIterable<Vec4> {
        protected VectorIterable() {
        }

        @Override
        public Iterator<Vec4> iterator(int n) {
            return CompoundVecBuffer.this.subBuffer(n).getVectors().iterator();
        }

        @Override
        public Iterator<Vec4> reverseIterator(int n) {
            return CompoundVecBuffer.this.subBuffer(n).getReverseVectors().iterator();
        }
    }

    protected class CoordIterable
    implements SubBufferIterable<double[]> {
        private int minCoordsPerVec;

        public CoordIterable(int n) {
            this.minCoordsPerVec = n;
        }

        @Override
        public Iterator<double[]> iterator(int n) {
            return CompoundVecBuffer.this.subBuffer(n).getCoords(this.minCoordsPerVec).iterator();
        }

        @Override
        public Iterator<double[]> reverseIterator(int n) {
            return CompoundVecBuffer.this.subBuffer(n).getReverseCoords(this.minCoordsPerVec).iterator();
        }
    }

    protected static interface SubBufferIterable<T> {
        public Iterator<T> iterator(int var1);

        public Iterator<T> reverseIterator(int var1);
    }

    protected class ReverseCompoundIterator<T>
    extends CompoundIterator<T> {
        public ReverseCompoundIterator(SubBufferIterable<T> subBufferIterable) {
            super(subBufferIterable);
            this.subBuffer = this.subBufferCount - 1;
        }

        @Override
        protected void updateSubIterator() {
            while (!(this.subBuffer < 0 || this.subIterator != null && this.subIterator.hasNext())) {
                this.subIterator = this.subBufferIterable.reverseIterator(this.subBuffer);
                --this.subBuffer;
            }
        }
    }

    protected class CompoundIterator<T>
    implements Iterator<T> {
        protected int subBuffer = 0;
        protected Iterator<T> subIterator;
        protected final int subBufferCount;
        protected final SubBufferIterable<T> subBufferIterable;

        protected CompoundIterator(SubBufferIterable<T> subBufferIterable) {
            this.subBufferCount = CompoundVecBuffer.this.size();
            this.subBufferIterable = subBufferIterable;
        }

        @Override
        public boolean hasNext() {
            this.updateSubIterator();
            return this.subIterator != null && this.subIterator.hasNext();
        }

        @Override
        public T next() {
            this.updateSubIterator();
            if (this.subIterator != null && this.subIterator.hasNext()) {
                return this.subIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void updateSubIterator() {
            while (!(this.subBuffer >= this.subBufferCount || this.subIterator != null && this.subIterator.hasNext())) {
                this.subIterator = this.subBufferIterable.iterator(this.subBuffer);
                ++this.subBuffer;
            }
        }
    }
}

