/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.BarycentricQuadrilateral;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.ImageInterpolator;
import java.awt.Dimension;

public class GeographicImageInterpolator
extends ImageInterpolator {
    public GeographicImageInterpolator(Dimension dimension, float[] fArray, float[] fArray2, int n, int n2) {
        super(dimension, fArray, fArray2, n, n2);
    }

    @Override
    protected ImageInterpolator.Cell makeRootCell(int n, int n2, int n3, int n4) {
        return new GeographicCell(n, n2, n3, n4);
    }

    public Sector getSector() {
        return ((GeographicCell)this.root).isCrossesDateline() ? Sector.fromDegrees(this.root.miny, this.root.maxy, -180.0, 180.0) : Sector.fromDegrees(this.root.miny, this.root.maxy, this.root.minx, this.root.maxx);
    }

    @Override
    protected double[] computeBilinearCoordinates(float f, float f2, ImageInterpolator.Cell cell) {
        if (!((GeographicCell)cell).isCrossesDateline()) {
            return super.computeBilinearCoordinates(f, f2, cell);
        }
        int[] nArray = this.getFieldIndices(cell);
        Vec4[] vec4Array = new Vec4[4];
        for (int i = 0; i < 4; ++i) {
            double d = this.xs[nArray[i]];
            double d2 = this.ys[nArray[i]];
            if (f < 0.0f && d >= 0.0) {
                d -= 360.0;
            } else if (f >= 0.0f && d < 0.0) {
                d += 360.0;
            }
            vec4Array[i] = new Vec4(d, d2);
        }
        return BarycentricQuadrilateral.invertBilinear(new Vec4(f, f2), vec4Array[0], vec4Array[1], vec4Array[2], vec4Array[3]);
    }

    protected static class GeographicCell
    extends ImageInterpolator.Cell {
        protected boolean crossesDateline;

        public GeographicCell(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        @Override
        protected ImageInterpolator.Cell makeChildCell(int n, int n2, int n3, int n4) {
            return new GeographicCell(n, n2, n3, n4);
        }

        public boolean isCrossesDateline() {
            return this.crossesDateline;
        }

        @Override
        public boolean intersects(float f, float f2) {
            if (!this.isCrossesDateline()) {
                return super.intersects(f, f2);
            }
            return (f >= this.minx && f <= 180.0f || f >= -180.0f && f <= this.maxx) && f2 >= this.miny && f2 <= this.maxy;
        }

        @Override
        protected void computeExtremesFromLocations(Dimension dimension, float[] fArray, float[] fArray2) {
            if (!this.longitudesCrossDateline(dimension, fArray)) {
                super.computeExtremesFromLocations(dimension, fArray, fArray2);
                return;
            }
            this.minx = 180.0f;
            this.maxx = -180.0f;
            this.miny = Float.MAX_VALUE;
            this.maxy = -3.4028235E38f;
            this.crossesDateline = true;
            for (int i = this.n0; i <= this.n1; ++i) {
                for (int j = this.m0; j <= this.m1; ++j) {
                    int n = i * dimension.width + j;
                    float f = fArray[n];
                    float f2 = fArray2[n];
                    if (this.minx > f && f > 0.0f) {
                        this.minx = f;
                    }
                    if (this.maxx < f && f < 0.0f) {
                        this.maxx = f;
                    }
                    if (this.miny > f2) {
                        this.miny = f2;
                    }
                    if (!(this.maxy < f2)) continue;
                    this.maxy = f2;
                }
            }
        }

        @Override
        protected void computeExtremesFromChildren() {
            if (!this.childrenCrossDateline()) {
                super.computeExtremesFromChildren();
                return;
            }
            this.minx = 180.0f;
            this.maxx = -180.0f;
            this.miny = Float.MAX_VALUE;
            this.maxy = -3.4028235E38f;
            this.crossesDateline = true;
            for (ImageInterpolator.Cell cell : this.children) {
                if (((GeographicCell)cell).isCrossesDateline()) {
                    if (this.minx > cell.minx) {
                        this.minx = cell.minx;
                    }
                    if (this.maxx < cell.maxx) {
                        this.maxx = cell.maxx;
                    }
                } else {
                    if (this.minx > cell.minx && cell.minx > 0.0f) {
                        this.minx = cell.minx;
                    }
                    if (this.maxx < cell.maxx && cell.maxx < 0.0f) {
                        this.maxx = cell.maxx;
                    }
                    if (cell.minx <= 0.0f && cell.maxx >= 0.0f) {
                        this.maxx = 0.0f;
                        this.minx = 0.0f;
                    }
                }
                if (this.miny > cell.miny) {
                    this.miny = cell.miny;
                }
                if (!(this.maxy < cell.maxy)) continue;
                this.maxy = cell.maxy;
            }
        }

        protected boolean longitudesCrossDateline(Dimension dimension, float[] fArray) {
            Float f = null;
            for (int i = this.n0; i <= this.n1; ++i) {
                for (int j = this.m0; j <= this.m1; ++j) {
                    float f2;
                    int n = i * dimension.width + j;
                    float f3 = fArray[n];
                    if (f != null && Math.signum(f.floatValue()) != Math.signum(f3) && (f2 = Math.abs(f.floatValue() - f3)) > 180.0f && f2 < 360.0f) {
                        return true;
                    }
                    f = Float.valueOf(f3);
                }
            }
            return false;
        }

        protected boolean childrenCrossDateline() {
            if (this.children == null || this.children.length == 0) {
                return false;
            }
            for (ImageInterpolator.Cell cell : this.children) {
                if (!((GeographicCell)cell).isCrossesDateline()) continue;
                return true;
            }
            return false;
        }
    }
}

