/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.GeoQuad;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class ImageTiler {
    public static int DEFAULT_IMAGE_TILE_SIZE = 2048;
    private int tileWidth = DEFAULT_IMAGE_TILE_SIZE;
    private int tileHeight = DEFAULT_IMAGE_TILE_SIZE;
    private Color transparencyColor = new Color(0, 0, 0, 0);

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int n) {
        this.tileWidth = n;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int n) {
        this.tileHeight = n;
    }

    public Color getTransparencyColor() {
        return this.transparencyColor;
    }

    public void setTransparencyColor(Color color) {
        this.transparencyColor = color;
    }

    public void tileImage(BufferedImage bufferedImage, Sector sector, ImageTilerListener imageTilerListener) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0) {
            String string = Logging.getMessage("generic.InvalidImageSize");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (imageTilerListener == null) {
            String string = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage.getWidth() == this.getTileWidth() && bufferedImage.getHeight() == this.getTileHeight()) {
            imageTilerListener.newTile(bufferedImage, sector);
            return;
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = Math.min(n, this.getTileWidth());
        int n4 = Math.min(n2, this.getTileHeight());
        int n5 = (int)Math.ceil((double)n / (double)n3);
        int n6 = (int)Math.ceil((double)n2 / (double)n4);
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        for (int i = 0; i < n6; ++i) {
            int n7 = i * n4;
            int n8 = n7 + n4 <= n2 ? n4 : n2 - n7;
            double d = (double)(n7 + this.getTileHeight()) / (double)n2;
            double d2 = (double)n7 / (double)n2;
            Angle angle = sector.getMaxLatitude().subtract(sector.getDeltaLat().multiply(d));
            Angle angle2 = sector.getMaxLatitude().subtract(sector.getDeltaLat().multiply(d2));
            for (int j = 0; j < n5; ++j) {
                int n9;
                BufferedImage bufferedImage2;
                int n10;
                int n11 = j * n3;
                int n12 = n10 = n11 + n3 <= n ? n3 : n - n11;
                if (n10 == this.getTileWidth() && n8 == this.getTileHeight()) {
                    Graphics2D graphics2D;
                    if (!bl) {
                        bufferedImage2 = new BufferedImage(this.getTileWidth(), this.getTileHeight(), 5);
                        if (!ImageUtil.isCompatibleImage(bufferedImage2)) {
                            bufferedImage2 = ImageUtil.toCompatibleImage(bufferedImage2);
                        }
                        graphics2D = bufferedImage2.createGraphics();
                        graphics2D.drawImage(bufferedImage.getSubimage(n11, n7, n10, n8), 0, 0, n10, n8, null);
                    } else {
                        bufferedImage2 = new BufferedImage(this.getTileWidth(), this.getTileHeight(), 6);
                        if (!ImageUtil.isCompatibleImage(bufferedImage2)) {
                            bufferedImage2 = ImageUtil.toCompatibleImage(bufferedImage2);
                        }
                        graphics2D = bufferedImage2.createGraphics();
                        graphics2D.setBackground(this.transparencyColor);
                        graphics2D.clearRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                        graphics2D.drawImage(bufferedImage.getSubimage(n11, n7, n10, n8), 0, 0, n10, n8, null);
                    }
                    double d3 = (double)n11 / (double)n;
                    double d4 = ((double)n11 + (double)this.getTileWidth()) / (double)n;
                    Angle angle3 = sector.getMinLongitude().add(sector.getDeltaLon().multiply(d3));
                    Angle angle4 = sector.getMinLongitude().add(sector.getDeltaLon().multiply(d4));
                    imageTilerListener.newTile(bufferedImage2, new Sector(angle, angle2, angle3, angle4));
                    continue;
                }
                int n13 = n10 == this.getTileWidth() ? this.getTileWidth() : WWMath.powerOfTwoCeiling(n10);
                bufferedImage2 = new BufferedImage(n13, n9 = n8 == this.getTileHeight() ? this.getTileHeight() : WWMath.powerOfTwoCeiling(n8), 6);
                if (!ImageUtil.isCompatibleImage(bufferedImage2)) {
                    bufferedImage2 = ImageUtil.toCompatibleImage(bufferedImage2);
                }
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.setBackground(this.transparencyColor);
                graphics2D.clearRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                graphics2D.drawImage(bufferedImage.getSubimage(n11, n7, n10, n8), 0, 0, n10, n8, null);
                double d5 = (double)n11 / (double)n;
                double d6 = ((double)n11 + (double)bufferedImage2.getWidth()) / (double)n;
                Angle angle5 = sector.getMinLongitude().add(sector.getDeltaLon().multiply(d5));
                Angle angle6 = sector.getMinLongitude().add(sector.getDeltaLon().multiply(d6));
                double d7 = (double)(n7 + bufferedImage2.getHeight()) / (double)n2;
                Angle angle7 = sector.getMaxLatitude().subtract(sector.getDeltaLat().multiply(d7));
                imageTilerListener.newTile(bufferedImage2, new Sector(angle7, angle2, angle5, angle6));
            }
        }
    }

    public void tileImage(BufferedImage bufferedImage, List<? extends LatLon> list, ImageTilerListener imageTilerListener) {
        Object object;
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0) {
            String string = Logging.getMessage("generic.InvalidImageSize");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (imageTilerListener == null) {
            String string = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage.getWidth() == this.getTileWidth() && bufferedImage.getHeight() == this.getTileHeight()) {
            imageTilerListener.newTile(bufferedImage, list);
            return;
        }
        int n = 0;
        for (LatLon latLon : list) {
            if (latLon == null) {
                String string = Logging.getMessage("nullValue.LocationInListIsNull");
                Logging.logger().log(Level.SEVERE, string);
                throw new IllegalArgumentException(string);
            }
            if (++n <= 3) continue;
            break;
        }
        if (n < 4) {
            object = Logging.getMessage("nullValue.LocationInListIsNull");
            Logging.logger().severe((String)object);
            throw new IllegalArgumentException((String)object);
        }
        object = new GeoQuad(list);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = Math.min(n2, this.getTileWidth());
        int n5 = Math.min(n3, this.getTileHeight());
        int n6 = (int)Math.ceil((double)n2 / (double)n4);
        int n7 = (int)Math.ceil((double)n3 / (double)n5);
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        for (int i = 0; i < n7; ++i) {
            int n8 = i * n5;
            int n9 = n8 + n5 <= n3 ? n5 : n3 - n8;
            double d = 1.0 - (double)(n8 + this.getTileHeight()) / (double)n3;
            double d2 = 1.0 - (double)n8 / (double)n3;
            for (int j = 0; j < n6; ++j) {
                LatLon latLon;
                LatLon latLon2;
                LatLon latLon3;
                LatLon latLon4;
                BufferedImage bufferedImage2;
                int n10;
                int n11 = j * n4;
                int n12 = n10 = n11 + n4 <= n2 ? n4 : n2 - n11;
                if (n10 == this.getTileWidth() && n9 == this.getTileHeight()) {
                    Graphics2D graphics2D;
                    if (!bl) {
                        bufferedImage2 = new BufferedImage(this.getTileWidth(), this.getTileHeight(), 5);
                        graphics2D = bufferedImage2.createGraphics();
                        graphics2D.drawImage(bufferedImage.getSubimage(n11, n8, n10, n9), 0, 0, n10, n9, null);
                        continue;
                    }
                    bufferedImage2 = new BufferedImage(this.getTileWidth(), this.getTileHeight(), 6);
                    graphics2D = bufferedImage2.createGraphics();
                    graphics2D.setBackground(this.transparencyColor);
                    graphics2D.clearRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                    graphics2D.drawImage(bufferedImage.getSubimage(n11, n8, n10, n9), 0, 0, n10, n9, null);
                    double d3 = (double)n11 / (double)n2;
                    double d4 = ((double)n11 + (double)this.getTileWidth()) / (double)n2;
                    latLon4 = ((GeoQuad)object).interpolate(d, d3);
                    latLon3 = ((GeoQuad)object).interpolate(d, d4);
                    latLon2 = ((GeoQuad)object).interpolate(d2, d4);
                    latLon = ((GeoQuad)object).interpolate(d2, d3);
                } else {
                    int n13 = n10 == this.getTileWidth() ? this.getTileWidth() : WWMath.powerOfTwoCeiling(n10);
                    int n14 = n9 == this.getTileHeight() ? this.getTileHeight() : WWMath.powerOfTwoCeiling(n9);
                    bufferedImage2 = new BufferedImage(n13, n14, 6);
                    Graphics2D graphics2D = bufferedImage2.createGraphics();
                    graphics2D.setBackground(this.transparencyColor);
                    graphics2D.clearRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                    graphics2D.drawImage(bufferedImage.getSubimage(n11, n8, n10, n9), 0, 0, n10, n9, null);
                    double d5 = (double)n11 / (double)n2;
                    double d6 = ((double)n11 + (double)bufferedImage2.getWidth()) / (double)n2;
                    double d7 = 1.0 - (double)(n8 + bufferedImage2.getHeight()) / (double)n3;
                    latLon4 = ((GeoQuad)object).interpolate(d7, d5);
                    latLon3 = ((GeoQuad)object).interpolate(d7, d6);
                    latLon2 = ((GeoQuad)object).interpolate(d2, d6);
                    latLon = ((GeoQuad)object).interpolate(d2, d5);
                }
                imageTilerListener.newTile(bufferedImage2, Arrays.asList(latLon4, latLon3, latLon2, latLon));
            }
        }
    }

    public static abstract class ImageTilerListener {
        public abstract void newTile(BufferedImage var1, Sector var2);

        public abstract void newTile(BufferedImage var1, List<? extends LatLon> var2);
    }
}

