/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.AbsentResourceList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class Level
extends AVListImpl
implements Comparable<Level> {
    protected AVList params;
    protected int levelNumber;
    protected String levelName;
    protected LatLon tileDelta;
    protected int tileWidth;
    protected int tileHeight;
    protected String cacheName;
    protected String service;
    protected String dataset;
    protected String formatSuffix;
    protected double texelSize;
    protected String path;
    protected TileUrlBuilder urlBuilder;
    protected long expiryTime = 0L;
    protected boolean active = true;
    protected AbsentResourceList absentTiles;
    int DEFAULT_MAX_ABSENT_TILE_ATTEMPTS = 2;
    int DEFAULT_MIN_ABSENT_TILE_CHECK_INTERVAL = 10000;

    public Level(AVList aVList) {
        Integer n;
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.LevelConfigParams");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.params = aVList.copy();
        String string = this.validate(aVList);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string2 = this.params.getStringValue("gov.nasa.worldwind.avkey.LevelNameKey");
        this.levelName = string2 != null ? string2 : "";
        this.levelNumber = (Integer)this.params.getValue("gov.nasa.worldwind.avkey.LevelNumberKey");
        this.tileDelta = (LatLon)this.params.getValue("gov.nasa.worldwind.avkey.TileDeltaKey");
        this.tileWidth = (Integer)this.params.getValue("gov.nasa.worldwind.avkey.TileWidthKey");
        this.tileHeight = (Integer)this.params.getValue("gov.nasa.worldwind.avkey.TileHeightKey");
        this.cacheName = this.params.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey");
        this.service = this.params.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey");
        this.dataset = this.params.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey");
        this.formatSuffix = this.params.getStringValue("gov.nasa.worldwind.avkey.FormatSuffixKey");
        this.urlBuilder = (TileUrlBuilder)this.params.getValue("gov.nasa.worldwind.avkey.TileURLBuilder");
        this.expiryTime = AVListImpl.getLongValue(aVList, "gov.nasa.worldwind.avkey.ExpiryTime", 0L);
        this.texelSize = this.tileDelta.getLatitude().getRadians() / (double)this.tileHeight;
        this.path = this.cacheName + "/" + this.levelName;
        Integer n2 = (Integer)this.params.getValue("gov.nasa.worldwind.avkey.MaxAbsentTileAttempts");
        if (n2 == null) {
            n2 = this.DEFAULT_MAX_ABSENT_TILE_ATTEMPTS;
        }
        if ((n = (Integer)this.params.getValue("gov.nasa.worldwind.avkey.MinAbsentTileCheckInterval")) == null) {
            n = this.DEFAULT_MIN_ABSENT_TILE_CHECK_INTERVAL;
        }
        this.absentTiles = new AbsentResourceList(n2, n);
    }

    protected String validate(AVList aVList) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.LevelNumberKey");
        if (object == null || !(object instanceof Integer) || (Integer)object < 0) {
            stringBuffer.append(Logging.getMessage("term.levelNumber")).append(" ");
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.LevelNameKey")) == null || !(object instanceof String)) {
            stringBuffer.append(Logging.getMessage("term.levelName")).append(" ");
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey")) == null || !(object instanceof Integer) || (Integer)object < 0) {
            stringBuffer.append(Logging.getMessage("term.tileWidth")).append(" ");
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey")) == null || !(object instanceof Integer) || (Integer)object < 0) {
            stringBuffer.append(Logging.getMessage("term.tileHeight")).append(" ");
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.TileDeltaKey")) == null || !(object instanceof LatLon)) {
            stringBuffer.append(Logging.getMessage("term.tileDelta")).append(" ");
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) == null || !(object instanceof String) || ((String)object).length() < 1) {
            stringBuffer.append(Logging.getMessage("term.fileStoreFolder")).append(" ");
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.TileURLBuilder")) == null || !(object instanceof TileUrlBuilder)) {
            stringBuffer.append(Logging.getMessage("term.tileURLBuilder")).append(" ");
        }
        if (!((object = aVList.getValue("gov.nasa.worldwind.avkey.ExpiryTime")) == null || object instanceof Long && (Long)object >= 1L)) {
            stringBuffer.append(Logging.getMessage("term.expiryTime")).append(" ");
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.LevelNameKey").length() > 0) {
            object = aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey");
            if (object == null || !(object instanceof String) || ((String)object).length() < 1) {
                stringBuffer.append(Logging.getMessage("term.datasetName")).append(" ");
            }
            if ((object = aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey")) == null || !(object instanceof String) || ((String)object).length() < 1) {
                stringBuffer.append(Logging.getMessage("term.formatSuffix")).append(" ");
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return Logging.getMessage("layers.LevelSet.InvalidLevelDescriptorFields", stringBuffer.toString());
    }

    public AVList getParams() {
        return this.params;
    }

    public String getPath() {
        return this.path;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public LatLon getTileDelta() {
        return this.tileDelta;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public String getFormatSuffix() {
        return this.formatSuffix;
    }

    public String getService() {
        return this.service;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public double getTexelSize() {
        return this.texelSize;
    }

    public boolean isEmpty() {
        return this.levelName == null || this.levelName.equals("") || !this.active;
    }

    public void markResourceAbsent(long l) {
        if (l >= 0L) {
            this.absentTiles.markResourceAbsent(l);
        }
    }

    public boolean isResourceAbsent(long l) {
        return this.absentTiles.isResourceAbsent(l);
    }

    public void unmarkResourceAbsent(long l) {
        if (l >= 0L) {
            this.absentTiles.unmarkResourceAbsent(l);
        }
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public AbsentResourceList getAbsentTiles() {
        return this.absentTiles;
    }

    @Override
    public Object setValue(String string, Object object) {
        if (string != null && string.equals("gov.nasa.worldwind.avkey.MaxAbsentTileAttempts") && object instanceof Integer) {
            this.absentTiles.setMaxTries((Integer)object);
        } else if (string != null && string.equals("gov.nasa.worldwind.avkey.MinAbsentTileCheckInterval") && object instanceof Integer) {
            this.absentTiles.setMinCheckInterval((Integer)object);
        }
        return super.setValue(string, object);
    }

    @Override
    public Object getValue(String string) {
        if (string != null && string.equals("gov.nasa.worldwind.avkey.MaxAbsentTileAttempts")) {
            return this.absentTiles.getMaxTries();
        }
        if (string != null && string.equals("gov.nasa.worldwind.avkey.MinAbsentTileCheckInterval")) {
            return this.absentTiles.getMinCheckInterval();
        }
        return super.getValue(string);
    }

    public URL getTileResourceURL(Tile tile, String string) throws MalformedURLException {
        if (tile == null) {
            String string2 = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.urlBuilder.getURL(tile, string);
    }

    public Sector computeSectorForPosition(Angle angle, Angle angle2, LatLon latLon) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.TileOriginIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle3 = this.getTileDelta().getLatitude();
        Angle angle4 = this.getTileDelta().getLongitude();
        Angle angle5 = latLon.getLatitude();
        Angle angle6 = latLon.getLongitude();
        int n = Tile.computeRow(angle3, angle, angle5);
        int n2 = Tile.computeColumn(angle4, angle2, angle6);
        Angle angle7 = Tile.computeRowLatitude(n, angle3, angle5);
        Angle angle8 = Tile.computeColumnLongitude(n2, angle4, angle6);
        return new Sector(angle7, angle7.add(angle3), angle8, angle8.add(angle4));
    }

    @Override
    public int compareTo(Level level) {
        if (level == null) {
            String string = Logging.getMessage("nullValue.LevelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.levelNumber < level.levelNumber ? -1 : (this.levelNumber == level.levelNumber ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Level level = (Level)object;
        if (this.levelNumber != level.levelNumber) {
            return false;
        }
        if (this.tileHeight != level.tileHeight) {
            return false;
        }
        if (this.tileWidth != level.tileWidth) {
            return false;
        }
        if (this.cacheName != null ? !this.cacheName.equals(level.cacheName) : level.cacheName != null) {
            return false;
        }
        if (this.dataset != null ? !this.dataset.equals(level.dataset) : level.dataset != null) {
            return false;
        }
        if (this.formatSuffix != null ? !this.formatSuffix.equals(level.formatSuffix) : level.formatSuffix != null) {
            return false;
        }
        if (this.levelName != null ? !this.levelName.equals(level.levelName) : level.levelName != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(level.service) : level.service != null) {
            return false;
        }
        return !(this.tileDelta != null ? !this.tileDelta.equals(level.tileDelta) : level.tileDelta != null);
    }

    public int hashCode() {
        int n = this.levelNumber;
        n = 29 * n + (this.levelName != null ? this.levelName.hashCode() : 0);
        n = 29 * n + (this.tileDelta != null ? this.tileDelta.hashCode() : 0);
        n = 29 * n + this.tileWidth;
        n = 29 * n + this.tileHeight;
        n = 29 * n + (this.formatSuffix != null ? this.formatSuffix.hashCode() : 0);
        n = 29 * n + (this.service != null ? this.service.hashCode() : 0);
        n = 29 * n + (this.dataset != null ? this.dataset.hashCode() : 0);
        n = 29 * n + (this.cacheName != null ? this.cacheName.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.path;
    }
}

