/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class LevelSet
extends WWObjectImpl {
    private final Sector sector;
    private final LatLon levelZeroTileDelta;
    private final LatLon tileOrigin;
    private final int numLevelZeroColumns;
    private final ArrayList<Level> levels = new ArrayList();
    private final SectorResolution[] sectorLevelLimits;

    public LevelSet(AVList aVList) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta");
        if (object3 == null || !(object3 instanceof LatLon)) {
            stringBuffer.append(Logging.getMessage("term.tileDelta")).append(" ");
        }
        if ((object3 = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object3 instanceof Sector)) {
            stringBuffer.append(Logging.getMessage("term.sector")).append(" ");
        }
        int n = 0;
        object3 = aVList.getValue("gov.nasa.worldwind.avkey.NumLevels");
        if (object3 == null || !(object3 instanceof Integer) || (n = ((Integer)object3).intValue()) < 1) {
            stringBuffer.append(Logging.getMessage("term.numLevels")).append(" ");
        }
        int n2 = 0;
        object3 = aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels");
        if (object3 != null && object3 instanceof Integer && (Integer)object3 > 0) {
            n2 = (Integer)object3;
        }
        String[] stringArray = null;
        object3 = aVList.getValue("gov.nasa.worldwind.avkey.InactiveLevels");
        if (object3 != null && !(object3 instanceof String)) {
            stringBuffer.append(Logging.getMessage("term.inactiveLevels")).append(" ");
        } else if (object3 != null) {
            stringArray = ((String)object3).split(",");
        }
        SectorResolution[] sectorResolutionArray = null;
        object3 = aVList.getValue("gov.nasa.worldwind.avkey.SectorResolutionLimits");
        if (object3 != null && !(object3 instanceof SectorResolution[])) {
            stringBuffer.append(Logging.getMessage("term.sectorResolutionLimits")).append(" ");
        } else if (object3 != null) {
            for (SectorResolution sectorResolution : sectorResolutionArray = (SectorResolution[])object3) {
                if (sectorResolution.levelNumber <= n - 1) continue;
                object = Logging.getMessage("LevelSet.sectorResolutionLimitsTooHigh", sectorResolution.levelNumber, n - 1);
                Logging.logger().warning((String)object);
                break;
            }
        }
        this.sectorLevelLimits = sectorResolutionArray;
        if (stringBuffer.length() > 0) {
            String string = Logging.getMessage("layers.LevelSet.InvalidLevelDescriptorFields", stringBuffer.toString());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        this.levelZeroTileDelta = (LatLon)aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta");
        object3 = aVList.getValue("gov.nasa.worldwind.avkey.TileOrigin");
        this.tileOrigin = object3 != null && object3 instanceof LatLon ? (LatLon)object3 : new LatLon(Angle.NEG90, Angle.NEG180);
        TileUrlBuilder tileUrlBuilder = (TileUrlBuilder)(aVList = aVList.copy()).getValue("gov.nasa.worldwind.avkey.TileURLBuilder");
        if (tileUrlBuilder == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new TileUrlBuilder(){

                @Override
                public URL getURL(Tile tile, String string) throws MalformedURLException {
                    String string2 = tile.getLevel().getService();
                    if (string2 == null || string2.length() < 1) {
                        return null;
                    }
                    StringBuffer stringBuffer = new StringBuffer(tile.getLevel().getService());
                    if (stringBuffer.lastIndexOf("?") != stringBuffer.length() - 1) {
                        stringBuffer.append("?");
                    }
                    stringBuffer.append("T=");
                    stringBuffer.append(tile.getLevel().getDataset());
                    stringBuffer.append("&L=");
                    stringBuffer.append(tile.getLevel().getLevelName());
                    stringBuffer.append("&X=");
                    stringBuffer.append(tile.getColumn());
                    stringBuffer.append("&Y=");
                    stringBuffer.append(tile.getRow());
                    return new URL(string == null ? stringBuffer.toString() : stringBuffer.toString().replace("dds", ""));
                }
            });
        }
        if (this.sectorLevelLimits != null) {
            Arrays.sort(this.sectorLevelLimits, new Comparator<SectorResolution>(){

                @Override
                public int compare(SectorResolution sectorResolution, SectorResolution sectorResolution2) {
                    return sectorResolution.levelNumber < sectorResolution2.levelNumber ? 1 : (sectorResolution.levelNumber == sectorResolution2.levelNumber ? 0 : -1);
                }
            });
        }
        int n3 = Tile.computeColumn(this.levelZeroTileDelta.getLongitude(), this.sector.getMinLongitude(), this.tileOrigin.getLongitude());
        int n4 = Tile.computeColumn(this.levelZeroTileDelta.getLongitude(), this.sector.getMaxLongitude(), this.tileOrigin.getLongitude());
        this.numLevelZeroColumns = Math.max(1, n4 - n3 + 1);
        for (int i = 0; i < n; ++i) {
            aVList.setValue("gov.nasa.worldwind.avkey.LevelNameKey", i < n2 ? "" : Integer.toString(i - n2));
            aVList.setValue("gov.nasa.worldwind.avkey.LevelNumberKey", i);
            object = this.levelZeroTileDelta.getLatitude().divide(Math.pow(2.0, i));
            Angle angle = this.levelZeroTileDelta.getLongitude().divide(Math.pow(2.0, i));
            aVList.setValue("gov.nasa.worldwind.avkey.TileDeltaKey", new LatLon((Angle)object, angle));
            this.levels.add(new Level(aVList));
        }
        if (stringArray != null) {
            for (String string : stringArray) {
                int n5 = Integer.parseInt(string);
                this.getLevel(n5).setActive(false);
            }
        }
    }

    public LevelSet(LevelSet levelSet) {
        if (levelSet == null) {
            String string = Logging.getMessage("nullValue.LevelSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = levelSet.sector;
        this.levelZeroTileDelta = levelSet.levelZeroTileDelta;
        this.tileOrigin = levelSet.tileOrigin;
        this.numLevelZeroColumns = levelSet.numLevelZeroColumns;
        this.sectorLevelLimits = levelSet.sectorLevelLimits;
        for (Level level : levelSet.levels) {
            this.levels.add(level);
        }
    }

    @Override
    public Object setValue(String string, Object object) {
        for (Level level : this.levels) {
            level.setValue(string, object);
        }
        return super.setValue(string, object);
    }

    @Override
    public Object getValue(String string) {
        Object object = super.getValue(string);
        if (object != null) {
            return object;
        }
        for (Level level : this.getLevels()) {
            if (level == null || (object = level.getValue(string)) == null) continue;
            return object;
        }
        return null;
    }

    public final Sector getSector() {
        return this.sector;
    }

    public final LatLon getLevelZeroTileDelta() {
        return this.levelZeroTileDelta;
    }

    public final LatLon getTileOrigin() {
        return this.tileOrigin;
    }

    public final SectorResolution[] getSectorLevelLimits() {
        if (this.sectorLevelLimits == null) {
            return null;
        }
        SectorResolution[] sectorResolutionArray = new SectorResolution[this.sectorLevelLimits.length];
        System.arraycopy(this.sectorLevelLimits, 0, sectorResolutionArray, 0, this.sectorLevelLimits.length);
        return sectorResolutionArray;
    }

    public final ArrayList<Level> getLevels() {
        return this.levels;
    }

    public final Level getLevel(int n) {
        return n >= 0 && n < this.levels.size() ? this.levels.get(n) : null;
    }

    public final int getNumLevels() {
        return this.levels.size();
    }

    public final Level getFirstLevel() {
        return this.getLevel(0);
    }

    public final Level getLastLevel() {
        return this.getLevel(this.getNumLevels() - 1);
    }

    public final Level getNextToLastLevel() {
        return this.getLevel(this.getNumLevels() > 1 ? this.getNumLevels() - 2 : 0);
    }

    public final Level getLastLevel(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.getSector().intersects(sector)) {
            return null;
        }
        Level level = this.getLevel(this.getNumLevels() - 1);
        if (this.sectorLevelLimits != null) {
            for (SectorResolution sectorResolution : this.sectorLevelLimits) {
                if (!sectorResolution.sector.intersects(sector) || sectorResolution.levelNumber > level.getLevelNumber()) continue;
                level = this.getLevel(sectorResolution.levelNumber);
                break;
            }
        }
        return level;
    }

    public final Level getLastLevel(Angle angle, Angle angle2) {
        Level level = this.getLevel(this.getNumLevels() - 1);
        if (this.sectorLevelLimits != null) {
            for (SectorResolution sectorResolution : this.sectorLevelLimits) {
                if (!sectorResolution.sector.contains(angle, angle2) || sectorResolution.levelNumber > level.getLevelNumber()) continue;
                level = this.getLevel(sectorResolution.levelNumber);
                break;
            }
        }
        return level;
    }

    public final boolean isFinalLevel(int n) {
        return n == this.getNumLevels() - 1;
    }

    public final boolean isLevelEmpty(int n) {
        return this.levels.get(n).isEmpty();
    }

    private int numColumnsInLevel(Level level) {
        int n = level.getLevelNumber() - this.getFirstLevel().getLevelNumber();
        double d = Math.pow(2.0, n);
        return (int)(d * (double)this.numLevelZeroColumns);
    }

    private long getTileNumber(Tile tile) {
        return tile.getRow() < 0 ? -1L : (long)tile.getRow() * (long)this.numColumnsInLevel(tile.getLevel()) + (long)tile.getColumn();
    }

    private long getTileNumber(TileKey tileKey) {
        return tileKey.getRow() < 0 ? -1L : (long)tileKey.getRow() * (long)this.numColumnsInLevel(this.getLevel(tileKey.getLevelNumber())) + (long)tileKey.getColumn();
    }

    public final void markResourceAbsent(Tile tile) {
        if (tile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        tile.getLevel().markResourceAbsent(this.getTileNumber(tile));
    }

    public final boolean isResourceAbsent(TileKey tileKey) {
        if (tileKey == null) {
            String string = Logging.getMessage("nullValue.TileKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Level level = this.getLevel(tileKey.getLevelNumber());
        return level.isEmpty() || level.isResourceAbsent(this.getTileNumber(tileKey));
    }

    public final boolean isResourceAbsent(Tile tile) {
        if (tile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return tile.getLevel().isEmpty() || tile.getLevel().isResourceAbsent(this.getTileNumber(tile));
    }

    public final void unmarkResourceAbsent(Tile tile) {
        if (tile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        tile.getLevel().unmarkResourceAbsent(this.getTileNumber(tile));
    }

    public Sector computeSectorForKey(TileKey tileKey) {
        if (tileKey == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Level level = this.getLevel(tileKey.getLevelNumber());
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = this.tileOrigin.getLatitude();
        Angle angle4 = this.tileOrigin.getLongitude();
        Angle angle5 = Tile.computeRowLatitude(tileKey.getRow(), angle, angle3);
        Angle angle6 = Tile.computeColumnLongitude(tileKey.getColumn(), angle2, angle4);
        return new Sector(angle5, angle5.add(angle), angle6, angle6.add(angle2));
    }

    public Tile createTile(TileKey tileKey) {
        if (tileKey == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Level level = this.getLevel(tileKey.getLevelNumber());
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = this.tileOrigin.getLatitude();
        Angle angle4 = this.tileOrigin.getLongitude();
        Angle angle5 = Tile.computeRowLatitude(tileKey.getRow(), angle, angle3);
        Angle angle6 = Tile.computeColumnLongitude(tileKey.getColumn(), angle2, angle4);
        Sector sector = new Sector(angle5, angle5.add(angle), angle6, angle6.add(angle2));
        return new Tile(sector, level, tileKey.getRow(), tileKey.getColumn());
    }

    public void setExpiryTime(long l) {
        for (Level level : this.levels) {
            level.setExpiryTime(l);
        }
    }

    public static final class SectorResolution {
        private final int levelNumber;
        private final Sector sector;

        public SectorResolution(Sector sector, int n) {
            this.levelNumber = n;
            this.sector = sector;
        }

        public final int getLevelNumber() {
            return this.levelNumber;
        }

        public final Sector getSector() {
            return this.sector;
        }
    }
}

