/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Configuration;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Logging {
    protected static final String MESSAGE_BUNDLE_NAME = Logging.class.getPackage().getName() + ".MessageStrings";
    protected static final int MAX_MESSAGE_REPEAT = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.MaxMessageRepeat", 10);

    private Logging() {
    }

    public static Logger logger() {
        try {
            String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.LoggerName", "gov.nasa.worldwind");
            return Logging.logger(string);
        }
        catch (Exception exception) {
            return Logging.logger("gov.nasa.worldwind");
        }
    }

    public static Logger logger(String string) {
        return Logger.getLogger(string != null ? string : "", MESSAGE_BUNDLE_NAME);
    }

    public static String getMessage(String string) {
        try {
            return (String)ResourceBundle.getBundle(MESSAGE_BUNDLE_NAME, Locale.getDefault()).getObject(string);
        }
        catch (Exception exception) {
            String string2 = "Exception looking up message from bundle " + MESSAGE_BUNDLE_NAME;
            Logging.logger().log(Level.SEVERE, string2, exception);
            return string2;
        }
    }

    public static String getMessage(String string, String string2) {
        return string2 != null ? Logging.getMessage(string, new Object[]{string2}) : Logging.getMessage(string);
    }

    public static String getMessage(String string, Object ... objectArray) {
        String string2;
        try {
            string2 = (String)ResourceBundle.getBundle(MESSAGE_BUNDLE_NAME, Locale.getDefault()).getObject(string);
        }
        catch (Exception exception) {
            String string3 = "Exception looking up message from bundle " + MESSAGE_BUNDLE_NAME;
            Logging.logger().log(Level.SEVERE, string3, exception);
            return string3;
        }
        try {
            return objectArray == null ? string2 : MessageFormat.format(string2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = "Message arguments do not match format string: " + string;
            Logging.logger().log(Level.SEVERE, string2, illegalArgumentException);
            return string2;
        }
    }

    public static int getMaxMessageRepeatCount() {
        return MAX_MESSAGE_REPEAT;
    }
}

