/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;

public class NativeLibraryLoader {
    public static void loadLibrary(String string) throws WWRuntimeException, IllegalArgumentException {
        if (WWUtil.isEmpty(string)) {
            String string2 = Logging.getMessage("nullValue.LibraryIsNull");
            throw new IllegalArgumentException(string2);
        }
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string3 = Logging.getMessage("generic.LibraryNotLoaded", string, unsatisfiedLinkError.getMessage());
            throw new WWRuntimeException(string3);
        }
        catch (Throwable throwable) {
            String string4 = Logging.getMessage("generic.LibraryNotLoaded", string, throwable.getMessage());
            throw new WWRuntimeException(string4);
        }
    }

    protected static String makeFullLibName(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        if (Configuration.isWindowsOS()) {
            if (!string.toLowerCase().endsWith(".dll")) {
                return string + ".dll";
            }
        } else if (Configuration.isMacOS()) {
            if (!string.toLowerCase().endsWith(".jnilib") && !string.toLowerCase().startsWith("lib")) {
                return "lib" + string + ".jnilib";
            }
        } else if (Configuration.isUnixOS() && !string.toLowerCase().endsWith(".so") && !string.toLowerCase().startsWith("lib")) {
            return "lib" + string + ".so";
        }
        return string;
    }
}

