/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.cache.SessionCache;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.AbsentResourceList;
import gov.nasa.worldwind.util.Logging;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.ByteBuffer;

public class SessionCacheRetrievalPostProcessor
implements RetrievalPostProcessor {
    private String name;
    private final SessionCache cache;
    private final Object cacheKey;
    private final AbsentResourceList absentResourceList;
    private final long resourceID;
    private final PropertyChangeListener propertyListener;
    private final String propertyName;

    public SessionCacheRetrievalPostProcessor(SessionCache sessionCache, Object object, AbsentResourceList absentResourceList, long l, PropertyChangeListener propertyChangeListener, String string) {
        if (sessionCache == null) {
            String string2 = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.CacheKeyIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.cache = sessionCache;
        this.cacheKey = object;
        this.absentResourceList = absentResourceList;
        this.resourceID = l;
        this.propertyListener = propertyChangeListener;
        this.propertyName = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public final SessionCache getCache() {
        return this.cache;
    }

    public final Object getCacheKey() {
        return this.cacheKey;
    }

    public final AbsentResourceList getAbsentResourceList() {
        return this.absentResourceList;
    }

    public final long getResourceID() {
        return this.resourceID;
    }

    public final PropertyChangeListener getPropertyListener() {
        return this.propertyListener;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public ByteBuffer run(Retriever retriever) {
        if (retriever == null) {
            String string = Logging.getMessage("nullValue.RetrieverIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validate(retriever);
        if (string == null) {
            this.onRetrievalSuceeded(retriever);
        } else {
            this.onRetrievalFailed(retriever);
            Logging.logger().severe(string);
        }
        this.signalRetrievalComplete();
        return retriever.getBuffer();
    }

    protected void onRetrievalSuceeded(Retriever retriever) {
        if (this.absentResourceList != null) {
            this.absentResourceList.unmarkResourceAbsent(this.resourceID);
        }
        this.cache.put(this.cacheKey, retriever.getBuffer());
    }

    protected void onRetrievalFailed(Retriever retriever) {
        if (this.absentResourceList != null) {
            this.absentResourceList.markResourceAbsent(this.resourceID);
        }
    }

    protected String validate(Retriever retriever) {
        if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
            return Logging.getMessage("generic.RetrievalFailed", this.toString());
        }
        if (retriever.getBuffer() == null || retriever.getBuffer().limit() == 0) {
            return Logging.getMessage("generic.RetrievalReturnedNoContent", this.toString());
        }
        return null;
    }

    protected void signalRetrievalComplete() {
        if (this.propertyListener != null && this.propertyName != null) {
            this.propertyListener.propertyChange(new PropertyChangeEvent(this, this.propertyName, null, this.propertyListener));
        }
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }
}

