/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.coords.MGRSCoord;
import gov.nasa.worldwind.util.StatusBar;

public class StatusBarMGRS
extends StatusBar {
    @Override
    public void moved(PositionEvent positionEvent) {
        this.handleCursorPositionChange(positionEvent);
    }

    @Override
    protected void handleCursorPositionChange(PositionEvent positionEvent) {
        Position position = positionEvent.getPosition();
        if (position != null) {
            String string = String.format("%7.4f\u00b0 %7.4f\u00b0", position.getLatitude().getDegrees(), position.getLongitude().getDegrees());
            String string2 = this.makeCursorElevationDescription(this.getEventSource().getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude()));
            String string3 = "";
            try {
                MGRSCoord mGRSCoord = MGRSCoord.fromLatLon(position.getLatitude(), position.getLongitude(), this.getEventSource().getModel().getGlobe());
                string3 = mGRSCoord.toString();
            }
            catch (Exception exception) {
                string3 = "";
            }
            this.latDisplay.setText(string);
            this.lonDisplay.setText(string3);
            this.eleDisplay.setText(string2);
        } else {
            this.latDisplay.setText("");
            this.lonDisplay.setText("Off globe");
            this.eleDisplay.setText("");
        }
    }
}

