/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.DoubleBuffer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class WWUtil {
    public static Integer convertStringToInteger(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            if (string.length() == 0) {
                return null;
            }
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
    }

    public static Double convertStringToDouble(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            if (string.length() == 0) {
                return null;
            }
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
    }

    public static Long convertStringToLong(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            if (string.length() == 0) {
                return null;
            }
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
    }

    public static Boolean convertStringToBoolean(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            string = string.trim();
            if (string.length() == 0) {
                return null;
            }
            if (string.length() == 1) {
                return WWUtil.convertNumericStringToBoolean(string);
            }
            return Boolean.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
    }

    public static Boolean convertNumericStringToBoolean(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            if (string.length() == 0) {
                return null;
            }
            Integer n = WWUtil.makeInteger(string);
            return n != null && n != 0;
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
    }

    public static Integer makeInteger(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long makeLong(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Double makeDoubleForLocale(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        try {
            return NumberFormat.getInstance().parse(string.trim()).doubleValue();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Double makeDouble(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static CharSequence trimCharSequence(CharSequence charSequence) {
        int n;
        int n2;
        if (charSequence == null) {
            String string = Logging.getMessage("nullValue.CharSequenceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = charSequence.length();
        if (n3 == 0) {
            return charSequence;
        }
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) == ' '; ++n2) {
        }
        for (n = charSequence.length() - 1; n > n2 && charSequence.charAt(n) == ' '; --n) {
        }
        return charSequence.subSequence(n2, n + 1);
    }

    public static void alignComponent(Component component, Component component2, String string) {
        Dimension dimension = component2.getPreferredSize();
        Point point = component != null ? component.getLocation() : new Point(0, 0);
        Dimension dimension2 = component != null ? component.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
        int n = point.x;
        int n2 = point.y;
        if (string != null && string.equals("gov.nasa.worldwind.avkey.Right")) {
            n += dimension2.width - 50;
            n2 += dimension2.height - dimension.height;
        } else if (string != null && string.equals("gov.nasa.worldwind.avkey.Center")) {
            n += (dimension2.width - dimension.width) / 2;
            n2 += (dimension2.height - dimension.height) / 2;
        } else if (string != null && string.equals("gov.nasa.worldwind.avkey.LeftOfCenter")) {
            n = (int)((double)n + ((double)(dimension2.width / 2) - 1.05 * (double)dimension.width));
            n2 += (dimension2.height - dimension.height) / 2;
        } else if (string != null && string.equals("gov.nasa.worldwind.avkey.RightOfCenter")) {
            n = (int)((double)n + ((double)(dimension2.width / 2) + 0.05 * (double)dimension.width));
            n2 += (dimension2.height - dimension.height) / 2;
        }
        component2.setLocation(n, n2);
    }

    public static Color makeRandomColor(Color color) {
        if (color == null) {
            color = Color.WHITE;
        }
        float[] fArray = color.getRGBComponents(null);
        return new Color(fArray[0] * (float)Math.random(), fArray[1] * (float)Math.random(), fArray[2] * (float)Math.random(), fArray[3]);
    }

    public static Color makeRandomColor(Color color, Color color2, int n) {
        Color color3 = WWUtil.makeRandomColor(color);
        if (color2 == null) {
            return color3;
        }
        float[] fArray = color2.getRGBComponents(null);
        float[] fArray2 = color3.getRGBComponents(null);
        for (int i = 0; i < n - 1 && (fArray2[0] < fArray[0] || fArray2[1] < fArray[1] || fArray2[2] < fArray[2]); ++i) {
            fArray2 = color3.getRGBComponents(null);
        }
        return color3;
    }

    public static Color makeColorBrighter(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        f2 /= 3.0f;
        f3 *= 3.0f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        int n = Color.HSBtoRGB(f, f2, f3);
        return new Color(n);
    }

    public static Color makeColorDarker(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        f2 *= 3.0f;
        f3 /= 3.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        int n = Color.HSBtoRGB(f, f2, f3);
        return new Color(n);
    }

    public static Color computeContrastingColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float[] fArray = new float[4];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        int n = fArray[2] < 0.5f ? 255 : 0;
        int n2 = color.getAlpha();
        return new Color(n, n, n, n2);
    }

    public static Color interpolateColor(double d, Color color, Color color2) {
        if (color == null || color2 == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        float f = d < 0.0 ? 0.0f : (d > 1.0 ? 1.0f : (float)d);
        float f2 = (float)color.getRed() + f * (float)(color2.getRed() - color.getRed());
        float f3 = (float)color.getGreen() + f * (float)(color2.getGreen() - color.getGreen());
        float f4 = (float)color.getBlue() + f * (float)(color2.getBlue() - color.getBlue());
        float f5 = (float)color.getAlpha() + f * (float)(color2.getAlpha() - color.getAlpha());
        return new Color(f2 / 255.0f, f3 / 255.0f, f4 / 255.0f, f5 / 255.0f);
    }

    public static String encodeColorRGBA(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = (color.getRed() & 0xFF) << 24 | (color.getGreen() & 0xFF) << 16 | (color.getBlue() & 0xFF) << 8 | color.getAlpha() & 0xFF;
        return String.format("%#08X", n);
    }

    public static String encodeColorABGR(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = color.getRed() & 0xFF | (color.getGreen() & 0xFF) << 8 | (color.getBlue() & 0xFF) << 16 | (color.getAlpha() & 0xFF) << 24;
        return String.format("%#08X", n);
    }

    public static Color decodeColorRGBA(String string) {
        Long l;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.startsWith("#")) {
            string = string.replaceFirst("#", "0x");
        } else if (!string.startsWith("0x") && !string.startsWith("0X")) {
            string = "0x" + string;
        }
        try {
            l = Long.parseLong(string.substring(2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
        int n = (int)(l & 0xFFFFFFFFL);
        return new Color(n >> 24 & 0xFF, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static Color decodeColorABGR(String string) {
        Long l;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.startsWith("#")) {
            string = string.replaceFirst("#", "0x");
        } else if (!string.startsWith("0x") && !string.startsWith("0X")) {
            string = "0x" + string;
        }
        try {
            l = Long.parseLong(string.substring(2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = Logging.getMessage("generic.ConversionError", string);
            Logging.logger().log(Level.SEVERE, string3, numberFormatException);
            return null;
        }
        int n = (int)(l & 0xFFFFFFFFL);
        return new Color(n & 0xFF, n >> 8 & 0xFF, n >> 16 & 0xFF, n >> 24 & 0xFF);
    }

    public static boolean isEmpty(Object object) {
        return object == null || object instanceof String && ((String)object).length() == 0;
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public static double[] defaultMinMix() {
        return new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
    }

    public static void convertUTMCoordinatesToGeographic(int n, String string, DoubleBuffer doubleBuffer) {
        if (n < 1 || n > 60) {
            String string2 = Logging.getMessage("generic.ZoneIsInvalid", n);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!"gov.nasa.worldwind.avkey.North".equals(string) && !"gov.nasa.worldwdind.avkey.South".equals(string)) {
            String string3 = Logging.getMessage("generic.HemisphereIsInvalid", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (doubleBuffer == null) {
            String string4 = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (doubleBuffer.remaining() % 2 != 0) {
            String string5 = Logging.getMessage("generic.BufferSize", doubleBuffer.remaining());
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        while (doubleBuffer.hasRemaining()) {
            doubleBuffer.mark();
            double d = doubleBuffer.get();
            double d2 = doubleBuffer.get();
            LatLon latLon = UTMCoord.locationFromUTMCoord(n, string, d, d2, null);
            doubleBuffer.reset();
            doubleBuffer.put(latLon.getLongitude().degrees);
            doubleBuffer.put(latLon.getLatitude().degrees);
        }
    }

    public static void normalizeGeographicCoordinates(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (doubleBuffer.remaining() % 2 != 0) {
            String string = Logging.getMessage("generic.BufferSize", doubleBuffer.remaining());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        while (doubleBuffer.hasRemaining()) {
            doubleBuffer.mark();
            Angle angle = Angle.fromDegrees(doubleBuffer.get());
            Angle angle2 = Angle.fromDegrees(doubleBuffer.get());
            doubleBuffer.reset();
            doubleBuffer.put(Angle.normalizedLongitude((Angle)angle).degrees);
            doubleBuffer.put(Angle.normalizedLatitude((Angle)angle2).degrees);
        }
    }

    public static Object invokePropertyMethod(Object object, String string, String string2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.nullValue.ParentIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.PropertyNameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        String string5 = "set" + string;
        try {
            Method method = object.getClass().getMethod(string5, String.class);
            return method != null ? method.invoke(object, string2) : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constable constable;
            try {
                constable = WWUtil.makeDouble(string2);
                if (constable != null) {
                    Method method = object.getClass().getMethod(string5, Double.TYPE);
                    return method != null ? method.invoke(object, constable) : null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                // empty catch block
            }
            try {
                constable = WWUtil.makeInteger(string2);
                if (constable != null) {
                    Method method = object.getClass().getMethod(string5, Integer.TYPE);
                    return method != null ? method.invoke(object, constable) : null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException3) {
                // empty catch block
            }
            try {
                constable = WWUtil.convertStringToBoolean(string2);
                if (constable != null) {
                    Method method = object.getClass().getMethod(string5, Boolean.TYPE);
                    return method != null ? method.invoke(object, constable) : null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException4) {
                // empty catch block
            }
            try {
                constable = WWUtil.makeLong(string2);
                if (constable != null) {
                    Method method = object.getClass().getMethod(string5, Long.TYPE);
                    return method != null ? method.invoke(object, constable) : null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException5) {
                // empty catch block
            }
            throw new NoSuchMethodException();
        }
    }

    public static void copyValues(AVList aVList, AVList aVList2, String[] stringArray, boolean bl) {
        if (WWUtil.isEmpty(aVList) || WWUtil.isEmpty(aVList2) || WWUtil.isEmpty(stringArray) || stringArray.length == 0) {
            return;
        }
        for (String string : stringArray) {
            if (WWUtil.isEmpty(string) || !aVList.hasKey(string)) continue;
            Object object = aVList.getValue(string);
            if (aVList2.hasKey(string) && !bl) continue;
            aVList2.setValue(string, object);
        }
    }

    public static String removeWhiteSpace(String string) {
        if (WWUtil.isEmpty(string)) {
            return string;
        }
        return string.replaceAll("\\s+", "");
    }

    public static String extractExceptionReason(Throwable throwable) {
        if (throwable == null) {
            return Logging.getMessage("generic.Unknown");
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = throwable.getMessage();
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append(string);
        }
        String string2 = throwable.getClass().getName();
        Throwable throwable2 = throwable.getCause();
        if (null != throwable2 && throwable2 != throwable) {
            String string3 = throwable2.getMessage();
            String string4 = throwable2.getClass().getName();
            if (!(WWUtil.isEmpty(string2) || WWUtil.isEmpty(string4) || string2.equals(string4))) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" : ");
                }
                stringBuilder.append(string4).append(" (").append(string3).append(")");
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String stripLeadingPeriod(String string) {
        if (null != string && string.startsWith(".")) {
            return string.substring(Math.min(1, string.length()), string.length());
        }
        return string;
    }

    protected static boolean isKMLTimeShift(String string) {
        return Pattern.matches(".*[+-]+\\d\\d:\\d\\d$", string.trim());
    }

    public static Long parseTimeString(String string) {
        if (string == null) {
            return null;
        }
        if (WWUtil.isKMLTimeShift(string)) {
            string = string.trim();
            int n = string.length() - 3;
            String string2 = string.substring(0, n);
            string = string2 + string.substring(n + 1, string.length());
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzzzz");
            return simpleDateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return simpleDateFormat.parse(string).getTime();
            }
            catch (ParseException parseException2) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    return simpleDateFormat.parse(string).getTime();
                }
                catch (ParseException parseException3) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
                        return simpleDateFormat.parse(string).getTime();
                    }
                    catch (ParseException parseException4) {
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
                            return simpleDateFormat.parse(string).getTime();
                        }
                        catch (ParseException parseException5) {
                            return null;
                        }
                    }
                }
            }
        }
    }
}

