/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.gdal;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.regex.Pattern;

abstract class GDALAbstractFileFilter
implements FileFilter {
    protected HashSet<String> listFolders = new HashSet();
    protected final String searchPattern;

    protected GDALAbstractFileFilter(String string) {
        if (null == string || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.searchPattern = string;
        this.listFolders.clear();
    }

    protected boolean isHidden(String string) {
        String[] stringArray;
        if (!WWUtil.isEmpty(string) && !WWUtil.isEmpty(stringArray = string.split(Pattern.quote(File.separator)))) {
            for (String string2 : stringArray) {
                if (WWUtil.isEmpty(string2) || !string2.startsWith(".")) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getFolders() {
        String[] stringArray = new String[this.listFolders.size()];
        return this.listFolders.toArray(stringArray);
    }
}

