/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.layertree;

import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.layertree.LayerTreeModel;
import gov.nasa.worldwind.util.tree.BasicFrameAttributes;
import gov.nasa.worldwind.util.tree.BasicTree;
import gov.nasa.worldwind.util.tree.BasicTreeAttributes;
import gov.nasa.worldwind.util.tree.BasicTreeLayout;
import gov.nasa.worldwind.util.tree.TreeLayout;

public class LayerTree
extends BasicTree {
    protected static final Offset DEFAULT_OFFSET = new Offset(20.0, 140.0, "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.InsetPixels");
    protected static final String DEFAULT_FRAME_IMAGE = "images/layer-manager-64x64.png";
    protected static final String DEFAULT_FRAME_TITLE = "Layers";

    public LayerTree() {
        this.initialize(null, null);
    }

    public LayerTree(LayerTreeModel layerTreeModel) {
        if (layerTreeModel == null) {
            String string = Logging.getMessage("nullValue.ModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.initialize(layerTreeModel, null);
    }

    public LayerTree(Offset offset) {
        if (offset == null) {
            String string = Logging.getMessage("nullValue.OffsetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.initialize(null, offset);
    }

    public LayerTree(LayerTreeModel layerTreeModel, Offset offset) {
        if (layerTreeModel == null) {
            String string = Logging.getMessage("nullValue.ModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (offset == null) {
            String string = Logging.getMessage("nullValue.OffsetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.initialize(layerTreeModel, offset);
    }

    protected void initialize(LayerTreeModel layerTreeModel, Offset offset) {
        if (layerTreeModel == null) {
            layerTreeModel = this.createTreeModel();
        }
        this.setModel(layerTreeModel);
        this.setLayout(this.createTreeLayout(offset));
        this.expandPath(this.getModel().getRoot().getPath());
    }

    protected LayerTreeModel createTreeModel() {
        return new LayerTreeModel();
    }

    protected TreeLayout createTreeLayout(Offset offset) {
        if (offset == null) {
            offset = DEFAULT_OFFSET;
        }
        BasicTreeLayout basicTreeLayout = new BasicTreeLayout(this, offset);
        basicTreeLayout.getFrame().setFrameTitle(DEFAULT_FRAME_TITLE);
        basicTreeLayout.getFrame().setIconImageSource(DEFAULT_FRAME_IMAGE);
        BasicTreeAttributes basicTreeAttributes = new BasicTreeAttributes();
        basicTreeAttributes.setRootVisible(false);
        basicTreeLayout.setAttributes(basicTreeAttributes);
        BasicFrameAttributes basicFrameAttributes = new BasicFrameAttributes();
        basicFrameAttributes.setBackgroundOpacity(0.7);
        basicTreeLayout.getFrame().setAttributes(basicFrameAttributes);
        BasicTreeAttributes basicTreeAttributes2 = new BasicTreeAttributes(basicTreeAttributes);
        basicTreeLayout.setHighlightAttributes(basicTreeAttributes2);
        BasicFrameAttributes basicFrameAttributes2 = new BasicFrameAttributes(basicFrameAttributes);
        basicFrameAttributes2.setForegroundOpacity(1.0);
        basicFrameAttributes2.setBackgroundOpacity(1.0);
        basicTreeLayout.getFrame().setHighlightAttributes(basicFrameAttributes2);
        return basicTreeLayout;
    }

    @Override
    public LayerTreeModel getModel() {
        return (LayerTreeModel)super.getModel();
    }
}

