/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.layertree;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.tree.BasicTreeNode;

public class LayerTreeNode
extends BasicTreeNode {
    protected static final String DEFAULT_IMAGE = "images/16x16-icon-earth.png";
    protected Layer layer;

    public LayerTreeNode(Layer layer) {
        super(layer != null ? layer.getName() : "");
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.layer = layer;
        this.initialize();
    }

    protected void initialize() {
        Object object = this.layer.getValue("gov.nasa.worldwind.avkey.Image");
        if (object == null) {
            object = DEFAULT_IMAGE;
        }
        this.setImageSource(object);
    }

    @Override
    public boolean isSelected() {
        return this.layer.isEnabled();
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.layer.setEnabled(bl);
    }
}

