/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.measure;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.MeasurableLength;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;

public class LengthMeasurer
implements MeasurableLength {
    private static final double DEFAULT_TERRAIN_SAMPLING_STEPS = 128.0;
    private static final double DEFAULT_MAX_SEGMENT_LENGTH = 100000.0;
    private static final double DEFAULT_MIN_SEGMENT_LENGTH = 30.0;
    private ArrayList<? extends Position> positions;
    private ArrayList<? extends Position> subdividedPositions;
    private boolean followTerrain = false;
    private int pathType = 0;
    private double maxSegmentLength = 100000.0;
    private Sector sector;
    private double lengthTerrainSamplingSteps = 128.0;
    protected double length = -1.0;

    public LengthMeasurer() {
    }

    public LengthMeasurer(ArrayList<? extends Position> arrayList) {
        this.setPositions(arrayList);
    }

    protected void clearCachedValues() {
        this.subdividedPositions = null;
        this.length = -1.0;
    }

    public ArrayList<? extends Position> getPositions() {
        return this.positions;
    }

    public void setPositions(ArrayList<? extends LatLon> arrayList, double d) {
        if (arrayList == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Position> arrayList2 = new ArrayList<Position>();
        for (LatLon latLon : arrayList) {
            arrayList2.add(new Position(latLon, d));
        }
        this.setPositions(arrayList2);
    }

    public void setPositions(ArrayList<? extends Position> arrayList) {
        if (arrayList == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.positions = arrayList;
        this.sector = this.positions.size() > 2 ? Sector.boundingSector(this.positions) : null;
        this.clearCachedValues();
    }

    public boolean isFollowTerrain() {
        return this.followTerrain;
    }

    public void setFollowTerrain(boolean bl) {
        if (this.followTerrain != bl) {
            this.followTerrain = bl;
            this.clearCachedValues();
        }
    }

    public int getPathType() {
        return this.pathType;
    }

    public void setPathType(int n) {
        if (this.pathType != n) {
            this.pathType = n;
            this.clearCachedValues();
        }
    }

    public double getMaxSegmentLength() {
        return this.maxSegmentLength;
    }

    public void setMaxSegmentLength(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.maxSegmentLength != d) {
            this.maxSegmentLength = d;
            this.clearCachedValues();
        }
    }

    public Sector getBoundingSector() {
        if (this.sector == null && this.positions != null && this.positions.size() > 2) {
            this.sector = Sector.boundingSector(this.positions);
        }
        return this.sector;
    }

    public boolean isClosedShape() {
        return this.positions != null && this.positions.size() > 1 && this.positions.get(0).equals(this.positions.get(this.positions.size() - 1));
    }

    public double getLengthTerrainSamplingSteps() {
        return this.lengthTerrainSamplingSteps;
    }

    public void setLengthTerrainSamplingSteps(double d) {
        if (d < 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.lengthTerrainSamplingSteps != d) {
            this.lengthTerrainSamplingSteps = d;
            this.subdividedPositions = null;
            this.length = -1.0;
        }
    }

    @Override
    public double getLength(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.length < 0.0) {
            this.length = this.computeLength(globe, this.followTerrain);
        }
        return this.length;
    }

    protected double computeLength(Globe globe, boolean bl) {
        double d;
        if (this.positions == null || this.positions.size() < 2) {
            return -1.0;
        }
        if (this.subdividedPositions == null) {
            d = this.maxSegmentLength;
            if (bl) {
                double d2 = this.computeLength(globe, !bl);
                d = d2 / this.lengthTerrainSamplingSteps;
                d = Math.min(Math.max(d, 30.0), this.getMaxSegmentLength());
            }
            this.subdividedPositions = LengthMeasurer.subdividePositions(globe, this.positions, d, bl, this.pathType);
        }
        d = 0.0;
        Vec4 vec4 = globe.computePointFromPosition(this.subdividedPositions.get(0));
        for (int i = 1; i < this.subdividedPositions.size(); ++i) {
            Vec4 vec42 = globe.computePointFromPosition(this.subdividedPositions.get(i));
            d += vec4.distanceTo3(vec42);
            vec4 = vec42;
        }
        return d;
    }

    protected static ArrayList<? extends Position> subdividePositions(Globe globe, ArrayList<? extends Position> arrayList, double d, boolean bl, int n) {
        return LengthMeasurer.subdividePositions(globe, arrayList, d, bl, n, 0, arrayList.size());
    }

    protected static ArrayList<? extends Position> subdividePositions(Globe globe, ArrayList<? extends Position> arrayList, double d, boolean bl, int n, int n2, int n3) {
        if (arrayList == null || arrayList.size() < n2 + n3) {
            return arrayList;
        }
        ArrayList<Position> arrayList2 = new ArrayList<Position>();
        Position position = arrayList.get(n2);
        if (bl) {
            arrayList2.add(new Position(position, globe.getElevation(position.getLatitude(), position.getLongitude())));
        } else {
            arrayList2.add(position);
        }
        for (int i = 1; i < n3; ++i) {
            Position position2;
            double d2 = LatLon.greatCircleDistance((LatLon)position, (LatLon)position2).radians;
            position2 = arrayList.get(n2 + i);
            double d3 = d2 * globe.getRadiusAt(LatLon.interpolate(0.5, position, position2));
            if (d3 > d) {
                Angle angle = null;
                Angle angle2 = null;
                int n4 = (int)Math.ceil(d3 / d);
                for (int j = 1; j < n4; ++j) {
                    LatLon latLon;
                    float f = (float)j / (float)n4;
                    if (n == 1) {
                        latLon = LatLon.interpolate(f, position, position2);
                    } else if (n == 2) {
                        if (angle == null) {
                            angle = LatLon.rhumbAzimuth(position, position2);
                            angle2 = LatLon.rhumbDistance(position, position2);
                        }
                        latLon = LatLon.rhumbEndPosition((LatLon)position, angle.radians, (double)f * angle2.radians);
                    } else {
                        if (angle == null) {
                            angle = LatLon.greatCircleAzimuth(position, position2);
                            angle2 = LatLon.greatCircleDistance(position, position2);
                        }
                        latLon = LatLon.greatCircleEndPosition((LatLon)position, angle.radians, (double)f * angle2.radians);
                    }
                    double d4 = bl ? globe.getElevation(latLon.getLatitude(), latLon.getLongitude()) : position.getElevation() * (double)(1.0f - f) + position2.getElevation() * (double)f;
                    arrayList2.add(new Position(latLon, d4));
                }
            }
            if (bl) {
                arrayList2.add(new Position(position2, globe.getElevation(position2.getLatitude(), position2.getLongitude())));
            } else {
                arrayList2.add(position2);
            }
            position = position2;
        }
        return arrayList2;
    }
}

