/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.util.HotSpot;
import gov.nasa.worldwind.util.tree.TreeHotSpot;
import java.awt.Point;

public abstract class DragControl
extends TreeHotSpot {
    protected boolean dragging;
    protected Point dragRefPoint;

    public DragControl(HotSpot hotSpot) {
        super(hotSpot);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null || this.isConsumed(selectEvent)) {
            return;
        }
        Point point = selectEvent.getPickPoint();
        if (selectEvent.isDrag()) {
            if (!this.isDragging()) {
                this.dragging = true;
                this.beginDrag(point);
            }
            this.drag(point);
            selectEvent.consume();
        } else if (selectEvent.isDragEnd()) {
            this.dragging = false;
            this.endDrag();
            selectEvent.consume();
        }
    }

    protected void beginDrag(Point point) {
        this.dragRefPoint = point;
    }

    protected abstract void drag(Point var1);

    protected void endDrag() {
        this.dragRefPoint = null;
    }
}

