/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.AbstractResizeHotSpot;
import gov.nasa.worldwind.util.tree.ScrollFrame;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;

public class FrameResizeControl
extends AbstractResizeHotSpot {
    protected ScrollFrame frame;

    public FrameResizeControl(ScrollFrame scrollFrame) {
        this.frame = scrollFrame;
    }

    @Override
    protected void beginDrag(Point point) {
        super.beginDrag(point);
    }

    @Override
    protected void endDrag() {
        super.endDrag();
    }

    @Override
    protected Dimension getSize() {
        return this.frame.getCurrentSize();
    }

    @Override
    protected void setSize(Dimension dimension) {
        this.frame.setSize(Size.fromPixels(dimension.width, dimension.height));
    }

    @Override
    protected Point getScreenPoint() {
        Point2D point2D = this.frame.getScreenPoint();
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    @Override
    protected void setScreenPoint(Point point) {
        this.frame.setScreenLocation(new Offset(point.getX(), point.getY(), "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.InsetPixels"));
    }

    @Override
    protected Dimension getMinimumSize() {
        return this.frame.getMinimumSize();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent == null || mouseWheelEvent.isConsumed()) {
            return;
        }
        this.frame.mouseWheelMoved(mouseWheelEvent);
    }
}

