/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.xml;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.BooleanIntegerXMLEventParser;
import gov.nasa.worldwind.util.xml.BooleanXMLEventParser;
import gov.nasa.worldwind.util.xml.DoubleXMLEventParser;
import gov.nasa.worldwind.util.xml.IntegerXMLEventParser;
import gov.nasa.worldwind.util.xml.StringXMLEventParser;
import gov.nasa.worldwind.util.xml.UnrecognizedXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import gov.nasa.worldwind.util.xml.XMLParserNotification;
import gov.nasa.worldwind.util.xml.XMLParserNotificationListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class BasicXMLEventParserContext
extends AVListImpl
implements XMLEventParserContext {
    public static QName DOUBLE = new QName("Double");
    public static QName INTEGER = new QName("Integer");
    public static QName STRING = new QName("String");
    public static QName BOOLEAN = new QName("Boolean");
    public static QName BOOLEAN_INTEGER = new QName("BooleanInteger");
    public static QName UNRECOGNIZED = new QName("gov.nasa.worldwind.util.xml.UnknownElementParser");
    protected XMLEventReader reader;
    protected StringXMLEventParser stringParser;
    protected DoubleXMLEventParser doubleParser;
    protected IntegerXMLEventParser integerParser;
    protected BooleanXMLEventParser booleanParser;
    protected BooleanIntegerXMLEventParser booleanIntegerParser;
    protected String defaultNamespaceURI = "";
    protected XMLParserNotificationListener notificationListener;
    protected ConcurrentHashMap<String, Object> idTable = new ConcurrentHashMap();
    protected ConcurrentHashMap<QName, XMLEventParser> parsers = new ConcurrentHashMap();

    public BasicXMLEventParserContext() {
        this.initializeParsers();
        this.initialize();
    }

    public BasicXMLEventParserContext(XMLEventReader xMLEventReader) {
        this.reader = xMLEventReader;
        this.initializeParsers();
        this.initialize();
    }

    public BasicXMLEventParserContext(XMLEventReader xMLEventReader, String string) {
        this.reader = xMLEventReader;
        this.setDefaultNamespaceURI(string);
        this.initializeParsers();
        this.initialize();
    }

    public BasicXMLEventParserContext(BasicXMLEventParserContext basicXMLEventParserContext) {
        this.parsers = basicXMLEventParserContext.parsers;
        this.setDefaultNamespaceURI(basicXMLEventParserContext.getDefaultNamespaceURI());
        this.initialize();
    }

    protected void initialize() {
        this.initializeDefaultNotificationListener();
    }

    protected void initializeDefaultNotificationListener() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                XMLParserNotification xMLParserNotification = (XMLParserNotification)propertyChangeEvent;
                if (BasicXMLEventParserContext.this.notificationListener != null) {
                    BasicXMLEventParserContext.this.notificationListener.notify(xMLParserNotification);
                    return;
                }
                String string = xMLParserNotification.getEvent() != null ? Logging.getMessage(xMLParserNotification.getMessage(), xMLParserNotification.getEvent().toString(), xMLParserNotification.getEvent().getLocation().getLineNumber(), xMLParserNotification.getEvent().getLocation().getColumnNumber(), xMLParserNotification.getEvent().getLocation().getCharacterOffset()) : Logging.getMessage(xMLParserNotification.getMessage(), "", "");
                if (xMLParserNotification.getPropertyName().equals("gov.nasa.worldwind.util.xml.XMLParserNotification.Exception")) {
                    Logging.logger().log(Level.WARNING, string);
                } else if (xMLParserNotification.getPropertyName().equals("gov.nasa.worldwind.util.xml.XMLParserNotification.Unrecognized")) {
                    Logging.logger().log(Level.WARNING, string);
                }
            }
        });
    }

    protected void initializeParsers() {
        this.parsers.put(STRING, new StringXMLEventParser());
        this.parsers.put(DOUBLE, new DoubleXMLEventParser());
        this.parsers.put(INTEGER, new IntegerXMLEventParser());
        this.parsers.put(BOOLEAN, new BooleanXMLEventParser());
        this.parsers.put(BOOLEAN_INTEGER, new BooleanIntegerXMLEventParser());
        this.parsers.put(UNRECOGNIZED, new UnrecognizedXMLEventParser(null));
    }

    protected void addStringParsers(String string, String[] stringArray) {
        StringXMLEventParser stringXMLEventParser = this.getStringParser();
        for (String string2 : stringArray) {
            this.parsers.put(new QName(string, string2), stringXMLEventParser);
        }
    }

    protected void addDoubleParsers(String string, String[] stringArray) {
        DoubleXMLEventParser doubleXMLEventParser = this.getDoubleParser();
        for (String string2 : stringArray) {
            this.parsers.put(new QName(string, string2), doubleXMLEventParser);
        }
    }

    protected void addIntegerParsers(String string, String[] stringArray) {
        IntegerXMLEventParser integerXMLEventParser = this.getIntegerParser();
        for (String string2 : stringArray) {
            this.parsers.put(new QName(string, string2), integerXMLEventParser);
        }
    }

    protected void addBooleanParsers(String string, String[] stringArray) {
        BooleanXMLEventParser booleanXMLEventParser = this.getBooleanParser();
        for (String string2 : stringArray) {
            this.parsers.put(new QName(string, string2), booleanXMLEventParser);
        }
    }

    protected void addBooleanIntegerParsers(String string, String[] stringArray) {
        BooleanIntegerXMLEventParser booleanIntegerXMLEventParser = this.getBooleanIntegerParser();
        for (String string2 : stringArray) {
            this.parsers.put(new QName(string, string2), booleanIntegerXMLEventParser);
        }
    }

    @Override
    public XMLEventReader getEventReader() {
        return this.reader;
    }

    public void setEventReader(XMLEventReader xMLEventReader) {
        if (xMLEventReader == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.reader = xMLEventReader;
    }

    @Override
    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }

    @Override
    public void setDefaultNamespaceURI(String string) {
        this.defaultNamespaceURI = string;
    }

    @Override
    public void setNotificationListener(XMLParserNotificationListener xMLParserNotificationListener) {
        this.notificationListener = xMLParserNotificationListener;
    }

    @Override
    public Map<String, Object> getIdTable() {
        return this.idTable;
    }

    @Override
    public void addId(String string, Object object) {
        if (string != null) {
            this.getIdTable().put(string, object);
        }
    }

    @Override
    public boolean hasNext() {
        return this.getEventReader().hasNext();
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent xMLEvent = this.getEventReader().nextEvent();
            if (xMLEvent.isCharacters() && xMLEvent.asCharacters().isWhiteSpace()) continue;
            return xMLEvent;
        }
        return null;
    }

    @Override
    public XMLEventParser allocate(XMLEvent xMLEvent, XMLEventParser xMLEventParser) {
        return this.getParser(xMLEvent, xMLEventParser);
    }

    @Override
    public XMLEventParser allocate(XMLEvent xMLEvent) {
        return this.getParser(xMLEvent, null);
    }

    @Override
    public XMLEventParser getParser(XMLEvent xMLEvent) {
        return this.getParser(xMLEvent, null);
    }

    protected XMLEventParser getParser(XMLEvent xMLEvent, XMLEventParser xMLEventParser) {
        if (xMLEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        QName qName = xMLEvent.asStartElement().getName();
        if (qName == null) {
            return null;
        }
        XMLEventParser xMLEventParser2 = this.getParser(qName);
        return xMLEventParser2 != null ? xMLEventParser2 : xMLEventParser;
    }

    @Override
    public StringXMLEventParser getStringParser() {
        if (this.stringParser == null) {
            this.stringParser = (StringXMLEventParser)this.getParser(STRING);
        }
        return this.stringParser;
    }

    @Override
    public DoubleXMLEventParser getDoubleParser() {
        if (this.doubleParser == null) {
            this.doubleParser = (DoubleXMLEventParser)this.getParser(DOUBLE);
        }
        return this.doubleParser;
    }

    @Override
    public IntegerXMLEventParser getIntegerParser() {
        if (this.integerParser == null) {
            this.integerParser = (IntegerXMLEventParser)this.getParser(INTEGER);
        }
        return this.integerParser;
    }

    @Override
    public BooleanXMLEventParser getBooleanParser() {
        if (this.booleanParser == null) {
            this.booleanParser = (BooleanXMLEventParser)this.getParser(BOOLEAN);
        }
        return this.booleanParser;
    }

    @Override
    public BooleanIntegerXMLEventParser getBooleanIntegerParser() {
        if (this.booleanIntegerParser == null) {
            this.booleanIntegerParser = (BooleanIntegerXMLEventParser)this.getParser(BOOLEAN_INTEGER);
        }
        return this.booleanIntegerParser;
    }

    @Override
    public XMLEventParser getUnrecognizedElementParser() {
        return this.getParser(UNRECOGNIZED);
    }

    @Override
    public String getCharacters(XMLEvent xMLEvent) {
        if (xMLEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return xMLEvent.isCharacters() ? xMLEvent.asCharacters().getData() : null;
    }

    @Override
    public boolean isSameName(QName qName, QName qName2) {
        if (qName.equals(qName2)) {
            return true;
        }
        if (!qName.getLocalPart().equals(qName2.getLocalPart())) {
            return false;
        }
        if (qName.getNamespaceURI().equals("")) {
            return qName2.getNamespaceURI().equals(this.getDefaultNamespaceURI());
        }
        if (qName2.getNamespaceURI().equals("")) {
            return qName.getNamespaceURI().equals(this.getDefaultNamespaceURI());
        }
        return false;
    }

    @Override
    public boolean isSameAttributeName(QName qName, QName qName2) {
        return qName != null && qName2 != null && qName.getLocalPart() != null && qName.getLocalPart().equals(qName2.getLocalPart());
    }

    @Override
    public boolean isStartElement(XMLEvent xMLEvent, QName qName) {
        if (xMLEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (qName == null) {
            String string = Logging.getMessage("nullValue.ElementNameIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return xMLEvent.isStartElement() && this.isSameName(xMLEvent.asStartElement().getName(), qName);
    }

    @Override
    public boolean isEndElement(XMLEvent xMLEvent, XMLEvent xMLEvent2) {
        if (xMLEvent == null || xMLEvent2 == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return BasicXMLEventParserContext.isEndElementEvent(xMLEvent, xMLEvent2);
    }

    public static boolean isEndElementEvent(XMLEvent xMLEvent, XMLEvent xMLEvent2) {
        if (xMLEvent == null || xMLEvent2 == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return xMLEvent.isEndElement() && xMLEvent.asEndElement().getName().equals(xMLEvent2.asStartElement().getName());
    }

    @Override
    public void registerParser(QName qName, XMLEventParser xMLEventParser) {
        if (xMLEventParser == null) {
            String string = Logging.getMessage("nullValue.ParserIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (qName == null) {
            String string = Logging.getMessage("nullValue.ElementNameIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.parsers.put(qName, xMLEventParser);
    }

    @Override
    public XMLEventParser getParser(QName qName) {
        if (qName == null) {
            String string = Logging.getMessage("nullValue.ElementNameIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XMLEventParser xMLEventParser = this.parsers.get(qName);
        if (xMLEventParser == null) {
            QName qName2;
            if (BasicXMLEventParserContext.isNullNamespace(qName.getNamespaceURI())) {
                qName2 = new QName(this.getDefaultNamespaceURI(), qName.getLocalPart());
                xMLEventParser = this.parsers.get(qName2);
            } else if (this.isDefaultNamespace(qName.getNamespaceURI())) {
                qName2 = new QName(qName.getLocalPart());
                xMLEventParser = this.parsers.get(qName2);
            }
        }
        try {
            if (xMLEventParser == null) {
                return null;
            }
            return xMLEventParser.newInstance();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("XML.ParserCreationException", qName);
            Logging.logger().log(Level.WARNING, string, exception);
            return null;
        }
    }

    protected static boolean isNullNamespace(String string) {
        return string == null || "".equals(string);
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return this.getDefaultNamespaceURI() != null && this.getDefaultNamespaceURI().equals(string);
    }

    @Override
    @Deprecated
    public void resolveInternalReferences(String string, String string2, AbstractXMLEventParser abstractXMLEventParser) {
        if (abstractXMLEventParser == null || !abstractXMLEventParser.hasFields()) {
            return;
        }
        HashMap<String, Object> hashMap = null;
        for (Map.Entry<String, Object> entry : abstractXMLEventParser.getFields().getEntries()) {
            String string3;
            Object object;
            String string4 = entry.getKey();
            if (string4 == null || string4.equals("id") || (object = entry.getValue()) == null || !(object instanceof String) || !(string3 = (String)object).startsWith("#") || !string4.endsWith(string)) continue;
            Object object2 = this.getIdTable().get(string3.substring(1, string3.length()));
            if (abstractXMLEventParser.hasField(string2)) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            hashMap.put(string2, object2);
        }
        if (hashMap != null) {
            abstractXMLEventParser.setFields(hashMap);
        }
    }
}

