/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.firstperson;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.view.BasicViewPropertyLimits;

public class FlyViewLimits
extends BasicViewPropertyLimits {
    public double limitEyeElevation(Position position, Globe globe) {
        double d = position.getElevation();
        double d2 = globe.getElevation(position.getLatitude(), position.getLongitude());
        double[] dArray = this.getEyeElevationLimits();
        if (position.getElevation() < dArray[0] + d2) {
            d = dArray[0] + d2;
        } else if (position.getElevation() > dArray[1] + d2) {
            d = dArray[1] + d2;
        }
        return d;
    }

    public double limitEyeElevation(double d) {
        double[] dArray = this.getEyeElevationLimits();
        if (d < dArray[0]) {
            return dArray[0];
        }
        if (d > dArray[1]) {
            return dArray[1];
        }
        return d;
    }
}

