/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.orbit.BasicOrbitView;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwind.view.orbit.OrbitViewInputSupport;
import java.awt.Rectangle;

public class OrbitViewCollisionSupport {
    private double collisionThreshold;
    private int numIterations;

    public OrbitViewCollisionSupport() {
        this.setNumIterations(1);
    }

    public double getCollisionThreshold() {
        return this.collisionThreshold;
    }

    public void setCollisionThreshold(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.collisionThreshold = d;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.numIterations = n;
    }

    public boolean isColliding(OrbitView orbitView, double d, DrawContext drawContext) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.OrbitViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Globe globe = drawContext.getGlobe();
        if (globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = this.getModelviewInverse(globe, orbitView.getCenterPosition(), orbitView.getHeading(), orbitView.getPitch(), orbitView.getRoll(), orbitView.getZoom());
        if (matrix != null) {
            double d2 = this.computeViewHeightAboveSurface(drawContext, matrix, orbitView.getFieldOfView(), orbitView.getViewport(), d);
            return d2 < this.collisionThreshold;
        }
        return false;
    }

    public Position computeCenterPositionToResolveCollision(BasicOrbitView basicOrbitView, double d, DrawContext drawContext) {
        if (basicOrbitView == null) {
            String string = Logging.getMessage("nullValue.OrbitViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Globe globe = drawContext.getGlobe();
        if (globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = null;
        for (int i = 0; i < this.numIterations; ++i) {
            double d2;
            double d3;
            Matrix matrix = this.getModelviewInverse(globe, position != null ? position : basicOrbitView.getCenterPosition(), basicOrbitView.getHeading(), basicOrbitView.getPitch(), basicOrbitView.getRoll(), basicOrbitView.getZoom());
            if (matrix == null || !((d3 = (d2 = this.computeViewHeightAboveSurface(drawContext, matrix, basicOrbitView.getFieldOfView(), basicOrbitView.getViewport(), d)) - this.collisionThreshold) < 0.0)) continue;
            position = new Position(position != null ? position : basicOrbitView.getCenterPosition(), (position != null ? position.getElevation() : basicOrbitView.getCenterPosition().getElevation()) - d3);
        }
        return position;
    }

    public Angle computePitchToResolveCollision(BasicOrbitView basicOrbitView, double d, DrawContext drawContext) {
        if (basicOrbitView == null) {
            String string = Logging.getMessage("nullValue.OrbitViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Globe globe = drawContext.getGlobe();
        if (globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = null;
        for (int i = 0; i < this.numIterations; ++i) {
            Vec4 vec4;
            double d2;
            double d3;
            Matrix matrix = this.getModelviewInverse(globe, basicOrbitView.getCenterPosition(), basicOrbitView.getHeading(), angle != null ? angle : basicOrbitView.getPitch(), basicOrbitView.getRoll(), basicOrbitView.getZoom());
            if (matrix == null || !((d3 = (d2 = this.computeViewHeightAboveSurface(drawContext, matrix, basicOrbitView.getFieldOfView(), basicOrbitView.getViewport(), d)) - this.collisionThreshold) < 0.0)) continue;
            Vec4 vec42 = this.getEyePoint(matrix);
            Vec4 vec43 = globe.computePointFromPosition(basicOrbitView.getCenterPosition());
            if (vec42 == null || vec43 == null) continue;
            Position position = globe.computePositionFromPoint(vec42);
            Vec4 vec44 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), position.getElevation() - d3);
            Vec4 vec45 = globe.computeSurfaceNormalAtPoint(vec43);
            double d4 = vec45.dot3(vec4 = vec44.subtract3(vec43).normalize3());
            if (!(d4 >= -1.0) && !(d4 <= 1.0)) continue;
            double d5 = Math.acos(d4);
            angle = Angle.fromRadians(d5);
        }
        return angle;
    }

    private double computeViewHeightAboveSurface(DrawContext drawContext, Matrix matrix, Angle angle, Rectangle rectangle, double d) {
        double d2 = Double.POSITIVE_INFINITY;
        if (drawContext != null && matrix != null && angle != null && rectangle != null && d >= 0.0) {
            double d3;
            Vec4 vec4;
            double d4;
            Vec4 vec42 = this.getEyePoint(matrix);
            if (vec42 != null && (d4 = this.computePointHeightAboveSurface(drawContext, vec42)) < d2) {
                d2 = d4;
            }
            if ((vec4 = this.getPointOnNearPlane(matrix, angle, rectangle, d)) != null && (d3 = this.computePointHeightAboveSurface(drawContext, vec4)) < d2) {
                d2 = d3;
            }
        }
        return d2;
    }

    private double computePointHeightAboveSurface(DrawContext drawContext, Vec4 vec4) {
        double d = Double.POSITIVE_INFINITY;
        if (drawContext != null && drawContext.getGlobe() != null && vec4 != null) {
            Globe globe = drawContext.getGlobe();
            Position position = globe.computePositionFromPoint(vec4);
            Position position2 = null;
            Vec4 vec42 = drawContext.getPointOnTerrain(position.getLatitude(), position.getLongitude());
            if (vec42 != null) {
                position2 = globe.computePositionFromPoint(vec42);
            }
            if (position2 == null) {
                position2 = new Position(position, globe.getElevation(position.getLatitude(), position.getLongitude()) * drawContext.getVerticalExaggeration());
            }
            d = position.getElevation() - position2.getElevation();
        }
        return d;
    }

    private Matrix getModelviewInverse(Globe globe, Position position, Angle angle, Angle angle2, Angle angle3, double d) {
        Matrix matrix;
        if (globe != null && position != null && angle != null && angle2 != null && (matrix = OrbitViewInputSupport.computeTransformMatrix(globe, position, angle, angle2, angle3, d)) != null) {
            return matrix.getInverse();
        }
        return null;
    }

    private Vec4 getEyePoint(Matrix matrix) {
        return matrix != null ? Vec4.UNIT_W.transformBy4(matrix) : null;
    }

    private Vec4 getPointOnNearPlane(Matrix matrix, Angle angle, Rectangle rectangle, double d) {
        if (matrix != null && angle != null && rectangle != null && d >= 0.0) {
            double d2 = rectangle.getWidth() <= 0.0 || rectangle.getHeight() <= 0.0 ? 1.0 : rectangle.getHeight() / rectangle.getWidth();
            double d3 = 2.0 * d2 * d * angle.tanHalfAngle();
            Vec4 vec4 = new Vec4(0.0, -d3 / 2.0, -d, 1.0);
            return vec4.transformBy4(matrix);
        }
        return null;
    }
}

