/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view.orbit;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.ViewUtil;

public class OrbitViewInputSupport {
    public static Matrix computeTransformMatrix(Globe globe, Position position, Angle angle, Angle angle2, Angle angle3, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = Logging.getMessage("nullValue.PitchIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = OrbitViewInputSupport.computeHeadingPitchRollZoomTransform(angle, angle2, angle3, d);
        matrix = matrix.multiply(OrbitViewInputSupport.computeCenterTransform(globe, position));
        return matrix;
    }

    public static OrbitViewState computeOrbitViewState(Globe globe, Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = "nullValue.EyePointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec42 == null) {
            String string = "nullValue.CenterPointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec43 == null) {
            String string = "nullValue.UpIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromViewLookAt(vec4, vec42, vec43);
        return OrbitViewInputSupport.computeOrbitViewState(globe, matrix, vec42);
    }

    public static OrbitViewState computeOrbitViewState(Globe globe, Matrix matrix, Vec4 vec4) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = "nullValue.ModelTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = "nullValue.CenterPointIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = globe.computePositionFromPoint(vec4);
        Matrix matrix2 = OrbitViewInputSupport.computeCenterTransform(globe, position);
        Matrix matrix3 = matrix2.getInverse();
        if (matrix3 == null) {
            String string = Logging.getMessage("generic.NoninvertibleMatrix");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Matrix matrix4 = matrix.multiply(matrix3);
        Angle angle = ViewUtil.computeHeading(matrix4);
        Angle angle2 = ViewUtil.computePitch(matrix4);
        double d = OrbitViewInputSupport.computeZoom(matrix4);
        if (angle == null || angle2 == null) {
            return null;
        }
        return new OrbitViewState(position, angle, angle2, d);
    }

    protected static Matrix computeCenterTransform(Globe globe, Position position) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = globe.computePointFromPosition(position);
        Vec4 vec42 = globe.computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude());
        Vec4 vec43 = vec4.subtract3(vec42);
        Vec4 vec44 = globe.computeNorthPointingTangentAtLocation(position.getLatitude(), position.getLongitude());
        return Matrix.fromViewLookAt(vec4, vec43, vec44);
    }

    protected static Matrix computeHeadingPitchRollZoomTransform(Angle angle, Angle angle2, Angle angle3, double d) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle2 == null) {
            String string = Logging.getMessage("nullValue.PitchIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle3 == null) {
            String string = Logging.getMessage("nullValue.RollIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromTranslation(0.0, 0.0, -d);
        matrix = matrix.multiply(Matrix.fromRotationZ(angle3));
        matrix = matrix.multiply(Matrix.fromRotationX(angle2.multiply(-1.0)));
        matrix = matrix.multiply(Matrix.fromRotationZ(angle));
        return matrix;
    }

    protected static double computeZoom(Matrix matrix) {
        if (matrix == null) {
            String string = "nullValue.HeadingPitchZoomTransformTransformIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = matrix.getTranslation();
        return vec4 != null ? vec4.getLength3() : 0.0;
    }

    public static OrbitViewState getSurfaceIntersection(Globe globe, SectorGeometryList sectorGeometryList, Position position, Angle angle, Angle angle2, double d) {
        Vec4 vec4;
        Vec4 vec42;
        Vec4 vec43;
        Intersection[] intersectionArray;
        Matrix matrix;
        Matrix matrix2;
        if (globe != null && (matrix2 = OrbitViewInputSupport.computeTransformMatrix(globe, position, angle, angle2, Angle.ZERO, d)) != null && (matrix = matrix2.getInverse()) != null && (intersectionArray = sectorGeometryList.intersect(new Line(vec43 = Vec4.UNIT_W.transformBy4(matrix), (vec42 = vec43.subtract3(vec4 = globe.computePointFromPosition(position))).normalize3().multiply3(-1.0)))) != null && intersectionArray.length >= 0) {
            Position position2 = globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
            return new OrbitViewState(position2, angle, angle2, d);
        }
        return null;
    }

    public static class OrbitViewState {
        private final Position center;
        private final Angle heading;
        private final Angle pitch;
        private final double zoom;

        public OrbitViewState(Position position, Angle angle, Angle angle2, double d) {
            if (position == null) {
                String string = Logging.getMessage("nullValue.CenterIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (angle == null) {
                String string = Logging.getMessage("nullValue.HeadingIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (angle2 == null) {
                String string = Logging.getMessage("nullValue.PitchIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.center = position;
            this.heading = angle;
            this.pitch = angle2;
            this.zoom = d;
        }

        public Position getCenterPosition() {
            return this.center;
        }

        public Angle getHeading() {
            return this.heading;
        }

        public Angle getPitch() {
            return this.pitch;
        }

        public double getZoom() {
            return this.zoom;
        }
    }
}

