/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.ByteSourceBootstrapper;
import org.codehaus.jackson.impl.ReaderBasedParser;
import org.codehaus.jackson.impl.WriterBasedGenerator;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.UTF8Writer;
import org.codehaus.jackson.sym.BytesToNameCanonicalizer;
import org.codehaus.jackson.sym.CharsToNameCanonicalizer;
import org.codehaus.jackson.util.BufferRecycler;

public class JsonFactory {
    static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected CharsToNameCanonicalizer _rootCharSymbols = CharsToNameCanonicalizer.createRoot();
    protected BytesToNameCanonicalizer _rootByteSymbols = BytesToNameCanonicalizer.createRoot();
    protected ObjectCodec _objectCodec;
    protected int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    protected int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;

    public JsonFactory() {
        this(null);
    }

    public JsonFactory(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public final JsonFactory configure(JsonParser.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public JsonFactory enable(JsonParser.Feature feature) {
        this._parserFeatures |= feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonParser.Feature feature) {
        this._parserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonParser.Feature feature) {
        return (this._parserFeatures & feature.getMask()) != 0;
    }

    public final void enableParserFeature(JsonParser.Feature feature) {
        this.enable(feature);
    }

    public final void disableParserFeature(JsonParser.Feature feature) {
        this.disable(feature);
    }

    public final void setParserFeature(JsonParser.Feature feature, boolean bl) {
        this.configure(feature, bl);
    }

    public final boolean isParserFeatureEnabled(JsonParser.Feature feature) {
        return (this._parserFeatures & feature.getMask()) != 0;
    }

    public final JsonFactory configure(JsonGenerator.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public JsonFactory enable(JsonGenerator.Feature feature) {
        this._generatorFeatures |= feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonGenerator.Feature feature) {
        this._generatorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    public final void enableGeneratorFeature(JsonGenerator.Feature feature) {
        this.enable(feature);
    }

    public final void disableGeneratorFeature(JsonGenerator.Feature feature) {
        this.disable(feature);
    }

    public final void setGeneratorFeature(JsonGenerator.Feature feature, boolean bl) {
        this.configure(feature, bl);
    }

    public final boolean isGeneratorFeatureEnabled(JsonGenerator.Feature feature) {
        return this.isEnabled(feature);
    }

    public JsonFactory setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public JsonParser createJsonParser(File file) throws IOException, JsonParseException {
        return this._createJsonParser(new FileInputStream(file), this._createContext(file, true));
    }

    public JsonParser createJsonParser(URL uRL) throws IOException, JsonParseException {
        return this._createJsonParser(this._optimizedStreamFromURL(uRL), this._createContext(uRL, true));
    }

    public JsonParser createJsonParser(InputStream inputStream) throws IOException, JsonParseException {
        return this._createJsonParser(inputStream, this._createContext(inputStream, false));
    }

    public JsonParser createJsonParser(Reader reader) throws IOException, JsonParseException {
        return this._createJsonParser(reader, this._createContext(reader, false));
    }

    public JsonParser createJsonParser(byte[] byArray) throws IOException, JsonParseException {
        return this._createJsonParser(byArray, 0, byArray.length, this._createContext(byArray, true));
    }

    public JsonParser createJsonParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        return this._createJsonParser(byArray, n, n2, this._createContext(byArray, true));
    }

    public JsonParser createJsonParser(String string) throws IOException, JsonParseException {
        StringReader stringReader = new StringReader(string);
        return this._createJsonParser(stringReader, this._createContext(stringReader, true));
    }

    public JsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        iOContext.setEncoding(jsonEncoding);
        return this._createJsonGenerator(this._createWriter(outputStream, jsonEncoding, iOContext), iOContext);
    }

    public JsonGenerator createJsonGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(writer, false);
        return this._createJsonGenerator(writer, iOContext);
    }

    public JsonGenerator createJsonGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOContext iOContext = this._createContext(fileOutputStream, true);
        iOContext.setEncoding(jsonEncoding);
        return this._createJsonGenerator(this._createWriter(fileOutputStream, jsonEncoding, iOContext), iOContext);
    }

    protected IOContext _createContext(Object object, boolean bl) {
        return new IOContext(this._getBufferRecycler(), object, bl);
    }

    protected JsonParser _createJsonParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        return new ByteSourceBootstrapper(iOContext, inputStream).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols);
    }

    protected JsonParser _createJsonParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        return new ReaderBasedParser(iOContext, this._parserFeatures, reader, this._objectCodec, this._rootCharSymbols.makeChild(this.isEnabled(JsonParser.Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonParser.Feature.INTERN_FIELD_NAMES)));
    }

    protected JsonParser _createJsonParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        return new ByteSourceBootstrapper(iOContext, byArray, n, n2).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols);
    }

    protected JsonGenerator _createJsonGenerator(Writer writer, IOContext iOContext) throws IOException {
        return new WriterBasedGenerator(iOContext, this._generatorFeatures, this._objectCodec, writer);
    }

    public BufferRecycler _getBufferRecycler() {
        BufferRecycler bufferRecycler;
        SoftReference<BufferRecycler> softReference = _recyclerRef.get();
        BufferRecycler bufferRecycler2 = bufferRecycler = softReference == null ? null : softReference.get();
        if (bufferRecycler == null) {
            bufferRecycler = new BufferRecycler();
            if (softReference == null) {
                _recyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
            }
        }
        return bufferRecycler;
    }

    protected InputStream _optimizedStreamFromURL(URL uRL) throws IOException {
        String string;
        if ("file".equals(uRL.getProtocol()) && ((string = uRL.getHost()) == null || string.length() == 0)) {
            return new FileInputStream(uRL.getPath());
        }
        return uRL.openStream();
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(iOContext, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }
}

