/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.Reader;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.ReaderBasedNumericParser;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.sym.CharsToNameCanonicalizer;
import org.codehaus.jackson.util.ByteArrayBuilder;
import org.codehaus.jackson.util.CharTypes;
import org.codehaus.jackson.util.TextBuffer;

public final class ReaderBasedParser
extends ReaderBasedNumericParser {
    protected ObjectCodec _objectCodec;
    protected final CharsToNameCanonicalizer _symbols;

    public ReaderBasedParser(IOContext iOContext, int n, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer) {
        super(iOContext, n, reader);
        this._objectCodec = objectCodec;
        this._symbols = charsToNameCanonicalizer;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        Object object;
        boolean bl;
        int n;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n != 44) {
                this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n = this._skipWS();
        }
        if (bl = this._parsingContext.inObject()) {
            object = this._parseFieldName(n);
            this._parsingContext.setCurrentName((String)object);
            this._currToken = JsonToken.FIELD_NAME;
            n = this._skipWS();
            if (n != 58) {
                this._reportUnexpectedChar(n, "was expecting a colon to separate field name and value");
            }
            n = this._skipWS();
        }
        switch (n) {
            case 34: {
                this._tokenIncomplete = true;
                object = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchToken(JsonToken.VALUE_TRUE);
                object = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken(JsonToken.VALUE_FALSE);
                object = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken(JsonToken.VALUE_NULL);
                object = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                object = this.parseNumberText(n);
                break;
            }
            default: {
                object = this._handleUnexpectedValue(n);
            }
        }
        if (bl) {
            this._nextToken = object;
            return this._currToken;
        }
        this._currToken = object;
        return object;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    protected final String _parseFieldName(int n) throws IOException, JsonParseException {
        if (n != 34) {
            return this._handleUnusualFieldName(n);
        }
        int n2 = this._inputPtr;
        int n3 = 0;
        int n4 = this._inputEnd;
        if (n2 < n4) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n5 = nArray.length;
            do {
                char c;
                if ((c = this._inputBuffer[n2]) < n5 && nArray[c] != 0) {
                    if (c != '\"') break;
                    int n6 = this._inputPtr;
                    this._inputPtr = n2 + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n6, n2 - n6, n3);
                }
                n3 = n3 * 31 + c;
            } while (++n2 < n4);
        }
        int n7 = this._inputPtr;
        this._inputPtr = n2;
        return this._parseFieldName2(n7, n3, 34);
    }

    private String _parseFieldName2(int n, int n2, int n3) throws IOException, JsonParseException {
        this._textBuffer.resetWithShared(this._inputBuffer, n, this._inputPtr - n);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n4 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing '" + (char)n3 + "' for name");
            }
            if ((c2 = (c = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c2 == '\\') {
                    c = this._decodeEscaped();
                } else if (c2 <= n3) {
                    if (c2 == n3) break;
                    if (c2 < ' ') {
                        this._throwUnquotedSpace(c2, "name");
                    }
                }
            }
            n2 = n2 * 31 + c2;
            cArray[n4++] = c;
            if (n4 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n4 = 0;
        }
        this._textBuffer.setCurrentLength(n4);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n5 = textBuffer.getTextOffset();
        int n6 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n5, n6, n2);
    }

    protected final String _handleUnusualFieldName(int n) throws IOException, JsonParseException {
        int n2;
        int[] nArray;
        int n3;
        boolean bl;
        if (n == 39 && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseApostropheFieldName();
        }
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            this._reportUnexpectedChar(n, "was expecting double-quote to start field name");
        }
        if (!(bl = n < (n3 = (nArray = CharTypes.getInputCodeLatin1JsNames()).length) ? nArray[n] == 0 && (n < 48 || n > 57) : Character.isJavaIdentifierPart((char)n))) {
            this._reportUnexpectedChar(n, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int n4 = this._inputPtr;
        int n5 = 0;
        int n6 = this._inputEnd;
        if (n4 < n6) {
            do {
                if ((n2 = this._inputBuffer[n4]) < n3) {
                    if (nArray[n2] != 0) {
                        int n7 = this._inputPtr - 1;
                        this._inputPtr = n4;
                        return this._symbols.findSymbol(this._inputBuffer, n7, n4 - n7, n5);
                    }
                } else if (!Character.isJavaIdentifierPart((char)n2)) {
                    int n8 = this._inputPtr - 1;
                    this._inputPtr = n4;
                    return this._symbols.findSymbol(this._inputBuffer, n8, n4 - n8, n5);
                }
                n5 = n5 * 31 + n2;
            } while (++n4 < n6);
        }
        n2 = this._inputPtr - 1;
        this._inputPtr = n4;
        return this._parseUnusualFieldName2(n2, n5, nArray);
    }

    protected final String _parseApostropheFieldName() throws IOException, JsonParseException {
        int n = this._inputPtr;
        int n2 = 0;
        int n3 = this._inputEnd;
        if (n < n3) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n4 = nArray.length;
            do {
                char c;
                if ((c = this._inputBuffer[n]) == '\'') {
                    int n5 = this._inputPtr;
                    this._inputPtr = n + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n5, n - n5, n2);
                }
                if (c < n4 && nArray[c] != 0) break;
                n2 = n2 * 31 + c;
            } while (++n < n3);
        }
        int n6 = this._inputPtr;
        this._inputPtr = n;
        return this._parseFieldName2(n6, n2, 39);
    }

    protected final JsonToken _handleUnexpectedValue(int n) throws IOException, JsonParseException {
        if (n != 39 || !this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            this._reportUnexpectedChar(n, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            int n3;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            if ((n = (n3 = this._inputBuffer[this._inputPtr++])) <= 92) {
                if (n == 92) {
                    n3 = this._decodeEscaped();
                } else if (n <= 39) {
                    if (n == 39) break;
                    if (n < 32) {
                        this._throwUnquotedSpace(n, "string value");
                    }
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = n3;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    private String _parseUnusualFieldName2(int n, int n2, int[] nArray) throws IOException, JsonParseException {
        char c;
        char c2;
        this._textBuffer.resetWithShared(this._inputBuffer, n, this._inputPtr - n);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n3 = this._textBuffer.getCurrentSegmentSize();
        int n4 = nArray.length;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && !((c2 = (c = this._inputBuffer[this._inputPtr])) <= n4 ? nArray[c2] != 0 : !Character.isJavaIdentifierPart(c))) {
            ++this._inputPtr;
            n2 = n2 * 31 + c2;
            cArray[n3++] = c;
            if (n3 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n3 = 0;
        }
        this._textBuffer.setCurrentLength(n3);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n5 = textBuffer.getTextOffset();
        int n6 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n5, n6, n2);
    }

    @Override
    protected void _finishString() throws IOException, JsonParseException {
        int n = this._inputPtr;
        int n2 = this._inputEnd;
        if (n < n2) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n3 = nArray.length;
            do {
                char c;
                if ((c = this._inputBuffer[n]) >= n3 || nArray[c] == 0) continue;
                if (c != '\"') break;
                this._textBuffer.resetWithShared(this._inputBuffer, this._inputPtr, n - this._inputPtr);
                this._inputPtr = n + 1;
                return;
            } while (++n < n2);
        }
        this._textBuffer.resetWithCopy(this._inputBuffer, this._inputPtr, n - this._inputPtr);
        this._inputPtr = n;
        this._finishString2();
    }

    protected void _finishString2() throws IOException, JsonParseException {
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c;
            char c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            if ((c2 = (c = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c2 == '\\') {
                    c = this._decodeEscaped();
                } else if (c2 <= '\"') {
                    if (c2 == '\"') break;
                    if (c2 < ' ') {
                        this._throwUnquotedSpace(c2, "string value");
                    }
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = c;
        }
        this._textBuffer.setCurrentLength(n);
    }

    protected void _skipString() throws IOException, JsonParseException {
        this._tokenIncomplete = false;
        int n = this._inputPtr;
        int n2 = this._inputEnd;
        char[] cArray = this._inputBuffer;
        while (true) {
            char c;
            char c2;
            if (n >= n2) {
                this._inputPtr = n;
                if (!this.loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value");
                }
                n = this._inputPtr;
                n2 = this._inputEnd;
            }
            if ((c2 = (c = cArray[n++])) > '\\') continue;
            if (c2 == '\\') {
                this._inputPtr = n;
                c = this._decodeEscaped();
                n = this._inputPtr;
                n2 = this._inputEnd;
                continue;
            }
            if (c2 > '\"') continue;
            if (c2 == '\"') break;
            if (c2 >= ' ') continue;
            this._inputPtr = n;
            this._throwUnquotedSpace(c2, "string value");
        }
        this._inputPtr = n;
    }

    protected void _matchToken(JsonToken jsonToken) throws IOException, JsonParseException {
        String string = jsonToken.asString();
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            char c;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in a value");
            }
            if ((c = this._inputBuffer[this._inputPtr]) != string.charAt(i)) {
                this._reportInvalidToken(string.substring(0, i));
            }
            ++this._inputPtr;
        }
    }

    private void _reportInvalidToken(String string) throws IOException, JsonParseException {
        char c;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && Character.isJavaIdentifierPart(c = this._inputBuffer[this._inputPtr])) {
            ++this._inputPtr;
            stringBuilder.append(c);
        }
        this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting 'null', 'true' or 'false'");
    }

    protected final void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected final void _skipLF() throws IOException {
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private final int _skipWS() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c != '/') {
                    return c;
                }
                this._skipComment();
                continue;
            }
            if (c == ' ') continue;
            if (c == '\n') {
                this._skipLF();
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private final int _skipWSOrEnd() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c != '/') {
                    return c;
                }
                this._skipComment();
                continue;
            }
            if (c == ' ') continue;
            if (c == '\n') {
                this._skipLF();
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        this._handleEOF();
        return -1;
    }

    private final void _skipComment() throws IOException, JsonParseException {
        char c;
        if (!this.isEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '/') {
            this._skipCppComment();
        } else if (c == '*') {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(c, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) > '*') continue;
            if (c == '*') {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) break;
                if (this._inputBuffer[this._inputPtr] != '/') continue;
                ++this._inputPtr;
                return;
            }
            if (c >= ' ') continue;
            if (c == '\n') {
                this._skipLF();
                continue;
            }
            if (c == '\r') {
                this._skipCR();
                continue;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
        this._reportInvalidEOF(" in a comment");
    }

    private final void _skipCppComment() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c;
            if ((c = this._inputBuffer[this._inputPtr++]) >= ' ') continue;
            if (c == '\n') {
                this._skipLF();
                break;
            }
            if (c == '\r') {
                this._skipCR();
                break;
            }
            if (c == '\t') continue;
            this._throwInvalidSpace(c);
        }
    }

    protected final char _decodeEscaped() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        char c = this._inputBuffer[this._inputPtr++];
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '/': 
            case '\\': {
                return c;
            }
            case 'u': {
                break;
            }
            default: {
                this._reportError("Unrecognized character escape " + ReaderBasedParser._getCharDesc(c));
            }
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            char c2;
            int n2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            if ((n2 = CharTypes.charToHex(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(c2, "expected a hex-digit for character escape sequence");
            }
            n = n << 4 | n2;
        }
        return (char)n;
    }

    @Override
    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException, JsonParseException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n = base64Variant.decodeBase64Char(c);
            if (n < 0) {
                if (c == '\"') {
                    return byteArrayBuilder.toByteArray();
                }
                throw this.reportInvalidChar(base64Variant, c, 0);
            }
            int n2 = n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                throw this.reportInvalidChar(base64Variant, c, 1);
            }
            n2 = n2 << 6 | n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n != -2) {
                    throw this.reportInvalidChar(base64Variant, c, 2);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (!base64Variant.usesPaddingChar(c = this._inputBuffer[this._inputPtr++])) {
                    throw this.reportInvalidChar(base64Variant, c, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n2 >>= 4);
                continue;
            }
            n2 = n2 << 6 | n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n != -2) {
                    throw this.reportInvalidChar(base64Variant, c, 3);
                }
                byteArrayBuilder.appendTwoBytes(n2 >>= 2);
                continue;
            }
            n2 = n2 << 6 | n;
            byteArrayBuilder.appendThreeBytes(n2);
        }
    }

    protected IllegalArgumentException reportInvalidChar(Base64Variant base64Variant, char c, int n) throws IllegalArgumentException {
        return this.reportInvalidChar(base64Variant, c, n, null);
    }

    protected IllegalArgumentException reportInvalidChar(Base64Variant base64Variant, char c, int n, String string) throws IllegalArgumentException {
        String string2 = c <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c) + ") as character #" + (n + 1) + " of 4-char base64 unit: can only used between units" : (base64Variant.usesPaddingChar(c) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c) || Character.isISOControl(c) ? "Illegal character (code 0x" + Integer.toHexString(c) + ") in base64 content" : "Illegal character '" + c + "' (code 0x" + Integer.toHexString(c) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        return new IllegalArgumentException(string2);
    }
}

