/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.antenna;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Sphere;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import javax.media.opengl.GL2;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class AntennaAxes
extends AbstractShape {
    public static final int DISPLAY_MODE_FILL = 6914;
    public static final int DISPLAY_MODE_LINE = 6913;
    protected int nHeightIntervals = 10;
    protected int nThetaIntervals = 20;
    protected Position position = Position.ZERO;
    protected Angle azimuth;
    protected Angle elevationAngle;
    protected double length = 1000.0;
    protected double radius = 0.05 * this.length;
    protected Font labelFont = Font.decode("Arial-PLAIN-14");
    protected String xAxisLabel = "Body X";
    protected String yAxisLabel = "Body Y";
    protected String zAxisLabel = "Bore Sight";

    protected AbstractShape.AbstractShapeData createCacheEntry(DrawContext drawContext) {
        return new ShapeData(drawContext, this);
    }

    protected ShapeData getCurrent() {
        return (ShapeData)this.getCurrentData();
    }

    protected void initialize() {
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage((String)"nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
        this.reset();
    }

    public Angle getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(Angle angle) {
        this.azimuth = angle;
    }

    public Angle getElevationAngle() {
        return this.elevationAngle;
    }

    public void setElevationAngle(Angle angle) {
        this.elevationAngle = angle;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
        this.reset();
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double d) {
        this.length = d;
        this.reset();
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String string) {
        this.xAxisLabel = string;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public void setYAxisLabel(String string) {
        this.yAxisLabel = string;
    }

    public String getZAxisLabel() {
        return this.zAxisLabel;
    }

    public void setZAxisLabel(String string) {
        this.zAxisLabel = string;
    }

    public Position getReferencePosition() {
        return this.getPosition();
    }

    public Extent getExtent(Globe globe, double d) {
        Extent extent = super.getExtent(globe, d);
        if (extent != null) {
            return extent;
        }
        this.getCurrent().setExtent((Extent)new Sphere(globe.computePointFromPosition(this.getReferencePosition()), this.getRadius()));
        return this.getCurrent().getExtent();
    }

    public Sector getSector() {
        if (this.sector == null) {
            this.sector = null;
        }
        return this.sector;
    }

    protected boolean mustApplyTexture(DrawContext drawContext) {
        return false;
    }

    protected boolean shouldUseVBOs(DrawContext drawContext) {
        return false;
    }

    public void render(DrawContext drawContext) {
        super.render(drawContext);
    }

    protected boolean mustDrawOutline() {
        return false;
    }

    protected boolean mustRegenerateGeometry(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrent();
        if (shapeData.vertices == null) {
            return true;
        }
        if (this.getAltitudeMode() == 0 && shapeData.getGlobeStateKey() != null && shapeData.getGlobeStateKey().equals(drawContext.getGlobe().getGlobeStateKey(drawContext))) {
            return false;
        }
        Vec4 vec4 = this.computePoint(drawContext.getTerrain(), this.getPosition());
        if (shapeData.getReferencePoint() != null && shapeData.getReferencePoint().equals((Object)vec4)) {
            return false;
        }
        return super.mustRegenerateGeometry(drawContext);
    }

    protected boolean doMakeOrderedRenderable(DrawContext drawContext) {
        if (!this.intersectsFrustum(drawContext)) {
            return false;
        }
        this.makeCylinderVertices(drawContext);
        this.makeCone();
        ShapeData shapeData = this.getCurrent();
        if (shapeData.indices == null) {
            this.makeCylinderIndices();
        }
        if (shapeData.normals == null) {
            this.makeCylinderNormals();
        }
        return true;
    }

    protected boolean isOrderedRenderableValid(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrent();
        return shapeData.vertices != null && shapeData.indices != null && shapeData.normals != null;
    }

    protected void doDrawOutline(DrawContext drawContext) {
    }

    protected void doDrawInterior(DrawContext drawContext) {
        this.drawAxes(drawContext);
    }

    public void drawAxes(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrent();
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glPolygonMode(1032, 6914);
        gL2.glPushMatrix();
        gL2.glRotated(this.getPosition().getLongitude().degrees, 0.0, 1.0, 0.0);
        gL2.glRotated(Math.abs(90.0 - this.getPosition().getLatitude().degrees), 1.0, 0.0, 0.0);
        if (this.getAzimuth() != null) {
            gL2.glRotated(-this.getAzimuth().degrees, 0.0, 1.0, 0.0);
        }
        if (this.getElevationAngle() != null) {
            gL2.glRotated(this.getElevationAngle().degrees, 1.0, 0.0, 0.0);
        }
        gL2.glVertexPointer(3, 5126, 0, shapeData.vertices.rewind());
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null)) {
            gL2.glNormalPointer(5126, 0, shapeData.normals.rewind());
        }
        this.drawCylinder(drawContext, shapeData);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glRotated(90.0, 0.0, 0.0, -1.0);
        this.drawCylinder(drawContext, shapeData);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glRotated(90.0, 1.0, 0.0, 0.0);
        this.drawCylinder(drawContext, shapeData);
        gL2.glPopMatrix();
        gL2.glVertexPointer(3, 5126, 0, shapeData.coneVertices.rewind());
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null)) {
            gL2.glNormalPointer(5126, 0, shapeData.coneNormals.rewind());
        }
        this.drawCone(drawContext, shapeData);
        gL2.glPushMatrix();
        gL2.glRotated(90.0, 0.0, 0.0, -1.0);
        this.drawCone(drawContext, shapeData);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glRotated(90.0, 1.0, 0.0, 0.0);
        this.drawCone(drawContext, shapeData);
        gL2.glPopMatrix();
        gL2.glPopMatrix();
        if (!drawContext.isPickingMode()) {
            this.drawLabels(drawContext);
        }
    }

    protected void drawCylinder(DrawContext drawContext, ShapeData shapeData) {
        GL2 gL2 = drawContext.getGL().getGL2();
        for (IntBuffer intBuffer : shapeData.indices) {
            gL2.glDrawElements(5, intBuffer.limit(), 5125, intBuffer.rewind());
        }
    }

    protected void drawCone(DrawContext drawContext, ShapeData shapeData) {
        GL2 gL2 = drawContext.getGL().getGL2();
        IntBuffer intBuffer = shapeData.coneIndices;
        gL2.glDrawElements(6, intBuffer.limit(), 5125, intBuffer.rewind());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawLabels(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        Matrix matrix = Matrix.fromAxisAngle((Angle)Angle.POS90.subtract(this.position.getLatitude()), (Vec4)Vec4.UNIT_X);
        Matrix matrix2 = Matrix.fromAxisAngle((Angle)this.position.getLongitude(), (Vec4)Vec4.UNIT_Y);
        Matrix matrix3 = matrix2.multiply(matrix);
        if (this.getAzimuth() != null) {
            matrix3 = matrix3.multiply(Matrix.fromAxisAngle((Angle)this.getAzimuth().multiply(-1.0), (Vec4)Vec4.UNIT_Y));
        }
        if (this.getElevationAngle() != null) {
            matrix3 = matrix3.multiply(Matrix.fromAxisAngle((Angle)this.getElevationAngle(), (Vec4)Vec4.UNIT_X));
        }
        Vec4 vec4 = new Vec4(1.1 * this.getLength(), 0.0, 0.0).transformBy3(matrix3);
        Vec4 vec42 = new Vec4(0.0, 1.1 * this.getLength(), 0.0).transformBy3(matrix3);
        Vec4 vec43 = new Vec4(0.0, 0.0, 1.1 * this.getLength()).transformBy3(matrix3);
        Vec4 vec44 = this.getCurrent().getReferencePoint();
        vec4 = vec4.add3(vec44);
        vec42 = vec42.add3(vec44);
        vec43 = vec43.add3(vec44);
        Vec4 vec45 = drawContext.getView().project(vec4);
        Vec4 vec46 = drawContext.getView().project(vec42);
        Vec4 vec47 = drawContext.getView().project(vec43);
        drawContext.getView().popReferenceCenter(drawContext);
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            oGLStackHandler.pushProjectionIdentity(gL2);
            gL2.glOrtho(0.0, (double)drawContext.getView().getViewport().width, 0.0, (double)drawContext.getView().getViewport().height, -1.0, 1.0);
            oGLStackHandler.pushModelviewIdentity(gL2);
            TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer((TextRendererCache)drawContext.getTextRendererCache(), (Font)this.labelFont);
            Color color = this.getActiveAttributes().getInteriorMaterial().getDiffuse();
            Color color2 = color.getAlpha() < 255 ? new Color(0, 0, 0, color.getAlpha()) : Color.BLACK;
            oGLStackHandler.pushAttrib(gL2, 256);
            gL2.glDisable(2929);
            gL2.glDepthMask(false);
            textRenderer.begin3DRendering();
            try {
                this.drawLabel(textRenderer, this.getYAxisLabel(), vec45, color, color2);
                this.drawLabel(textRenderer, this.getZAxisLabel(), vec46, color, color2);
                this.drawLabel(textRenderer, this.getXAxisLabel(), vec47, color, color2);
            }
            finally {
                textRenderer.end3DRendering();
            }
        }
        finally {
            oGLStackHandler.pop(gL2);
            drawContext.getView().pushReferenceCenter(drawContext, this.getCurrent().getReferencePoint());
        }
    }

    protected void drawLabel(TextRenderer textRenderer, String string, Vec4 vec4, Color color, Color color2) {
        textRenderer.setColor(color2);
        textRenderer.draw3D(string, (float)((int)vec4.x + 1), (float)((int)vec4.y - 1), 0.0f, 1.0f);
        textRenderer.setColor(color);
        textRenderer.draw3D(string, (float)((int)vec4.x), (float)((int)vec4.y), 0.0f, 1.0f);
    }

    protected void makeCylinderVertices(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrent();
        Vec4 vec4 = this.computePoint(drawContext.getTerrain(), this.getPosition());
        shapeData.setReferencePoint(vec4);
        int n = (this.nHeightIntervals + 1) * (this.nThetaIntervals + 1);
        shapeData.vertices = Buffers.newDirectFloatBuffer((int)(3 * n));
        double d = -1.7976931348623157E308;
        double d2 = -1.7976931348623157E308;
        double d3 = -1.7976931348623157E308;
        double d4 = this.getLength() / (double)this.nHeightIntervals;
        double d5 = Math.PI * 2 / (double)this.nThetaIntervals;
        Double d6 = this.getRadius();
        for (int i = 0; i <= this.nHeightIntervals; ++i) {
            double d7 = (double)i * d4;
            if (i == this.nHeightIntervals) {
                d7 = this.getLength();
            }
            for (int j = 0; j <= this.nThetaIntervals; ++j) {
                double d8 = (double)j * d5;
                if (j == this.nThetaIntervals) {
                    d8 = 0.0;
                }
                double d9 = d6 * Math.sin(d8);
                double d10 = d6 * Math.cos(d8);
                double d11 = d7;
                double d12 = Math.abs(d9);
                double d13 = Math.abs(d11);
                double d14 = Math.abs(d10);
                if (d12 > d) {
                    d = d12;
                }
                if (d13 > d2) {
                    d2 = d13;
                }
                if (d14 > d3) {
                    d3 = d14;
                }
                shapeData.vertices.put((float)d9).put((float)d11).put((float)d10);
            }
        }
        shapeData.setExtent((Extent)new Sphere(vec4, Math.sqrt(d * d + d2 * d2 + d3 * d3)));
    }

    protected void makeCylinderIndices() {
        ShapeData shapeData = this.getCurrent();
        shapeData.indices = new IntBuffer[this.nHeightIntervals];
        for (int i = 0; i < this.nHeightIntervals; ++i) {
            shapeData.indices[i] = Buffers.newDirectIntBuffer((int)(2 * this.nThetaIntervals + 2));
            for (int j = 0; j <= this.nThetaIntervals; ++j) {
                int n = j + i * (this.nThetaIntervals + 1);
                int n2 = n + this.nThetaIntervals + 1;
                shapeData.indices[i].put(n).put(n2);
            }
        }
    }

    protected void makeCylinderNormals() {
        ShapeData shapeData = this.getCurrent();
        shapeData.normals = Buffers.newDirectFloatBuffer((int)shapeData.vertices.limit());
        for (int i = 0; i < shapeData.vertices.limit(); i += 3) {
            Vec4 vec4 = new Vec4((double)shapeData.vertices.get(i), 0.0, (double)shapeData.vertices.get(i + 2)).normalize3();
            shapeData.normals.put((float)(-vec4.x)).put(0.0f).put((float)(-vec4.z));
        }
    }

    protected void makeCone() {
        int n;
        double d = Math.PI * 2 / (double)this.nThetaIntervals;
        Vec4 vec4 = new Vec4(0.0, 1.05 * this.getLength(), 0.0);
        double d2 = 1.0 * this.getRadius();
        Vec4[] vec4Array = new Vec4[this.nThetaIntervals];
        for (int i = 0; i < vec4Array.length; ++i) {
            double d3 = (double)i * d;
            double d4 = d2 * Math.sin(d3);
            double d5 = d2 * Math.cos(d3);
            vec4Array[i] = new Vec4(d4, this.getLength(), d5);
        }
        ShapeData shapeData = this.getCurrent();
        Vec4[] vec4Array2 = new Vec4[vec4Array.length];
        Vec4 vec42 = null;
        for (n = 0; n < vec4Array.length; ++n) {
            Vec4 vec43;
            Vec4 vec44;
            if (n == 0) {
                Vec4 vec45 = vec4Array[vec4Array.length - 1].subtract3(vec4);
                vec44 = vec4Array[n].subtract3(vec4);
                vec43 = vec4Array[n + 1].subtract3(vec4);
                vec42 = vec45.cross3(vec44).multiply3(0.5);
            } else if (n == vec4Array.length - 1) {
                vec44 = vec4Array[n].subtract3(vec4);
                vec43 = vec4Array[0].subtract3(vec4);
            } else {
                vec44 = vec4Array[n].subtract3(vec4);
                vec43 = vec4Array[n + 1].subtract3(vec4);
            }
            Vec4 vec46 = vec44.cross3(vec43).multiply3(0.5);
            vec4Array2[n] = vec42.add3(vec46).normalize3();
            vec42 = vec46;
        }
        shapeData.coneVertices = Buffers.newDirectFloatBuffer((int)(3 * (vec4Array.length + 1)));
        shapeData.coneNormals = Buffers.newDirectFloatBuffer((int)shapeData.coneVertices.capacity());
        shapeData.coneVertices.put((float)vec4.x).put((float)vec4.y).put((float)vec4.z);
        shapeData.coneNormals.put(0.0f).put(1.0f).put(0.0f);
        for (n = 0; n < vec4Array.length; ++n) {
            Vec4 vec47 = vec4Array[n];
            Vec4 vec48 = vec4Array2[n];
            shapeData.coneVertices.put((float)vec47.x).put((float)vec47.y).put((float)vec47.z);
            shapeData.coneNormals.put((float)vec48.x).put((float)vec48.y).put((float)vec48.z);
        }
        shapeData.coneIndices = Buffers.newDirectIntBuffer((int)(vec4Array.length + 2));
        for (n = 0; n < shapeData.coneIndices.capacity() - 1; ++n) {
            shapeData.coneIndices.put(n);
        }
        shapeData.coneIndices.put(1);
    }

    protected void fillVBO(DrawContext drawContext) {
    }

    public void moveTo(Position position) {
    }

    public List<Intersection> intersect(Line line, Terrain terrain) throws InterruptedException {
        return null;
    }

    public String isExportFormatSupported(String string) {
        return "Export.FormatNotSupported";
    }

    protected void doExportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        throw new UnsupportedOperationException("KML output not supported for AntennaModel");
    }

    protected static class ShapeData
    extends AbstractShape.AbstractShapeData {
        protected FloatBuffer vertices;
        protected IntBuffer[] indices;
        protected FloatBuffer normals;
        protected FloatBuffer coneVertices;
        protected IntBuffer coneIndices;
        protected FloatBuffer coneNormals;

        public ShapeData(DrawContext drawContext, AntennaAxes antennaAxes) {
            super(drawContext, antennaAxes.minExpiryTime, antennaAxes.maxExpiryTime);
        }
    }
}

