/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.data.BasicDataRasterReaderFactory;
import gov.nasa.worldwind.data.CachedDataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.data.DataStoreProducer;
import gov.nasa.worldwind.data.TiledElevationProducer;
import gov.nasa.worldwind.data.TiledImageProducer;
import gov.nasa.worldwind.data.TiledRasterProducer;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.applications.dataimporter.DataInstallerProgressMonitor;
import gov.nasa.worldwindx.applications.dataimporter.FileSet;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataInstaller
extends AVListImpl {
    public static final String IMAGERY = "Imagery";
    public static final String ELEVATION = "Elevation";
    public static final String INSTALL_COMPLETE = "gov.nasa.worldwindx.dataimport.DataInstaller.InstallComplete";
    public static final String PREVIEW_LAYER = "gov.nasa.worldwindx.dataimport.DataInstaller.PreviewLayer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document installDataFromFiles(Component component, FileSet fileSet) throws Exception {
        DataStoreProducer dataStoreProducer = this.createDataStoreProducerFromFiles(fileSet);
        File file = this.getDefaultInstallLocation(WorldWind.getDataFileStore());
        if (file == null) {
            String string = Logging.getMessage((String)"generic.NoDefaultImportLocation");
            Logging.logger().severe(string);
            return null;
        }
        String string = this.askForDatasetName(this.suggestDatasetName(fileSet));
        DataInstallerProgressMonitor dataInstallerProgressMonitor = new DataInstallerProgressMonitor(component, dataStoreProducer);
        Document document = null;
        try {
            dataInstallerProgressMonitor.start();
            document = this.createDataStore(fileSet, file, string, dataStoreProducer);
            this.createRasterServerConfigDoc(WorldWind.getDataFileStore(), dataStoreProducer);
            if (dataInstallerProgressMonitor.isCanceled()) {
                document = null;
                dataStoreProducer.removeProductionState();
            }
        }
        finally {
            dataInstallerProgressMonitor.stop();
        }
        return document;
    }

    protected DataStoreProducer createDataStoreProducerFromFiles(FileSet fileSet) throws IllegalArgumentException {
        if (fileSet == null || fileSet.getLength() == 0) {
            String string = Logging.getMessage((String)"nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.determineCommonPixelFormat(fileSet);
        if ("gov.nasa.worldwind.avkey.Image".equals(string)) {
            return new TiledImageProducer();
        }
        if ("gov.nasa.worldwind.avkey.Elevation".equals(string)) {
            return new TiledElevationProducer();
        }
        String string2 = Logging.getMessage((String)"generic.UnexpectedRasterType", (String)string);
        Logging.logger().severe(string2);
        throw new IllegalArgumentException(string2);
    }

    protected String determineCommonPixelFormat(FileSet fileSet) throws IllegalArgumentException {
        if (fileSet == null || fileSet.getLength() == 0) {
            String string = Logging.getMessage((String)"nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = null;
        for (File file : fileSet.getFiles()) {
            AVListImpl aVListImpl;
            if (!this.isDataRaster(file, (AVList)(aVListImpl = new AVListImpl()))) continue;
            String string2 = aVListImpl.getStringValue("gov.nasa.worldwind.avkey.PixelFormat");
            if (WWUtil.isEmpty(string)) {
                if (WWUtil.isEmpty((Object)string2)) {
                    String string3 = Logging.getMessage((String)"generic.UnrecognizedSourceType", (String)file.getAbsolutePath());
                    Logging.logger().severe(string3);
                    throw new IllegalArgumentException(string3);
                }
                string = string2;
                continue;
            }
            if (string == null || string.equals(string2)) continue;
            if (WWUtil.isEmpty((Object)string2)) {
                String string4 = Logging.getMessage((String)"generic.UnrecognizedSourceType", (String)file.getAbsolutePath());
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
            String string5 = Logging.getMessage((String)"generic.UnexpectedRasterType", (String)string2);
            String string6 = file.getAbsolutePath() + ": " + string5;
            String string7 = Logging.getMessage((String)"DataRaster.IncompatibleRaster", (String)string6);
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        return string;
    }

    protected Document createDataStore(FileSet fileSet, File file, String string, DataStoreProducer dataStoreProducer) throws Exception {
        File file22;
        Object object;
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", (Object)string);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", (Object)string);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", (Object)file.getAbsolutePath());
        boolean bl = Configuration.getBooleanValue((String)"gov.nasa.worldwind.avkey.Producer.EnableFullPyramid", (Boolean)false);
        if (!bl) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceName", (Object)"LocalRasterServer");
            object = Configuration.getStringValue((String)"gov.nasa.worldwind.avkey.TiledRasterProducer.LimitMaxLevel", (String)"0");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.TiledRasterProducer.LimitMaxLevel", object);
        } else {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Producer.EnableFullPyramid", (Object)true);
        }
        dataStoreProducer.setStoreParameters((AVList)aVListImpl);
        try {
            for (File file22 : fileSet.getFiles()) {
                dataStoreProducer.offerDataSource((Object)file22, null);
                Thread.yield();
            }
            dataStoreProducer.startProduction();
        }
        catch (InterruptedException interruptedException) {
            dataStoreProducer.removeProductionState();
            Thread.interrupted();
            throw interruptedException;
        }
        catch (Exception exception) {
            dataStoreProducer.removeProductionState();
            throw exception;
        }
        object = dataStoreProducer.getProductionResults();
        if (object != null && object.iterator() != null && object.iterator().hasNext() && (file22 = object.iterator().next()) != null && file22 instanceof Document) {
            return (Document)((Object)file22);
        }
        return null;
    }

    protected String askForDatasetName(String string) {
        String string2 = string;
        Object object = JOptionPane.showInputDialog(null, "Name:", "Enter dataset name", 3, null, null, string2);
        if (!(object instanceof String)) {
            Thread.interrupted();
            String string3 = Logging.getMessage((String)"generic.OperationCancelled", (String)"Import");
            Logging.logger().info(string3);
            throw new WWRuntimeException(string3);
        }
        return WWIO.replaceIllegalFileNameCharacters((String)((String)object));
    }

    protected String suggestDatasetName(FileSet fileSet) {
        Object object;
        if (null == fileSet || fileSet.getLength() == 0) {
            return null;
        }
        if (fileSet.getName() != null) {
            return fileSet.getScale() != null ? fileSet.getName() + " " + fileSet.getScale() : fileSet.getName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        block0: for (File serializable2 : fileSet.getFiles()) {
            object = serializable2.getAbsolutePath();
            if (WWUtil.isEmpty((Object)object)) continue;
            object = WWIO.replaceIllegalFileNameCharacters((String)WWIO.replaceSuffix((String)object, (String)""));
            if (stringBuilder.length() == 0) {
                stringBuilder.append((String)object);
                continue;
            }
            int string2 = Math.min(((String)object).length(), stringBuilder.length());
            for (int i = 0; i < string2; ++i) {
                if (((String)object).charAt(i) == stringBuilder.charAt(i)) continue;
                stringBuilder.setLength(i);
                continue block0;
            }
        }
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        object = new StringTokenizer(string, " _:/\\-=!@#$%^&()[]{}|\".,<>;`+");
        String string2 = null;
        while (((StringTokenizer)object).hasMoreTokens()) {
            String iterator = ((StringTokenizer)object).nextToken();
            if (WWUtil.isEmpty((Object)iterator) || iterator.length() < 2 || iterator.equalsIgnoreCase(string2)) continue;
            string2 = iterator;
            arrayList.add(iterator);
            if (arrayList.size() <= 4) continue;
            arrayList.remove(0);
        }
        if (arrayList.size() > 0) {
            stringBuilder.setLength(0);
            for (String string3 : arrayList) {
                stringBuilder.append(string3).append(' ');
            }
            stringBuilder.append(fileSet.isImagery() ? " Imagery" : (fileSet.isElevation() ? " Elevations" : ""));
            return stringBuilder.toString().trim();
        }
        return WWUtil.isEmpty((Object)string) ? "change me" : string;
    }

    protected void createRasterServerConfigDoc(FileStore fileStore, DataStoreProducer dataStoreProducer) {
        String[] stringArray2;
        AVList aVList = null != dataStoreProducer ? dataStoreProducer.getProductionParameters() : new AVListImpl();
        Object object = aVList = null == aVList ? new AVListImpl() : aVList;
        if (!"LocalRasterServer".equals(aVList.getValue("gov.nasa.worldwind.avkey.ServiceName"))) {
            return;
        }
        File file = this.getDefaultInstallLocation(fileStore);
        if (file == null) {
            String string = Logging.getMessage((String)"generic.NoDefaultImportLocation");
            Logging.logger().severe(string);
            return;
        }
        Document document = WWXML.createDocumentBuilder((boolean)true).newDocument();
        Element element = WWXML.setDocumentElement((Document)document, (String)"RasterServer");
        WWXML.setTextAttribute((Element)element, (String)"version", (String)"1.0");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(file.getAbsolutePath()).append(File.separator);
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.DataCacheNameKey")) {
            String string = Logging.getMessage((String)"generic.MissingRequiredParameter", (String)"gov.nasa.worldwind.avkey.DataCacheNameKey");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        stringBuilder.append(aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey")).append(File.separator);
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.DatasetNameKey")) {
            String string = Logging.getMessage((String)"generic.MissingRequiredParameter", (String)"gov.nasa.worldwind.avkey.DatasetNameKey");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        stringBuilder.append(aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey")).append(".RasterServer.xml");
        Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.DisplayName");
        if (WWUtil.isEmpty((Object)object2)) {
            aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey"));
        }
        String string = stringBuilder.toString();
        Sector sector = null;
        if (aVList.hasKey("gov.nasa.worldwind.avKey.Sector") && null != (object2 = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) && object2 instanceof Sector) {
            sector = (Sector)object2;
        }
        if (null == sector) {
            String string2 = Logging.getMessage((String)"generic.MissingRequiredParameter", (String)"gov.nasa.worldwind.avKey.Sector");
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        WWXML.appendSector((Element)element, (String)"Sector", sector);
        Element element2 = document.createElementNS(null, "Sources");
        if (dataStoreProducer instanceof TiledRasterProducer) {
            for (String[] stringArray2 : ((TiledRasterProducer)dataStoreProducer).getDataRasters()) {
                if (stringArray2 instanceof CachedDataRaster) {
                    try {
                        this.appendSource(element2, (CachedDataRaster)stringArray2);
                    }
                    catch (Throwable throwable) {
                        String string3 = WWUtil.extractExceptionReason((Throwable)throwable);
                        Logging.logger().warning(string3);
                    }
                    continue;
                }
                String string4 = Logging.getMessage((String)"TiledRasterProducer.UnrecognizedRasterType", (Object[])new Object[]{stringArray2.getClass().getName(), stringArray2.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey")});
                Logging.logger().severe(string4);
                throw new WWRuntimeException(string4);
            }
        }
        AVListImpl aVListImpl = new AVListImpl();
        stringArray2 = new String[]{"gov.nasa.worldwind.avkey.DataCacheNameKey", "gov.nasa.worldwind.avkey.DatasetNameKey", "gov.nasa.worldwind.avkey.DisplayName"};
        WWUtil.copyValues((AVList)aVList, (AVList)aVListImpl, (String[])stringArray2, (boolean)false);
        this.appendProperties(element, (AVList)aVListImpl);
        element.appendChild(element2);
        WWXML.saveDocumentToFile((Document)document, (String)string);
    }

    protected void appendProperties(Element element, AVList aVList) {
        if (null == element || aVList == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : aVList.getEntries()) {
            stringBuilder.setLength(0);
            String string = (String)entry.getKey();
            stringBuilder.append(aVList.getValue(string));
            String string2 = stringBuilder.toString();
            if (WWUtil.isEmpty((Object)string) || WWUtil.isEmpty((Object)string2)) continue;
            Element element2 = WWXML.appendElement((Element)element, (String)"Property");
            WWXML.setTextAttribute((Element)element2, (String)"name", (String)string);
            WWXML.setTextAttribute((Element)element2, (String)"value", (String)string2);
        }
    }

    protected void appendSource(Element element, CachedDataRaster cachedDataRaster) throws WWRuntimeException {
        Object object = cachedDataRaster.getDataSource();
        if (WWUtil.isEmpty((Object)object)) {
            String string = Logging.getMessage((String)"nullValue.DataSourceIsNull");
            Logging.logger().fine(string);
            throw new WWRuntimeException(string);
        }
        File file = WWIO.getFileForLocalAddress((Object)object);
        if (WWUtil.isEmpty((Object)file)) {
            String string = Logging.getMessage((String)"TiledRasterProducer.UnrecognizedDataSource", (Object[])new Object[]{object});
            Logging.logger().fine(string);
            throw new WWRuntimeException(string);
        }
        Element element2 = WWXML.appendElement((Element)element, (String)"Source");
        WWXML.setTextAttribute((Element)element2, (String)"type", (String)"file");
        WWXML.setTextAttribute((Element)element2, (String)"path", (String)file.getAbsolutePath());
        AVList aVList = cachedDataRaster.getParams();
        if (null == aVList) {
            String string = Logging.getMessage((String)"nullValue.ParamsIsNull");
            Logging.logger().fine(string);
            throw new WWRuntimeException(string);
        }
        Sector sector = cachedDataRaster.getSector();
        if (null == sector && aVList.hasKey("gov.nasa.worldwind.avKey.Sector") && (object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) instanceof Sector) {
            sector = (Sector)object;
        }
        if (null != sector) {
            WWXML.appendSector((Element)element2, (String)"Sector", (Sector)sector);
        }
    }

    public boolean isDataRaster(Object object, AVList aVList) {
        DataRasterReaderFactory dataRasterReaderFactory;
        if (object == null) {
            String string = Logging.getMessage((String)"nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            dataRasterReaderFactory = (DataRasterReaderFactory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
        }
        catch (Exception exception) {
            dataRasterReaderFactory = new BasicDataRasterReaderFactory();
        }
        aVList = null == aVList ? new AVListImpl() : aVList;
        DataRasterReader dataRasterReader = dataRasterReaderFactory.findReaderFor(object, aVList);
        if (dataRasterReader == null) {
            return false;
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            try {
                dataRasterReader.readMetadata(object, aVList);
            }
            catch (Exception exception) {
                String string = Logging.getMessage((String)"generic.ExceptionWhileReading", (String)exception.getMessage());
                Logging.logger().finest(string);
            }
        }
        return "gov.nasa.worldwind.avkey.Image".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat")) || "gov.nasa.worldwind.avkey.Elevation".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"));
    }

    public File getDefaultInstallLocation(FileStore fileStore) {
        if (fileStore == null) {
            String string = Logging.getMessage((String)"nullValue.FileStoreIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (File file : fileStore.getLocations()) {
            if (!fileStore.isInstallLocation(file.getPath())) continue;
            return file;
        }
        return fileStore.getWriteLocation();
    }

    public static void addToWorldWindow(WorldWindow worldWindow, Element element, AVList aVList, boolean bl) {
        String string = DataConfigurationUtils.getDataConfigType((Element)element);
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("Layer")) {
            DataInstaller.addLayerToWorldWindow(worldWindow, element, aVList, bl);
        } else if (string.equalsIgnoreCase("ElevationModel")) {
            DataInstaller.addElevationModelToWorldWindow(worldWindow, element, aVList, true);
        }
    }

    public static void addLayerToWorldWindow(WorldWindow worldWindow, Element element, AVList aVList, boolean bl) {
        String string;
        Factory factory;
        Layer layer = null;
        try {
            factory = (Factory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.LayerFactory");
            layer = (Layer)factory.createFromConfigSource((Object)element, null);
            string = WWXML.getSector((Element)element, (String)"Sector", null);
            layer.setValue("gov.nasa.worldwind.avKey.Sector", (Object)string);
            aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)layer.getName());
        }
        catch (Exception exception) {
            string = Logging.getMessage((String)"generic.CreationFromConfigurationFailed", (String)DataConfigurationUtils.getDataConfigDisplayName((Element)element));
            Logging.logger().log(Level.SEVERE, string, exception);
        }
        if (layer == null) {
            return;
        }
        layer.setEnabled(true);
        factory = DataInstaller.findLayer(worldWindow, aVList.getStringValue("gov.nasa.worldwind.avkey.DisplayName"));
        if (factory != null) {
            worldWindow.getModel().getLayers().remove((Layer)factory);
        }
        DataInstaller.removeLayerPreview(worldWindow, aVList);
        ApplicationTemplate.insertBeforePlacenames(worldWindow, layer);
        string = (Sector)layer.getValue("gov.nasa.worldwind.avKey.Sector");
        if (bl && string != null && !string.equals((Object)Sector.FULL_SPHERE)) {
            ExampleUtil.goTo(worldWindow, (Sector)string);
        }
    }

    protected static void removeLayerPreview(WorldWindow worldWindow, AVList aVList) {
        Layer layer = (Layer)aVList.getValue("gov.nasa.worldwind.avkey.LayerObject");
        if (layer == null || layer.getValue(PREVIEW_LAYER) == null) {
            return;
        }
        if (!(layer instanceof RenderableLayer)) {
            return;
        }
        SurfaceImage surfaceImage = null;
        RenderableLayer renderableLayer = (RenderableLayer)layer;
        for (Renderable renderable : renderableLayer.getRenderables()) {
            if (!(renderable instanceof SurfaceImage)) continue;
            surfaceImage = (SurfaceImage)renderable;
            break;
        }
        if (surfaceImage != null) {
            renderableLayer.removeRenderable(surfaceImage);
        }
    }

    public static void addElevationModelToWorldWindow(WorldWindow worldWindow, Element element, AVList aVList, boolean bl) {
        CompoundElevationModel compoundElevationModel;
        String string;
        Factory factory;
        ElevationModel elevationModel = null;
        try {
            factory = (Factory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ElevationModelFactory");
            elevationModel = (ElevationModel)factory.createFromConfigSource((Object)element, null);
            aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)elevationModel.getName());
        }
        catch (Exception exception) {
            string = Logging.getMessage((String)"generic.CreationFromConfigurationFailed", (String)DataConfigurationUtils.getDataConfigDisplayName((Element)element));
            Logging.logger().log(Level.SEVERE, string, exception);
        }
        if (elevationModel == null) {
            return;
        }
        factory = DataInstaller.findElevationModel(worldWindow, aVList.getStringValue("gov.nasa.worldwind.avkey.DisplayName"));
        if (factory != null) {
            DataInstaller.removeElevationModel(worldWindow, (ElevationModel)factory);
        }
        if ((string = worldWindow.getModel().getGlobe().getElevationModel()) instanceof CompoundElevationModel) {
            if (!((CompoundElevationModel)string).containsElevationModel(elevationModel)) {
                ((CompoundElevationModel)string).addElevationModel(elevationModel);
            }
        } else {
            compoundElevationModel = new CompoundElevationModel();
            compoundElevationModel.addElevationModel((ElevationModel)string);
            compoundElevationModel.addElevationModel(elevationModel);
            worldWindow.getModel().getGlobe().setElevationModel((ElevationModel)compoundElevationModel);
        }
        compoundElevationModel = (Sector)elevationModel.getValue("gov.nasa.worldwind.avKey.Sector");
        if (bl && compoundElevationModel != null && !compoundElevationModel.equals((Object)Sector.FULL_SPHERE)) {
            ExampleUtil.goTo(worldWindow, (Sector)compoundElevationModel);
        }
        worldWindow.firePropertyChange(new PropertyChangeEvent(worldWindow, "gov.nasa.worldwind.avkey.ElevationModel", null, elevationModel));
    }

    public static DataRasterReaderFactory getReaderFactory() {
        try {
            return (DataRasterReaderFactory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
        }
        catch (Exception exception) {
            return new BasicDataRasterReaderFactory();
        }
    }

    public static Layer findLayer(WorldWindow worldWindow, String string) {
        for (Layer layer : worldWindow.getModel().getLayers()) {
            String string2 = layer.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
            if (string2 == null || !string2.equals(string)) continue;
            return layer;
        }
        return null;
    }

    public static ElevationModel findElevationModel(WorldWindow worldWindow, String string) {
        ElevationModel elevationModel = worldWindow.getModel().getGlobe().getElevationModel();
        if (elevationModel instanceof CompoundElevationModel) {
            CompoundElevationModel compoundElevationModel = (CompoundElevationModel)elevationModel;
            for (ElevationModel elevationModel2 : compoundElevationModel.getElevationModels()) {
                String string2 = elevationModel2.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
                if (string2 == null || !string2.equals(string)) continue;
                return elevationModel2;
            }
        } else {
            String string3 = elevationModel.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
            if (string3 != null && string3.equals(string)) {
                return elevationModel;
            }
        }
        return null;
    }

    public static void removeElevationModel(WorldWindow worldWindow, ElevationModel elevationModel) {
        ElevationModel elevationModel2 = worldWindow.getModel().getGlobe().getElevationModel();
        if (elevationModel2 instanceof CompoundElevationModel) {
            CompoundElevationModel compoundElevationModel = (CompoundElevationModel)elevationModel2;
            for (ElevationModel elevationModel3 : compoundElevationModel.getElevationModels()) {
                String string = elevationModel3.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
                if (string == null || !string.equals(elevationModel.getName())) continue;
                compoundElevationModel.removeElevationModel(elevationModel);
                worldWindow.firePropertyChange(new PropertyChangeEvent(worldWindow, "gov.nasa.worldwind.avkey.ElevationModel", null, elevationModel));
            }
        }
    }
}

