/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.dataimporter.DataInstallerPanel;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.ClickAndGoSelectListener;
import gov.nasa.worldwindx.examples.layermanager.LayerAndElevationManagerPanel;
import gov.nasa.worldwindx.examples.util.HighlightController;
import gov.nasa.worldwindx.examples.util.ToolTipController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DataInstallerApp {
    public static AppFrame start(String string, Class clazz) {
        if (Configuration.isMacOS() && string != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        }
        try {
            final AppFrame appFrame = (AppFrame)clazz.newInstance();
            appFrame.setTitle(string);
            appFrame.setDefaultCloseOperation(3);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    appFrame.setVisible(true);
                }
            });
            return appFrame;
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "Exception at application start", exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        DataInstallerApp.start("Data Installer", AppFrame.class);
    }

    static {
        System.setProperty("java.net.useSystemProxies", "true");
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Application");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        } else if (Configuration.isWindowsOS()) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
    }

    public static class AppFrame
    extends JFrame {
        protected AppPanel wwjPanel;
        protected LayerAndElevationManagerPanel layerManagerPanel;

        public AppFrame() {
            this.initialize();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
        }

        protected void initialize() {
            this.wwjPanel = new AppPanel();
            this.getContentPane().add((Component)this.wwjPanel, "Center");
            this.layerManagerPanel = new LayerAndElevationManagerPanel(this.getWwd());
            this.getContentPane().add((Component)this.layerManagerPanel, "West");
            DataInstallerPanel dataInstallerPanel = new DataInstallerPanel(this.getWwd());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)dataInstallerPanel, "Center");
            this.getContentPane().add((Component)jPanel, "South");
            ViewControlsLayer viewControlsLayer = new ViewControlsLayer();
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), (Layer)viewControlsLayer);
            this.getWwd().addSelectListener((SelectListener)new ViewControlsSelectListener(this.getWwd(), viewControlsLayer));
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!(layer instanceof SelectListener)) continue;
                this.getWwd().addSelectListener((SelectListener)layer);
            }
            this.pack();
            WWUtil.alignComponent(null, (Component)this, (String)"gov.nasa.worldwind.avkey.Center");
            this.setResizable(true);
        }

        public WorldWindow getWwd() {
            return this.wwjPanel.wwd;
        }
    }

    public static class AppPanel
    extends JPanel {
        protected WorldWindow wwd = new WorldWindowGLCanvas();
        protected StatusBar statusBar;
        protected ToolTipController toolTipController;
        protected HighlightController highlightController;

        public AppPanel() {
            super(new BorderLayout());
            ((Component)this.wwd).setPreferredSize(new Dimension(1000, 600));
            Model model = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.wwd.addSelectListener((SelectListener)new ClickAndGoSelectListener(this.wwd, WorldMapLayer.class));
            this.add((Component)this.wwd, "Center");
            this.statusBar = new StatusBar();
            this.add((Component)this.statusBar, "Last");
            this.statusBar.setEventSource(this.wwd);
            this.toolTipController = new ToolTipController(this.wwd, "gov.nasa.worldwind.avkey.DisplayName", null);
            this.highlightController = new HighlightController(this.wwd, "gov.nasa.worldwind.SelectEvent.Rollover");
        }
    }
}

