/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.data.DataStoreProducer;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ProgressMonitor;

public class DataInstallerProgressMonitor
extends ProgressMonitor
implements PropertyChangeListener {
    protected DataStoreProducer producer;
    protected AtomicInteger progress;
    Timer progressTimer = new Timer();

    public DataInstallerProgressMonitor(Component component, DataStoreProducer dataStoreProducer) {
        super(component, "Importing ....", null, 0, 100);
        this.producer = dataStoreProducer;
        this.progress = new AtomicInteger(0);
        this.progressTimer = new Timer();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (DataInstallerProgressMonitor.this.isCanceled()) {
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.Progress")) {
                    DataInstallerProgressMonitor.this.progress.set((int)(100.0 * (Double)propertyChangeEvent.getNewValue()));
                }
            }
        };
        dataStoreProducer.addPropertyChangeListener(propertyChangeListener);
        this.setProgress(0);
    }

    public void start() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DataInstallerProgressMonitor.this.setProgress(DataInstallerProgressMonitor.this.progress.get());
                if (DataInstallerProgressMonitor.this.isCanceled()) {
                    if (DataInstallerProgressMonitor.this.producer != null) {
                        DataInstallerProgressMonitor.this.producer.stopProduction();
                    }
                    this.cancel();
                }
            }
        }, this.getMillisToDecideToPopup(), 100L);
    }

    public void stop() {
        if (this.producer != null) {
            this.producer.removePropertyChangeListener((PropertyChangeListener)this);
            this.producer.removeAllDataSources();
        }
        this.close();
        this.progressTimer.cancel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isCanceled()) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.Progress")) {
            this.progress.set((int)(100.0 * (Double)propertyChangeEvent.getNewValue()));
        }
    }
}

