/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.BasicDataRasterReaderFactory;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.FileFilter;

public class FileSetFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    protected static final String[] SUFFIXES_TO_IGNORE = new String[]{"blw", "prj", "stx"};

    @Override
    public String getDescription() {
        return "Imagery and Elevations";
    }

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        String string = WWIO.getSuffix((String)file.getPath());
        if (string == null) {
            return false;
        }
        for (String string2 : SUFFIXES_TO_IGNORE) {
            if (!string.endsWith(string2)) continue;
            return false;
        }
        return this.isDataRaster(file, null);
    }

    public boolean isDataRaster(Object object, AVList aVList) {
        DataRasterReaderFactory dataRasterReaderFactory;
        if (object == null) {
            String string = Logging.getMessage((String)"nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            dataRasterReaderFactory = (DataRasterReaderFactory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
        }
        catch (Exception exception) {
            dataRasterReaderFactory = new BasicDataRasterReaderFactory();
        }
        aVList = null == aVList ? new AVListImpl() : aVList;
        DataRasterReader dataRasterReader = dataRasterReaderFactory.findReaderFor(object, aVList);
        if (dataRasterReader == null) {
            return false;
        }
        try {
            dataRasterReader.readMetadata(object, aVList);
        }
        catch (Exception exception) {
            String string = Logging.getMessage((String)"generic.ExceptionWhileReading", (String)exception.getMessage());
            Logging.logger().finest(string);
        }
        if (!"gov.nasa.worldwind.avkey.Image".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat")) && !"gov.nasa.worldwind.avkey.Elevation".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
            return false;
        }
        return aVList.getValue("gov.nasa.worldwind.avKey.Sector") != null;
    }
}

