/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.formats.rpf.RPFFrameFilename;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.applications.dataimporter.DataInstaller;
import gov.nasa.worldwindx.applications.dataimporter.FileSet;
import gov.nasa.worldwindx.applications.dataimporter.FileSetFilter;
import gov.nasa.worldwindx.applications.dataimporter.FileSetMap;
import gov.nasa.worldwindx.applications.dataimporter.FileSetRPF;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class FileSetFinder {
    FileSetMap fileSetMap = new FileSetMap();

    public FileSetMap getFileSetMap() {
        return this.fileSetMap;
    }

    public void findFileSets(File[] fileArray) {
        this.fileSetMap.clear();
        for (File file : fileArray) {
            this.findFileSets(file.getPath());
        }
    }

    protected void findFileSets(String string) {
        File file = new File(string);
        String[] stringArray = WWIO.listDescendantFilenames((File)file, (FileFilter)new FileSetFilter());
        for (String string2 : stringArray) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                FileSet fileSet;
                File file2 = new File(file, string2);
                try {
                    RPFFrameFilename rPFFrameFilename = RPFFrameFilename.parseFilename((String)file2.getName().toUpperCase());
                    String string3 = rPFFrameFilename.getDataSeriesCode();
                    if (string3 != null) {
                        fileSet = (FileSet)((Object)this.fileSetMap.get(string3));
                        if (fileSet == null) {
                            fileSet = new FileSetRPF(string3);
                            this.fileSetMap.put(string3, fileSet);
                        }
                        fileSet.addFile(file2);
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fileSet = new FileSet();
                fileSet.setName(file2.getName());
                fileSet.setDatasetType(WWIO.getSuffix((String)file2.getPath().toUpperCase()));
                this.fileSetMap.put(file2.getPath(), fileSet);
                fileSet.addFile(file2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (FileSet fileSet : this.fileSetMap.values()) {
            this.attachMetadata(fileSet);
        }
    }

    public void attachMetadata(FileSet fileSet) {
        DataRasterReaderFactory dataRasterReaderFactory = DataInstaller.getReaderFactory();
        ArrayList<String> arrayList = new ArrayList<String>(fileSet.getLength());
        String string = null;
        for (File file : fileSet.getFiles()) {
            String string2;
            AVListImpl aVListImpl;
            DataRasterReader dataRasterReader = dataRasterReaderFactory.findReaderFor((Object)file, (AVList)(aVListImpl = new AVListImpl()));
            if (dataRasterReader == null) {
                Logging.logger().fine("No reader for " + file.getPath());
                continue;
            }
            try {
                dataRasterReader.readMetadata((Object)file, (AVList)aVListImpl);
            }
            catch (Exception exception) {
                String string3 = Logging.getMessage((String)"generic.ExceptionWhileReading", (String)exception.getMessage());
                Logging.logger().finest(string3);
            }
            if (fileSet.getDataType() == null) {
                string2 = aVListImpl.getStringValue("gov.nasa.worldwind.avkey.PixelFormat");
                fileSet.setValue("gov.nasa.worldwind.avkey.PixelFormat", string2);
                if ("gov.nasa.worldwind.avkey.Image".equals(string2)) {
                    fileSet.setDataType("Imagery");
                } else if ("gov.nasa.worldwind.avkey.Elevation".equals(string2)) {
                    fileSet.setDataType("Elevation");
                }
            }
            if ((string2 = (Sector)aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector")) == null) {
                Logging.logger().fine("No sector for " + file.getPath());
                continue;
            }
            arrayList.add(string2);
            string = string == null ? string2 : string.union((Sector)string2);
        }
        if (string != null) {
            fileSet.setValue("gov.nasa.worldwind.avKey.Sector", string);
            fileSet.addSectorList(arrayList.toArray());
        }
    }

    public List<FileSet> consolidateFileSets(List<FileSet> list) {
        if (list.size() <= 1) {
            return list;
        }
        FileSetMap fileSetMap = new FileSetMap();
        ArrayList<FileSet> arrayList = new ArrayList<FileSet>();
        for (FileSet fileSet : list) {
            String string;
            if (fileSet.getFiles().size() > 1) {
                arrayList.add(fileSet);
                continue;
            }
            File file = fileSet.getFiles().get(0);
            FileSetKey fileSetKey = new FileSetKey(file, string = fileSet.getDataType());
            FileSet fileSet2 = (FileSet)((Object)fileSetMap.get(fileSetKey));
            if (fileSet2 == null) {
                fileSet2 = new FileSet();
                fileSetMap.put(fileSetKey, fileSet2);
                fileSet2.setDataType(fileSet.getDataType());
                fileSet2.setValue("gov.nasa.worldwind.avkey.PixelFormat", fileSet.getValue("gov.nasa.worldwind.avkey.PixelFormat"));
                fileSet2.setSector(fileSet.getSector());
                arrayList.add(fileSet2);
            }
            fileSet2.addFile(file);
            fileSet2.setSector(fileSet2.getSector().union(fileSet.getSector()));
            fileSet2.addSectorList(fileSet.getSectorList());
        }
        return arrayList;
    }

    protected static class FileSetKey {
        protected String suffix;
        protected String dataType;
        protected File parentDirectory;

        public FileSetKey(File file, String string) {
            this.dataType = string;
            this.suffix = WWIO.getSuffix((String)file.getPath().toUpperCase());
            this.parentDirectory = file.getParentFile();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FileSetKey fileSetKey = (FileSetKey)object;
            if (this.dataType != null ? !this.dataType.equals(fileSetKey.dataType) : fileSetKey.dataType != null) {
                return false;
            }
            if (this.parentDirectory != null ? !this.parentDirectory.equals(fileSetKey.parentDirectory) : fileSetKey.parentDirectory != null) {
                return false;
            }
            return !(this.suffix != null ? !this.suffix.equals(fileSetKey.suffix) : fileSetKey.suffix != null);
        }

        public int hashCode() {
            int n = this.suffix != null ? this.suffix.hashCode() : 0;
            n = 31 * n + (this.dataType != null ? this.dataType.hashCode() : 0);
            n = 31 * n + (this.parentDirectory != null ? this.parentDirectory.hashCode() : 0);
            return n;
        }
    }
}

