/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwindx.applications.dataimporter.FileSet;
import gov.nasa.worldwindx.applications.dataimporter.FileSetPanel;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileSetHighlighter
implements ListSelectionListener,
SelectListener,
PropertyChangeListener {
    protected FileSetPanel fileSetPanel;
    protected WorldWindow wwd;
    List<FileSet> currentlyHighlightedSets = new ArrayList<FileSet>();

    public FileSetHighlighter(WorldWindow worldWindow, FileSetPanel fileSetPanel) {
        this.wwd = worldWindow;
        this.fileSetPanel = fileSetPanel;
        this.wwd.addSelectListener((SelectListener)this);
        this.fileSetPanel.addSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.handleSelection(this.fileSetPanel.getSelectedFileSets());
    }

    protected void handleSelection(List<FileSet> list) {
        this.unHighlightSelectedSets();
        if (list == null || list.size() == 0) {
            return;
        }
        Sector sector = this.highlightSelectedSets(list);
        if (sector != null) {
            if (!sector.isWithinLatLonLimits()) {
                sector = FileSetHighlighter.normalizeSector(sector);
            }
            ExampleUtil.goTo(this.wwd, sector);
        } else {
            this.wwd.redraw();
        }
    }

    protected static Sector normalizeSector(Sector sector) {
        return new Sector(sector.getMinLatitude().normalizedLatitude(), sector.getMaxLatitude().normalizedLatitude(), sector.getMinLongitude().normalizedLongitude(), sector.getMaxLongitude().normalizedLongitude());
    }

    protected void unHighlightSelectedSets() {
        for (FileSet fileSet : this.currentlyHighlightedSets) {
            Layer layer = (Layer)fileSet.getValue("gov.nasa.worldwind.avkey.LayerObject");
            if (layer == null) continue;
            this.wwd.getModel().getLayers().remove(layer);
        }
        this.currentlyHighlightedSets.clear();
    }

    protected Sector highlightSelectedSets(List<FileSet> list) {
        Sector sector = null;
        for (FileSet fileSet : list) {
            Layer layer = (Layer)fileSet.getValue("gov.nasa.worldwind.avkey.LayerObject");
            if (layer == null) {
                layer = this.createSectorLayer(fileSet);
                layer.setValue("FileSet", (Object)fileSet);
            }
            this.currentlyHighlightedSets.add(fileSet);
            this.wwd.getModel().getLayers().add(layer);
            Sector sector2 = fileSet.getSector();
            if (sector2 == null) continue;
            sector = sector == null ? sector2 : sector.union(sector2);
        }
        return sector;
    }

    protected Layer createSectorLayer(FileSet fileSet) {
        RenderableLayer renderableLayer = new RenderableLayer();
        fileSet.setValue("gov.nasa.worldwind.avkey.LayerObject", renderableLayer);
        renderableLayer.setValue("gov.nasa.worldwind.avkey.Ignore", (Object)true);
        renderableLayer.setValue("gov.nasa.worldwindx.dataimport.DataInstaller.PreviewLayer", (Object)true);
        this.populateLayer(fileSet, renderableLayer);
        return renderableLayer;
    }

    protected void populateLayer(FileSet fileSet, RenderableLayer renderableLayer) {
        Object[] objectArray = fileSet.getSectorList();
        for (int i = 0; i < objectArray.length; ++i) {
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setOutlineMaterial(new Material(fileSet.getColor()));
            basicShapeAttributes.setOutlineWidth(2.0);
            Sector sector = (Sector)objectArray[i];
            List list = sector.asList();
            ArrayList<Position> arrayList = new ArrayList<Position>(5);
            for (LatLon latLon : list) {
                arrayList.add(new Position(latLon, 0.0));
            }
            arrayList.add(new Position((LatLon)list.get(0), 0.0));
            arrayList.add(new Position((LatLon)list.get(0), 0.0));
            Path path = new Path(arrayList);
            path.setAltitudeMode(1);
            path.setFollowTerrain(true);
            path.setAttributes((ShapeAttributes)basicShapeAttributes);
            renderableLayer.addRenderable((Renderable)path);
        }
        if (fileSet.isImagery() && fileSet.getLength() <= fileSet.getMaxFilesForPreviewImage()) {
            this.addImage(fileSet);
        }
    }

    public void selected(SelectEvent selectEvent) {
        if (!selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
            return;
        }
        if (!(selectEvent.getTopObject() instanceof Path)) {
            return;
        }
        FileSet fileSet = (FileSet)((Object)selectEvent.getTopPickedObject().getParentLayer().getValue("FileSet"));
        if (fileSet == null) {
            return;
        }
        this.fileSetPanel.scrollToFileSet(fileSet);
    }

    public void addImage(FileSet fileSet) {
        BufferedImage bufferedImage = fileSet.getImage();
        if (bufferedImage != null) {
            fileSet.removePropertyChangeListener("gov.nasa.worldwind.avkey.Image", this);
            Sector sector = (Sector)fileSet.getValue("gov.nasa.worldwind.avKey.Sector");
            SurfaceImage surfaceImage = new SurfaceImage((Object)bufferedImage, sector);
            RenderableLayer renderableLayer = (RenderableLayer)fileSet.getValue("gov.nasa.worldwind.avkey.LayerObject");
            renderableLayer.addRenderable((Renderable)surfaceImage);
            this.wwd.redraw();
        } else {
            fileSet.addPropertyChangeListener("gov.nasa.worldwind.avkey.Image", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.Image")) {
            return;
        }
        final FileSet fileSet = (FileSet)((Object)propertyChangeEvent.getSource());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileSetHighlighter.this.addImage(fileSet);
            }
        });
    }
}

