/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.dataimporter.DataInstaller;
import gov.nasa.worldwindx.applications.dataimporter.FileSet;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class FileSetPreviewImageGenerator
extends AVListImpl
implements Runnable {
    protected FileSet fileSet;
    protected int width;
    protected int height;
    protected BufferedImageRaster thumbnailRaster;

    public FileSetPreviewImageGenerator(FileSet fileSet, int n, int n2) {
        this.fileSet = fileSet;
        this.width = n;
        this.height = n2;
    }

    @Override
    public void run() {
        this.createImageRaster();
        this.composeImage();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FileSetPreviewImageGenerator.this.getPreviewImage() != null) {
                    FileSetPreviewImageGenerator.this.fileSet.setImage(FileSetPreviewImageGenerator.this.getPreviewImage());
                }
            }
        });
    }

    public BufferedImage getPreviewImage() {
        return this.thumbnailRaster != null ? this.thumbnailRaster.getBufferedImage() : null;
    }

    protected void createImageRaster() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        this.thumbnailRaster = new BufferedImageRaster(this.fileSet.getSector(), bufferedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void composeImage() {
        DataRasterReaderFactory dataRasterReaderFactory = DataInstaller.getReaderFactory();
        for (File file : this.fileSet.getFiles()) {
            AVListImpl aVListImpl;
            DataRasterReader dataRasterReader = dataRasterReaderFactory.findReaderFor((Object)file, (AVList)(aVListImpl = new AVListImpl()));
            if (dataRasterReader == null) {
                Logging.logger().fine("No reader for " + file.getPath());
                continue;
            }
            DataRaster dataRaster = null;
            try {
                DataRaster[] dataRasterArray = dataRasterReader.read((Object)file, (AVList)aVListImpl);
                if (dataRasterArray != null && dataRasterArray.length > 0) {
                    dataRaster = dataRasterArray[0];
                }
            }
            catch (Exception exception) {
                String string = Logging.getMessage((String)"generic.ExceptionWhileReading", (String)exception.getMessage());
                Logging.logger().finest(string);
            }
            if (dataRaster == null) {
                Logging.logger().fine("No raster for " + file.getPath());
                continue;
            }
            try {
                dataRaster.drawOnTo((DataRaster)this.thumbnailRaster);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "Exception composing preview image", exception);
            }
            finally {
                dataRaster.dispose();
            }
        }
    }
}

