/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwindx.applications.dataimporter.FileSet;
import gov.nasa.worldwindx.applications.dataimporter.FileSetMap;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class FileSetTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    protected static final String[] columnTitles = new String[]{"Key", "Preview", "Dataset Name", "Scale", "Type", "Files"};
    protected Set<FileSet> fileSets = new TreeSet<FileSet>(new Comparator<FileSet>(){

        @Override
        public int compare(FileSet fileSet, FileSet fileSet2) {
            return fileSet.getName().compareTo(fileSet2.getName());
        }
    });

    public FileSetTableModel(FileSetMap fileSetMap) {
        this.setFileSetMap(fileSetMap);
    }

    public void setFileSetMap(FileSetMap fileSetMap) {
        this.clearFileSets();
        if (fileSetMap != null) {
            for (Map.Entry entry : fileSetMap.entrySet()) {
                this.fileSets.add((FileSet)((Object)entry.getValue()));
                ((FileSet)((Object)entry.getValue())).addPropertyChangeListener(this);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.fileSets.size();
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public String getColumnName(int n) {
        return columnTitles[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Color.class;
            }
            case 1: {
                return ImageIcon.class;
            }
            case 5: {
                return Number.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        FileSet fileSet = this.getRow(n);
        switch (n2) {
            case 0: {
                return fileSet.getColor();
            }
            case 1: {
                return this.getImageIcon(n);
            }
            case 2: {
                return fileSet.getName() != null ? fileSet.getName() : "";
            }
            case 3: {
                return fileSet.getScale() != null ? fileSet.getScale() : "";
            }
            case 4: {
                return fileSet.getDataType() != null ? fileSet.getDataType() : "";
            }
            case 5: {
                return fileSet.getLength();
            }
        }
        return "unknown";
    }

    public Integer getRowForFileSet(FileSet fileSet) {
        int n = 0;
        for (FileSet fileSet2 : this.fileSets) {
            if (fileSet2 == fileSet) {
                return n;
            }
            ++n;
        }
        return null;
    }

    public FileSet getRow(int n) {
        Iterator<FileSet> iterator = this.fileSets.iterator();
        for (int i = 0; i < n; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    protected ImageIcon getImageIcon(int n) {
        FileSet fileSet = this.getRow(n);
        if (fileSet.getImageIcon() != null) {
            return fileSet.getImageIcon();
        }
        fileSet.addPropertyChangeListener("gov.nasa.worldwind.avkey.Image", this);
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.Image")) {
            FileSet fileSet = (FileSet)((Object)propertyChangeEvent.getSource());
            this.fireTableCellUpdated(this.getRowForFileSet(fileSet), 1);
            fileSet.removePropertyChangeListener("gov.nasa.worldwind.avkey.Image", this);
        }
    }

    protected void clearFileSets() {
        if (this.fileSets != null) {
            for (FileSet fileSet : this.fileSets) {
                fileSet.clear();
            }
        }
        this.fileSets.clear();
    }
}

