/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.util.DataConfigurationFilter;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.applications.dataimporter.FileStoreDataSet;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileStoreDataSetFinder {
    public List<FileStoreDataSet> findDataSets(FileStore fileStore) {
        ArrayList<FileStoreDataSet> arrayList = new ArrayList<FileStoreDataSet>();
        for (File file : fileStore.getLocations()) {
            if (!file.exists() || !fileStore.isInstallLocation(file.getPath())) continue;
            arrayList.addAll(this.findDataSets(file));
        }
        return arrayList;
    }

    protected List<FileStoreDataSet> findDataSets(File file) {
        if (file == null) {
            String string = Logging.getMessage((String)"nullValue.FileStorePathIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = WWIO.listDescendantFilenames((File)file, (FileFilter)new DataConfigurationFilter(), (boolean)false);
        if (stringArray == null || stringArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileStoreDataSet> arrayList = new ArrayList<FileStoreDataSet>();
        for (String string : stringArray) {
            File file2 = new File(string);
            arrayList.add(new FileStoreDataSet(file.getPath(), file.getPath() + File.separator + file2.getParent(), file.getPath() + File.separator + string));
        }
        return arrayList;
    }
}

