/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwindx.applications.dataimporter.FileStoreDataSet;
import gov.nasa.worldwindx.applications.dataimporter.FileStorePanel;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.util.ExampleUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileStoreSectorHighlighter
implements ListSelectionListener,
SelectListener {
    protected static final String SECTOR_LAYER = "SectorLayer";
    protected FileStorePanel fileStorePanel;
    protected WorldWindow wwd;
    List<FileStoreDataSet> currentlyHighlightedSets = new ArrayList<FileStoreDataSet>();

    public FileStoreSectorHighlighter(WorldWindow worldWindow, FileStorePanel fileStorePanel) {
        this.wwd = worldWindow;
        this.fileStorePanel = fileStorePanel;
        this.wwd.addSelectListener((SelectListener)this);
        this.fileStorePanel.addSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.handleSelection(this.fileStorePanel.getSelectedDataSets());
    }

    protected void handleSelection(List<FileStoreDataSet> list) {
        this.unHighlightSelectedSets();
        if (list == null || list.size() == 0) {
            return;
        }
        Sector sector = this.highlightSelectedSets(list);
        if (sector != null) {
            ExampleUtil.goTo(this.wwd, sector);
        } else {
            this.wwd.redraw();
        }
    }

    protected void unHighlightSelectedSets() {
        for (FileStoreDataSet fileStoreDataSet : this.currentlyHighlightedSets) {
            Layer layer = (Layer)fileStoreDataSet.getValue(SECTOR_LAYER);
            if (layer == null) continue;
            this.wwd.getModel().getLayers().remove(layer);
        }
        this.currentlyHighlightedSets.clear();
    }

    protected Sector highlightSelectedSets(List<FileStoreDataSet> list) {
        Sector sector = null;
        for (FileStoreDataSet fileStoreDataSet : list) {
            Layer layer = (Layer)fileStoreDataSet.getValue(SECTOR_LAYER);
            if (layer == null) {
                layer = this.createSectorLayer(fileStoreDataSet);
                layer.setValue("FileStoreDataSet", (Object)fileStoreDataSet);
                layer.setValue("gov.nasa.worldwind.avkey.Ignore", (Object)true);
            }
            this.currentlyHighlightedSets.add(fileStoreDataSet);
            ApplicationTemplate.insertBeforePlacenames(this.wwd, layer);
            Sector sector2 = fileStoreDataSet.getSector();
            if (sector2 == null) continue;
            sector = sector == null ? sector2 : sector.union(sector2);
        }
        return sector;
    }

    protected Layer createSectorLayer(FileStoreDataSet fileStoreDataSet) {
        RenderableLayer renderableLayer = new RenderableLayer();
        fileStoreDataSet.setValue(SECTOR_LAYER, renderableLayer);
        this.populateLayer(fileStoreDataSet, renderableLayer);
        return renderableLayer;
    }

    protected void populateLayer(FileStoreDataSet fileStoreDataSet, RenderableLayer renderableLayer) {
        Sector sector = (Sector)fileStoreDataSet.getValue("gov.nasa.worldwind.avKey.Sector");
        if (sector == null) {
            return;
        }
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        basicShapeAttributes.setOutlineMaterial(new Material(fileStoreDataSet.getColor()));
        basicShapeAttributes.setOutlineWidth(2.0);
        List list = sector.asList();
        ArrayList<Position> arrayList = new ArrayList<Position>(5);
        for (LatLon latLon : list) {
            arrayList.add(new Position(latLon, 0.0));
        }
        arrayList.add(new Position((LatLon)list.get(0), 0.0));
        arrayList.add(new Position((LatLon)list.get(0), 0.0));
        Path path = new Path(arrayList);
        path.setAltitudeMode(1);
        path.setFollowTerrain(true);
        path.setAttributes((ShapeAttributes)basicShapeAttributes);
        renderableLayer.addRenderable((Renderable)path);
    }

    public void selected(SelectEvent selectEvent) {
        if (!selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
            return;
        }
        if (!(selectEvent.getTopObject() instanceof Path)) {
            return;
        }
        FileStoreDataSet fileStoreDataSet = (FileStoreDataSet)((Object)selectEvent.getTopPickedObject().getParentLayer().getValue("FileStoreDataSet"));
        if (fileStoreDataSet == null) {
            return;
        }
        this.fileStorePanel.scrollToDataSet(fileStoreDataSet);
    }
}

