/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Layer;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;

public class LayersMenu
extends JMenu {
    public LayersMenu(final WorldWindow worldWindow) {
        super("Layers");
        this.fill(worldWindow);
        worldWindow.getModel().getLayers().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.LayersObject")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LayersMenu.this.update(worldWindow);
                        }
                    });
                }
            }
        });
    }

    public void update(WorldWindow worldWindow) {
        this.fill(worldWindow);
    }

    protected void fill(WorldWindow worldWindow) {
        this.removeAll();
        for (Layer layer : worldWindow.getModel().getLayers()) {
            if (layer.getValue("gov.nasa.worldwind.avkey.Ignore") != null) continue;
            LayerAction layerAction = new LayerAction(layer, worldWindow, layer.isEnabled());
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(layerAction);
            jCheckBoxMenuItem.setSelected(layerAction.selected);
            this.add(jCheckBoxMenuItem);
        }
    }

    protected static class LayerAction
    extends AbstractAction {
        WorldWindow wwd;
        protected Layer layer;
        protected boolean selected;

        public LayerAction(Layer layer, WorldWindow worldWindow, boolean bl) {
            super(layer.getName());
            this.wwd = worldWindow;
            this.layer = layer;
            this.selected = bl;
            this.layer.setEnabled(this.selected);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()) {
                this.layer.setEnabled(true);
            } else {
                this.layer.setEnabled(false);
            }
            this.wwd.redraw();
        }
    }
}

