/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.eurogeoss;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;

public class GetRecordsRequest {
    protected int startPosition = 1;
    protected int maxRecords = 10;
    protected String searchText;

    public GetRecordsRequest() {
    }

    public GetRecordsRequest(GetRecordsRequest getRecordsRequest) {
        if (getRecordsRequest == null) {
            String string = Logging.getMessage((String)"nullValue.RequestIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.startPosition = getRecordsRequest.startPosition;
        this.maxRecords = getRecordsRequest.maxRecords;
        this.searchText = getRecordsRequest.searchText;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int n) {
        this.startPosition = n;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(int n) {
        this.maxRecords = n;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String string) {
        this.searchText = string;
    }

    public String toXMLString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<csw:GetRecords");
        stringBuilder.append(" service=\"CSW\"");
        stringBuilder.append(" version=\"2.0.2\"");
        stringBuilder.append(" resultType=\"results\"");
        stringBuilder.append(" outputFormat=\"application/xml\"");
        stringBuilder.append(" outputSchema=\"http://www.isotc211.org/2005/gmd\"");
        stringBuilder.append(" startPosition=\"").append(this.startPosition).append("\"");
        stringBuilder.append(" maxRecords=\"").append(this.maxRecords).append("\"");
        stringBuilder.append(" xmlns:ogc=\"http://www.opengis.net/ogc\"");
        stringBuilder.append(" xmlns:csw=\"http://www.opengis.net/cat/csw/2.0.2\"");
        stringBuilder.append(" xmlns:gmd=\"http://www.isotc211.org/2005/gmd\"");
        stringBuilder.append(">");
        stringBuilder.append("<csw:Query");
        stringBuilder.append(" typeNames=\"gmd:MD_Metadata\"");
        stringBuilder.append(">");
        stringBuilder.append("<csw:ElementSetName");
        stringBuilder.append(" typeNames=\"gmd:MD_Metadata\"");
        stringBuilder.append(">");
        stringBuilder.append("full");
        stringBuilder.append("</csw:ElementSetName>");
        stringBuilder.append("<csw:Constraint");
        stringBuilder.append(" version=\"1.1.0\"");
        stringBuilder.append(">");
        stringBuilder.append("<ogc:Filter>");
        if (!WWUtil.isEmpty((Object)this.searchText)) {
            stringBuilder.append("<ogc:And>");
            stringBuilder.append("<ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">");
            stringBuilder.append("<ogc:PropertyName>csw:AnyText</ogc:PropertyName>");
            stringBuilder.append("<ogc:Literal>").append(this.searchText).append("</ogc:Literal>");
            stringBuilder.append("</ogc:PropertyIsLike>");
        }
        stringBuilder.append("<ogc:PropertyIsLike wildCard=\"*\" singleChar=\"#\" escapeChar=\"!\">");
        stringBuilder.append("<ogc:PropertyName>csw:AnyText</ogc:PropertyName>");
        stringBuilder.append("<ogc:Literal>urn:ogc:serviceType:WebMapService:*</ogc:Literal>");
        stringBuilder.append("</ogc:PropertyIsLike>");
        if (!WWUtil.isEmpty((Object)this.searchText)) {
            stringBuilder.append("</ogc:And>");
        }
        stringBuilder.append("</ogc:Filter>");
        stringBuilder.append("</csw:Constraint>");
        stringBuilder.append("</csw:Query>");
        stringBuilder.append("</csw:GetRecords>");
        return stringBuilder.toString();
    }
}

