/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.eurogeoss;

import gov.nasa.worldwind.util.WWXML;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class OnlineResource {
    protected String linkage;
    protected String name;
    protected String protocol;

    public OnlineResource() {
    }

    public OnlineResource(XMLEventReader xMLEventReader) throws XMLStreamException {
        this.parseElement(xMLEventReader);
    }

    public String getLinkage() {
        return this.linkage;
    }

    public void setLinkage(String string) {
        this.linkage = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public boolean isWMSOnlineResource() {
        return this.protocol != null && this.protocol.startsWith("urn:ogc:serviceType:WebMapService:");
    }

    protected void parseElement(XMLEventReader xMLEventReader) throws XMLStreamException {
        int n = 0;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                String string = startElement.getName().getLocalPart();
                ++n;
                if (string.equals("name")) {
                    this.name = WWXML.readCharacters((XMLEventReader)xMLEventReader).trim();
                    continue;
                }
                if (string.equals("linkage")) {
                    this.linkage = WWXML.readCharacters((XMLEventReader)xMLEventReader).trim();
                    continue;
                }
                if (string.equals("protocol")) {
                    this.protocol = WWXML.readCharacters((XMLEventReader)xMLEventReader).trim();
                    continue;
                }
                xMLEventReader.nextEvent();
                continue;
            }
            if (xMLEvent.isEndElement()) {
                if (--n <= 0) break;
                xMLEventReader.nextEvent();
                continue;
            }
            xMLEventReader.nextEvent();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OnlineResource onlineResource = (OnlineResource)object;
        if (this.linkage != null ? !this.linkage.equals(onlineResource.linkage) : onlineResource.linkage != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(onlineResource.name) : onlineResource.name != null) {
            return false;
        }
        return !(this.protocol != null ? !this.protocol.equals(onlineResource.protocol) : onlineResource.protocol != null);
    }

    public int hashCode() {
        int n = this.linkage != null ? this.linkage.hashCode() : 0;
        n = 31 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 31 * n + (this.protocol != null ? this.protocol.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("linkage=").append(this.linkage);
        stringBuilder.append(",name=").append(this.name);
        stringBuilder.append(",protocol=").append(this.protocol);
        return stringBuilder.toString();
    }
}

