/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.eurogeoss;

import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwindx.applications.eurogeoss.OnlineResource;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Record {
    protected String title;
    protected Collection<OnlineResource> wmsOnlineResources = new LinkedHashSet<OnlineResource>();
    protected OnlineResource currentResource;
    protected LinkedList<String> nameStack = new LinkedList();

    public Record() {
    }

    public Record(XMLEventReader xMLEventReader) throws XMLStreamException {
        this.parseElement(xMLEventReader);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Collection<OnlineResource> getWmsOnlineResources() {
        return this.wmsOnlineResources;
    }

    public void setWmsOnlineResources(Collection<OnlineResource> collection) {
        this.wmsOnlineResources = collection;
    }

    protected void parseElement(XMLEventReader xMLEventReader) throws XMLStreamException {
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                String string = startElement.getName().getLocalPart();
                this.nameStack.addLast(string);
                if (string.equals("title") && this.nameStack.contains("identificationInfo")) {
                    this.title = WWXML.readCharacters((XMLEventReader)xMLEventReader).trim();
                    continue;
                }
                if (string.equals("CI_OnlineResource") && this.nameStack.contains("distributionInfo")) {
                    OnlineResource onlineResource = new OnlineResource(xMLEventReader);
                    if (!onlineResource.isWMSOnlineResource()) continue;
                    this.wmsOnlineResources.add(onlineResource);
                    continue;
                }
                xMLEventReader.nextEvent();
                continue;
            }
            if (xMLEvent.isEndElement()) {
                this.nameStack.removeLast();
                if (this.nameStack.size() <= 0) break;
                xMLEventReader.nextEvent();
                continue;
            }
            xMLEventReader.nextEvent();
        }
    }
}

