/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.eurogeoss;

import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.eurogeoss.OnlineResource;
import gov.nasa.worldwindx.applications.eurogeoss.Record;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RecordPanel
extends JPanel
implements ActionListener {
    protected Record record;
    protected WorldWindow wwd;
    protected List<Layer> layerList;
    protected Layer activeLayer;
    protected JCheckBox layerCheckBox;
    protected JComboBox layerComboBox;
    protected int statusCode;
    protected static final ExecutorService layerExecutor = Executors.newFixedThreadPool(4);
    protected static final ImageIcon activityIcon = new ImageIcon(RecordPanel.class.getResource("/gov/nasa/worldwindx/applications/eurogeoss/images/activity-indicator-16.gif"));
    protected static final ImageIcon errorIcon = new ImageIcon(RecordPanel.class.getResource("/gov/nasa/worldwindx/applications/eurogeoss/images/error.gif"));
    protected static final int PANEL_PREFERRED_HEIGHT = 25;
    protected static final int COMBO_BOX_PREFERRED_WIDTH = 350;
    protected static final int STATUS_NO_ONLINE_RESOURCES = 1;
    protected static final int STATUS_INVALID_LAYER_NAME = 2;
    protected static final int STATUS_EXCEPTION_CREATING_LAYER = 4;

    public RecordPanel(Record record, WorldWindow worldWindow) {
        if (record == null) {
            String string = Logging.getMessage((String)"nullValue.RecordIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (worldWindow == null) {
            String string = Logging.getMessage((String)"nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.record = record;
        this.wwd = worldWindow;
        this.setLayout(new BoxLayout(this, 0));
        this.assembleLayers();
        this.layoutComponents();
    }

    protected void layoutComponents() {
        this.removeAll();
        String string = this.makeTitle();
        String string2 = this.makeToolTipText();
        if (this.layerList == null) {
            JLabel jLabel = new JLabel(string, activityIcon, 2);
            jLabel.setToolTipText(string2);
            jLabel.setPreferredSize(new JCheckBox(string).getPreferredSize());
            this.add(jLabel);
        } else if (this.layerList.size() == 0) {
            JLabel jLabel = new JLabel(string, errorIcon, 2);
            jLabel.setToolTipText(string2);
            jLabel.setPreferredSize(new JCheckBox(string).getPreferredSize());
            this.add(jLabel);
        } else if (this.layerList.size() == 1) {
            this.activeLayer = this.layerList.get(0);
            this.layerCheckBox = new JCheckBox(string);
            this.layerCheckBox.setToolTipText(string2);
            this.layerCheckBox.addActionListener(this);
            this.add(this.layerCheckBox);
        } else {
            this.activeLayer = this.layerList.get(0);
            this.layerCheckBox = new JCheckBox();
            this.layerCheckBox.addActionListener(this);
            this.layerComboBox = new JComboBox<Object>(this.layerList.toArray());
            this.layerComboBox.setPreferredSize(new Dimension(350, this.layerComboBox.getPreferredSize().height));
            this.layerComboBox.setMaximumSize(new Dimension(350, Integer.MAX_VALUE));
            this.layerComboBox.setToolTipText(string2);
            this.layerComboBox.addActionListener(this);
            this.add(this.layerCheckBox);
            this.add(this.layerComboBox);
        }
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 25));
        this.validate();
    }

    protected String makeTitle() {
        return WWUtil.isEmpty((Object)this.record.getTitle()) ? "Untitled" : this.record.getTitle();
    }

    protected String makeToolTipText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(this.makeTitle());
        if (this.statusCode != 0) {
            stringBuilder.append("<font color=\"red\">");
            if ((this.statusCode & 1) != 0) {
                stringBuilder.append("<br/>");
                stringBuilder.append("No layers");
            }
            if ((this.statusCode & 2) != 0 || (this.statusCode & 4) != 0) {
                stringBuilder.append("<br/>");
                stringBuilder.append("Invalid layers");
            }
            stringBuilder.append("</font>");
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.layerCheckBox)) {
            if (this.layerCheckBox.isSelected()) {
                this.wwd.getModel().getLayers().add(this.activeLayer);
            } else {
                this.wwd.getModel().getLayers().remove(this.activeLayer);
            }
        } else if (actionEvent.getSource().equals(this.layerComboBox)) {
            if (this.layerCheckBox.isSelected()) {
                this.wwd.getModel().getLayers().remove(this.activeLayer);
            }
            this.activeLayer = (Layer)this.layerComboBox.getSelectedItem();
            if (this.layerCheckBox.isSelected()) {
                this.wwd.getModel().getLayers().add(this.activeLayer);
            }
        }
    }

    protected void assembleLayers() {
        final Collection<OnlineResource> collection = this.record.getWmsOnlineResources();
        if (collection != null && collection.size() > 0) {
            layerExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    final ArrayList<Layer> arrayList = new ArrayList<Layer>();
                    for (OnlineResource onlineResource : collection) {
                        RecordPanel.this.addLayersForOnlineResource(onlineResource, arrayList);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RecordPanel.this.layerList = arrayList;
                            RecordPanel.this.layoutComponents();
                        }
                    });
                }
            });
        } else {
            this.layerList = Collections.emptyList();
            this.statusCode |= 1;
            String string = "Record has no WMS online resources " + this.record.getTitle();
            Logging.logger().warning(string);
        }
    }

    protected void addLayersForOnlineResource(OnlineResource onlineResource, Collection<Layer> collection) {
        try {
            WMSCapabilities wMSCapabilities = (WMSCapabilities)WorldWind.getSessionCache().get((Object)onlineResource.getLinkage());
            if (wMSCapabilities == null) {
                wMSCapabilities = WMSCapabilities.retrieve((URI)new URI(onlineResource.getLinkage()));
                wMSCapabilities.parse(new Object[0]);
                WorldWind.getSessionCache().put((Object)onlineResource.getLinkage(), (Object)wMSCapabilities);
            }
            if (WWUtil.isEmpty((Object)onlineResource.getName())) {
                for (WMSLayerCapabilities wMSLayerCapabilities : wMSCapabilities.getNamedLayers()) {
                    collection.add(this.createLayer(wMSCapabilities, wMSLayerCapabilities.getName()));
                }
                String string = "Online resource has no name " + onlineResource + ", using all layers";
                Logging.logger().warning(string);
            } else {
                WMSLayerCapabilities wMSLayerCapabilities = wMSCapabilities.getLayerByName(onlineResource.getName());
                if (wMSLayerCapabilities == null) {
                    wMSLayerCapabilities = this.findLayerMatchingName(wMSCapabilities, onlineResource.getName());
                }
                if (wMSLayerCapabilities == null) {
                    this.statusCode |= 2;
                    String string = "Unable to find layer for online resource " + onlineResource;
                    Logging.logger().warning(string);
                } else {
                    collection.add(this.createLayer(wMSCapabilities, wMSLayerCapabilities.getName()));
                }
            }
        }
        catch (Exception exception) {
            this.statusCode |= 4;
            String string = "Exception creating layer for online resource " + onlineResource;
            Logging.logger().log(Level.WARNING, string);
            Logging.logger().log(Level.FINEST, string, exception);
        }
    }

    protected Layer createLayer(WMSCapabilities wMSCapabilities, String string) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LayerNames", (Object)string);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", (Object)30000);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", (Object)30000);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", (Object)60000);
        Factory factory = (Factory)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.LayerFactory");
        Layer layer = (Layer)factory.createFromConfigSource((Object)wMSCapabilities, (AVList)aVListImpl);
        layer.setOpacity(0.6);
        return layer;
    }

    protected WMSLayerCapabilities findLayerMatchingName(WMSCapabilities wMSCapabilities, String string) {
        for (WMSLayerCapabilities wMSLayerCapabilities : wMSCapabilities.getNamedLayers()) {
            if (!wMSLayerCapabilities.getName().contains(string) && !string.contains(wMSLayerCapabilities.getName()) && !wMSLayerCapabilities.getTitle().contains(string) && !string.contains(wMSLayerCapabilities.getTitle())) continue;
            return wMSLayerCapabilities;
        }
        return null;
    }
}

